/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBufferOutputStream
extends WSServletOutputStream {
    private List<WsByteBuffer> bbList = new ArrayList<WsByteBuffer>();
    private WsByteBuffer current = null;
    private boolean _hasWritten = false;
    private int bufferSize = 8192;
    protected int count;
    protected int total;
    protected int limit = -1;
    private IOutputStreamObserver obs;
    private IOException except;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.ByteBufferOutputStream";
    private boolean committed = false;
    private boolean byteBuffersRetrieved;
    private IResponse response;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public List<WsByteBuffer> getByteBufferList() {
        this.byteBuffersRetrieved = true;
        return this.bbList;
    }

    @Override
    public void reset() {
        this.current = null;
        this._hasWritten = false;
        this.byteBuffersRetrieved = false;
        this.limit = -1;
        this.total = 0;
        if (!this.byteBuffersRetrieved) {
            ListIterator<WsByteBuffer> it = this.bbList.listIterator();
            while (it.hasNext()) {
                WsByteBuffer next = it.next();
                next.release();
                it.remove();
            }
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "write --> " + ch + ", limit->" + this.limit);
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        this.checkList();
        this.current.put((byte)ch);
        ++this.total;
    }

    @Override
    public void write(byte[] buf, int offset, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "write len --> " + len + ", limit->" + this.limit);
        }
        if (len < 0) {
            logger.logp(Level.SEVERE, CLASS_NAME, "write", "Illegal.Argument.Trying.to.write.chars");
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total + len > this.limit) {
            len = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        int toWrite = 0;
        int amountWritten = 0;
        int remaining = 0;
        while (amountWritten != len) {
            this.checkList();
            toWrite = len - amountWritten;
            remaining = this.current.remaining();
            if (toWrite <= remaining) {
                this.current.put(buf, offset + amountWritten, toWrite);
                amountWritten += toWrite;
                continue;
            }
            this.current.put(buf, offset + amountWritten, remaining);
            amountWritten += remaining;
        }
        this.count += len;
        this.total += len;
        this.check();
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    private void checkList() {
        if (this.current == null) {
            this.current = this.getNewByteBuffer();
            this.bbList.add(this.current);
        } else {
            if (this.current.hasRemaining()) {
                return;
            }
            this.current.flip();
            this.current = this.getNewByteBuffer();
            this.bbList.add(this.current);
        }
    }

    private WsByteBuffer getNewByteBuffer() {
        return WsByteBufferPoolManagerImpl.getRef().allocateDirect(this.bufferSize);
    }

    public void writeTo(OutputStream os) {
        try {
            for (WsByteBuffer bb : this.bbList) {
                byte[] b = new byte[bb.limit()];
                bb.get(b);
                os.write(b);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream arrayOS = new ByteArrayOutputStream();
        this.writeTo(arrayOS);
        return arrayOS.toByteArray();
    }

    @Override
    public void clearBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clearBuffer", "clearBuffer");
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "clearBuffer", "clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException("clearBuffer(): illegal state--> stream is committed ");
        }
        ListIterator<WsByteBuffer> it = this.bbList.listIterator();
        while (it.hasNext()) {
            WsByteBuffer next = it.next();
            next.release();
            it.remove();
        }
        this.total = 0;
        this.count = 0;
        this._hasWritten = false;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.current != null && this.current.position() != 0) {
            this.current.flip();
        }
        this.commit();
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void init(OutputStream out, int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isCommitted() {
        if (!this.committed) {
            this.committed = this.total >= this.bufferSize;
        }
        return this.committed;
    }

    @Override
    public void setBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setBufferSize", "setBufferSize --> " + size);
        }
        if (this.total > 0) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setBufferSize", "setBufferSize(): illegal state--> already wrote " + this.total + " bytes");
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.clearBuffer();
    }

    @Override
    public void setLimit(int contentLength) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setLimit", "setLimit(): contentLength->" + contentLength);
        }
        this.limit = contentLength;
    }

    @Override
    public void setObserver(IOutputStreamObserver obs) {
        this.obs = obs;
    }

    @Override
    public void setResponse(IResponse response) {
        this.response = response;
    }

    @Override
    public void flush() throws IOException {
        this.commit();
    }

    private void commit() {
        this.committed = true;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public void addObserver(IOutputStreamObserver obs) {
    }
}

