/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.util;

import com.ibm.wsspi.util.WsMapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WsMap
implements Map {
    private static final Object[] NO_VALUES = new Object[0];
    private static final Object REMOVED = new WsMapFactory();
    private final WsMapFactory factory;
    private Object[] values;
    private int removeCount;

    protected WsMap(WsMapFactory factory) {
        this.factory = factory;
        this.values = new Object[factory.keySize()];
        this.removeCount = 0;
    }

    public Object get(int index) {
        if (index >= this.values.length) {
            return null;
        }
        Object value = this.values[index];
        if (value == REMOVED) {
            return null;
        }
        return value;
    }

    public Object put(int index, Object value) {
        Object oldVal;
        if (index >= this.values.length) {
            Object[] newValues = new Object[index + 1];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.values = newValues;
        }
        if ((oldVal = this.values[index]) == REMOVED) {
            --this.removeCount;
        }
        this.values[index] = value;
        return oldVal;
    }

    public int size() {
        return this.values.length - this.removeCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        int index = this.factory.getIndex(key, false);
        if (index < 0 || index >= this.values.length) {
            return false;
        }
        Object value = this.values[index];
        return value != REMOVED;
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        int idx = this.factory.getIndex(key, false);
        if (idx < 0) {
            return null;
        }
        return this.get(idx);
    }

    public Object put(Object key, Object value) {
        return this.put(this.factory.getIndex(key), value);
    }

    public Object remove(Object key) {
        int idx = this.factory.getIndex(key, false);
        if (idx < 0 || idx >= this.values.length) {
            return null;
        }
        Object value = this.values[idx];
        if (value == REMOVED) {
            return null;
        }
        if (value != REMOVED) {
            ++this.removeCount;
        }
        this.values[idx] = REMOVED;
        return value;
    }

    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public void clear() {
        this.values = NO_VALUES;
        this.removeCount = 0;
    }

    public Set keySet() {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == REMOVED) continue;
            set.add(this.factory.getKey(i));
        }
        return set;
    }

    public Collection values() {
        ArrayList<Object> valList = new ArrayList<Object>();
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            if (value == REMOVED) continue;
            valList.add(value);
        }
        return valList;
    }

    public Set entrySet() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            if (value == REMOVED) continue;
            map.put(this.factory.getKey(i), value);
        }
        return map.entrySet();
    }
}

