/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.service;

import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.security.util.AccessController;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsServiceRegistry {
    private static boolean traceServiceOps = false;
    private static boolean traceServiceOpsStack = false;
    private static PrintStream log = null;

    private static void trace(String op, Object requestor, Class serviceInterface) {
        Class<?> requestorClass = requestor instanceof Class ? (Class<?>)requestor : requestor.getClass();
        log.println("[" + op + "]" + " interface=" + serviceInterface.getName() + " requestor=" + requestorClass.getName());
        if (traceServiceOpsStack) {
            log.println("\tStack : ======================================");
            new Exception().printStackTrace(log);
        }
    }

    public static Object addService(Object serviceImplementation, Class serviceInterface) throws Exception {
        BundleContext context;
        if (traceServiceOps) {
            WsServiceRegistry.trace("ADD", serviceImplementation, serviceInterface);
        }
        if ((context = WsServiceRegistry.getBundleContext(serviceImplementation)) != null) {
            ServiceRegistration reg = context.registerService(serviceInterface.getName(), serviceImplementation, null);
            if (reg == null) {
                throw new Exception("Registration failed for service " + serviceInterface.getClass().getName());
            }
            return reg;
        }
        throw new Exception("Cannot find BundleContext for service " + serviceImplementation.getClass().getName());
    }

    public static void unregisterService(Object token) {
        if (!(token instanceof ServiceRegistration)) {
            throw new IllegalArgumentException("Token (" + token + ") does not appear to be associated with a service");
        }
        ((ServiceRegistration)token).unregister();
    }

    public static <T> T getService(Object requestor, Class<T> serviceInterface) throws Exception {
        BundleContext context;
        Object service = null;
        if (traceServiceOps) {
            WsServiceRegistry.trace("GET", requestor, serviceInterface);
        }
        if ((context = WsServiceRegistry.getBundleContext(requestor)) != null) {
            ServiceReference ref = context.getServiceReference(serviceInterface.getName());
            if (ref != null) {
                service = context.getService(ref);
            }
        } else {
            throw new Exception("Cannot find BundleContext for requestor " + requestor.getClass().getName());
        }
        return (T)service;
    }

    public static <T> T getRequiredService(Object requestor, Class<T> serviceInterface) {
        T service;
        try {
            service = WsServiceRegistry.getService(requestor, serviceInterface);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        if (service == null) {
            throw new IllegalStateException("service unavailable: " + serviceInterface.getName());
        }
        return service;
    }

    private static BundleContext getBundleContext(final Object requestor) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<?> requestorClass = requestor instanceof Class ? (Class<?>)requestor : requestor.getClass();
                return requestorClass.getClassLoader();
            }
        });
        BundleContext context = BundleContextMap.instance().get(cl);
        if (context == null) {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return WsServiceRegistry.class.getClassLoader();
                }
            });
            context = BundleContextMap.instance().get(cl);
        }
        return context;
    }

    public static void registerBundleContext(BundleActivator activator, BundleContext context) throws Exception {
        if (activator == null) {
            throw new IllegalArgumentException("BundleActivator is required but null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("BundleContext is required but null.");
        }
        ClassLoader cl = activator.getClass().getClassLoader();
        BundleContext bc = BundleContextMap.instance().get(cl);
        if (bc != null && bc != context) {
            throw new Exception("BundleContext already registered.");
        }
        BundleContextMap.instance().put(cl, context);
    }

    public static void unregisterBundleContext(BundleActivator activator, BundleContext context) throws Exception {
        ClassLoader cl = activator.getClass().getClassLoader();
        BundleContext bc = BundleContextMap.instance().get(cl);
        if (bc != context) {
            throw new Exception("BundleContext does not match with registered.");
        }
        BundleContextMap.instance().remove(cl);
    }

    static {
        try {
            traceServiceOps = Boolean.getBoolean("ws.service.debug");
            if (traceServiceOps) {
                String logFile = System.getProperty("ws.service.debug.log", "WasServices.log");
                if (logFile != null && logFile.length() != 0) {
                    log = new PrintStream(new FileOutputStream(logFile));
                }
                traceServiceOpsStack = Boolean.getBoolean("ws.service.debug.stack");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

