/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.BaseVersionValues;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionValues
extends BaseVersionValues {
    private static int NEXT_ORDINAL = 0;
    private static final List<VersionValues> allKeys = new ArrayList<VersionValues>();
    private static final VersionValuesMatcher myMatcher = new VersionValuesMatcher();
    public static final VersionValues UNDEF = new VersionValues("Undefined");
    public static final VersionValues V09 = new VersionValues("HTTP/0.9");
    public static final VersionValues V10 = new VersionValues("HTTP/1.0");
    public static final VersionValues V11 = new VersionValues("HTTP/1.1");
    private boolean undefined = false;

    public VersionValues(String name) {
        super(name, VersionValues.nextOrdinal());
        allKeys.add(this);
        myMatcher.add(this);
    }

    protected VersionValues(int major, int minor) {
        super("HTTP", major, minor, VersionValues.nextOrdinal());
        allKeys.add(this);
        myMatcher.add(this);
    }

    private static synchronized int nextOrdinal() {
        return NEXT_ORDINAL++;
    }

    public static List<VersionValues> getAllKeys() {
        return allKeys;
    }

    public static VersionValues getByOrdinal(int i) {
        return allKeys.get(i);
    }

    public static VersionValues makeUndefinedValue(byte[] value) {
        return VersionValues.find(value);
    }

    public static VersionValues makeUndefinedValue(String value) {
        return VersionValues.find(value);
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    protected void setUndefined(boolean flag) {
        this.undefined = flag;
    }

    @Override
    protected void parseVersion() {
        if ("undefined".equalsIgnoreCase(this.getName())) {
            return;
        }
        super.parseVersion();
        if (!"http".equalsIgnoreCase(this.getProtocolName())) {
            throw new IllegalArgumentException("Protocol is not HTTP");
        }
    }

    public static VersionValues match(String name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return myMatcher.match(name, offset, length, false);
    }

    public static VersionValues match(byte[] name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return myMatcher.match(name, offset, length, false);
    }

    public static VersionValues find(byte[] name, int offset, int length) {
        return myMatcher.match(name, offset, length, true);
    }

    public static VersionValues find(String name) {
        return myMatcher.match(name, 0, name.length(), true);
    }

    public static VersionValues find(byte[] name) {
        return myMatcher.match(name, 0, name.length, true);
    }

    private static class VersionBucket {
        private VersionValues[] list = new VersionValues[0];

        protected VersionBucket() {
        }

        protected void add(VersionValues key) {
            int minor = key.getMinor();
            if (minor >= this.list.length) {
                VersionValues[] newlist = new VersionValues[minor + 1];
                for (int i = 0; i < this.list.length; ++i) {
                    newlist[i] = this.list[i];
                }
                this.list = newlist;
            }
            this.list[minor] = key;
        }

        protected VersionValues get(int minor) {
            if (minor >= this.list.length) {
                return null;
            }
            return this.list[minor];
        }
    }

    private static class VersionValuesMatcher {
        private static final byte[] HTTP_BYTES = new byte[]{72, 84, 84, 80, 47};
        private static final char[] HTTP_CHARS = new char[]{'H', 'T', 'T', 'P', '/'};
        private VersionBucket[] list = new VersionBucket[2];

        protected VersionValuesMatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected VersionValues match(String name, int offset, int length, boolean create) {
            VersionValues val;
            if (null == name || 8 > length) {
                if (!create) return null;
                throw new IllegalArgumentException("Invalid version: " + name + " " + offset + " " + length);
            }
            int i = offset;
            char[] data = name.toCharArray();
            for (int x = 0; x < 5; ++x) {
                if (data[i] != HTTP_CHARS[x]) {
                    if (!create) return null;
                    throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
                }
                ++i;
            }
            int major = -1;
            while (i < data.length && '.' != data[i]) {
                char c = data[i];
                if ('0' <= c && '9' >= c) {
                    if (-1 == major) {
                        major = c - 48;
                    } else {
                        major *= 10;
                        major += c - 48;
                    }
                } else if (' ' == c || '\t' == c) {
                    if (0 < major) {
                        while (i < data.length && '.' != data[i]) {
                            if (' ' != data[i] && '\t' != data[i]) {
                                if (!create) return null;
                                throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
                            }
                            ++i;
                        }
                        break;
                    }
                } else {
                    if (!create) return null;
                    throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
                }
                ++i;
            }
            if (-1 == major || ++i >= data.length) {
                if (!create) return null;
                throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
            }
            int minor = -1;
            while (i < data.length && '.' != data[i]) {
                char c = data[i];
                if ('0' <= c && '9' >= c) {
                    if (-1 == minor) {
                        minor = c - 48;
                    } else {
                        minor *= 10;
                        minor += c - 48;
                    }
                } else if (' ' == c || '\t' == c) {
                    if (0 < minor) {
                        while (i < data.length) {
                            if (' ' != data[i] && '\t' != data[i]) {
                                if (!create) return null;
                                throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
                            }
                            ++i;
                        }
                        break;
                    }
                } else {
                    if (!create) return null;
                    throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
                }
                ++i;
            }
            if (-1 == minor) {
                if (!create) return null;
                throw new IllegalArgumentException("Invalid version: " + name.substring(offset, offset + length));
            }
            VersionBucket bucket = this.get(major);
            VersionValues versionValues = val = null == bucket ? null : bucket.get(minor);
            if (null != val || !create) return val;
            Class<VersionValues> clazz = VersionValues.class;
            synchronized (VersionValues.class) {
                bucket = this.get(major);
                VersionValues versionValues2 = val = null == bucket ? null : bucket.get(minor);
                if (null != val) return val;
                val = new VersionValues(major, minor);
                val.setUndefined(true);
                // ** MonitorExit[var11_12] (shouldn't be in output)
                return val;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected VersionValues match(byte[] data, int offset, int length, boolean create) {
            VersionValues val;
            if (null == data || 8 > length) {
                if (!create) return null;
                throw new IllegalArgumentException("Invalid version: " + data + " " + offset + " " + length);
            }
            int i = offset;
            for (int x = 0; x < 5; ++x) {
                if (data[i] != HTTP_BYTES[x]) {
                    if (!create) return null;
                    throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
                }
                ++i;
            }
            int major = -1;
            while (i < data.length && 46 != data[i]) {
                byte c = data[i];
                if (48 <= c && 57 >= c) {
                    if (-1 == major) {
                        major = c - 48;
                    } else {
                        major *= 10;
                        major += c - 48;
                    }
                } else if (32 == c || 9 == c) {
                    if (0 < major) {
                        while (i < data.length && 46 != data[i]) {
                            if (32 != data[i] && 9 != data[i]) {
                                if (!create) return null;
                                throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
                            }
                            ++i;
                        }
                        break;
                    }
                } else {
                    if (!create) return null;
                    throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
                }
                ++i;
            }
            if (-1 == major || ++i >= data.length) {
                if (!create) return null;
                throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
            }
            int minor = -1;
            while (i < data.length && 46 != data[i]) {
                byte c = data[i];
                if (48 <= c && 57 >= c) {
                    if (-1 == minor) {
                        minor = c - 48;
                    } else {
                        minor *= 10;
                        minor += c - 48;
                    }
                } else if (32 == c || 9 == c) {
                    if (0 < minor) {
                        while (i < data.length) {
                            if (32 != data[i] && 9 != data[i]) {
                                if (!create) return null;
                                throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
                            }
                            ++i;
                        }
                        break;
                    }
                } else {
                    if (!create) return null;
                    throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
                }
                ++i;
            }
            if (-1 == minor) {
                if (!create) return null;
                throw new IllegalArgumentException("Invalid version: " + new String(data, offset, length));
            }
            VersionBucket bucket = this.get(major);
            VersionValues versionValues = val = null == bucket ? null : bucket.get(minor);
            if (null != val || !create) return val;
            Class<VersionValues> clazz = VersionValues.class;
            synchronized (VersionValues.class) {
                bucket = this.get(major);
                VersionValues versionValues2 = val = null == bucket ? null : bucket.get(minor);
                if (null != val) return val;
                val = new VersionValues(major, minor);
                val.setUndefined(true);
                // ** MonitorExit[var10_11] (shouldn't be in output)
                return val;
            }
        }

        protected synchronized void add(VersionValues key) {
            VersionBucket bucket;
            int major = key.getMajor();
            if (major >= this.list.length) {
                VersionBucket[] newlist = new VersionBucket[major + 1];
                for (int i = 0; i < this.list.length; ++i) {
                    newlist[i] = this.list[i];
                }
                this.list = newlist;
            }
            if (null == (bucket = this.list[major])) {
                this.list[major] = bucket = new VersionBucket();
            }
            bucket.add(key);
        }

        private VersionBucket get(int major) {
            if (major >= this.list.length) {
                return null;
            }
            return this.list[major];
        }
    }
}

