/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.error.HttpError;

public class StatusCodes
extends GenericKeys {
    private static final int MAX_CODE = 750;
    private static StatusCodes[] statusCodes = new StatusCodes[751];
    public static final StatusCodes UNDEF = new StatusCodes(0, "Undefined", false);
    public static final StatusCodes ACCEPTED = new StatusCodes(202, "Accepted", false);
    public static final StatusCodes BAD_GATEWAY = new StatusCodes(502, "Bad Gateway", true);
    public static final StatusCodes BAD_METHOD = new StatusCodes(405, "Method Not Allowed", true);
    public static final StatusCodes BAD_REQUEST = new StatusCodes(400, "Bad Request", true);
    public static final StatusCodes CONFLICT = new StatusCodes(409, "Conflict", true);
    public static final StatusCodes CONTINUE = new StatusCodes(100, "Continue", false);
    public static final StatusCodes CREATED = new StatusCodes(201, "Created", false);
    public static final StatusCodes ENTITY_TOO_LARGE = new StatusCodes(413, "Request Entity Too Large", true);
    public static final StatusCodes EXPECTATION_FAILED = new StatusCodes(417, "Expectation Failed", true);
    public static final StatusCodes FORBIDDEN = new StatusCodes(403, "Forbidden", true);
    public static final StatusCodes FOUND = new StatusCodes(302, "Found", false);
    public static final StatusCodes GATEWAY_TIMEOUT = new StatusCodes(504, "Gateway Timeout", true);
    public static final StatusCodes GONE = new StatusCodes(410, "Gone", true);
    public static final StatusCodes INTERNAL_ERROR = new StatusCodes(500, "Internal Server Error", true);
    public static final StatusCodes LENGTH_REQUIRED = new StatusCodes(411, "Length Required", true);
    public static final StatusCodes MOVED_PERM = new StatusCodes(301, "Moved Permanently", false);
    public static final StatusCodes MULT_CHOICE = new StatusCodes(300, "Multiple Choices", false);
    public static final StatusCodes NO_CONTENT = new StatusCodes(204, "No Content", false);
    public static final StatusCodes NOT_ACCEPTABLE = new StatusCodes(406, "Not Acceptable", true);
    public static final StatusCodes NOT_AUTHORITATIVE = new StatusCodes(203, "Non-Authoritative Information", false);
    public static final StatusCodes NOT_FOUND = new StatusCodes(404, "Not Found", true);
    public static final StatusCodes NOT_IMPLEMENTED = new StatusCodes(501, "Not Implemented", true);
    public static final StatusCodes NOT_MODIFIED = new StatusCodes(304, "Not Modified", false);
    public static final StatusCodes OK = new StatusCodes(200, "OK", false);
    public static final StatusCodes PARTIAL = new StatusCodes(206, "Partial Content", false);
    public static final StatusCodes PAYMENT_REQUIRED = new StatusCodes(402, "Payment Required", true);
    public static final StatusCodes PRECON_FAILED = new StatusCodes(412, "Precondition Failed", true);
    public static final StatusCodes RANGE_UNAVAIL = new StatusCodes(416, "Requested Range Not Satisfiable", true);
    public static final StatusCodes PROXY_AUTH = new StatusCodes(407, "Proxy Authentication Required", true);
    public static final StatusCodes REQ_TIMEOUT = new StatusCodes(408, "Request Timeout", true);
    public static final StatusCodes REQ_TOO_LONG = new StatusCodes(414, "Request-URI Too Large", true);
    public static final StatusCodes RESET = new StatusCodes(205, "Reset Content", false);
    public static final StatusCodes SEE_OTHER = new StatusCodes(303, "See Other", false);
    public static final StatusCodes SWITCHING_PROTOCOLS = new StatusCodes(101, "Switching Protocols", false);
    public static final StatusCodes UNAUTHORIZED = new StatusCodes(401, "Unauthorized", false);
    public static final StatusCodes UNAVAILABLE = new StatusCodes(503, "Service Unavailable", true);
    public static final StatusCodes UNSUPPORTED_TYPE = new StatusCodes(415, "Unsupported Media Type", true);
    public static final StatusCodes USE_PROXY = new StatusCodes(305, "Use Proxy", false);
    public static final StatusCodes TEMP_REDIRECT = new StatusCodes(307, "Temporary Redirect", false);
    public static final StatusCodes UNSUPPORTED_VERSION = new StatusCodes(505, "HTTP Version Not Supported", true);
    protected String myPhrase = null;
    protected byte[] myPhraseBytes = null;
    protected HttpError myError = null;
    protected int myIntCode = 0;
    protected byte[] bytesWithPhrase = null;
    protected boolean bBodyAllowed = true;
    protected boolean undefined = false;

    public StatusCodes(String name, int ordinal) {
        super(name, ordinal);
    }

    public StatusCodes(int code, String phrase, boolean isError) {
        super("" + code, code);
        if (0 > code || 750 < code) {
            throw new IndexOutOfBoundsException(code + " is out of bounds");
        }
        this.init(code, phrase, isError);
        StatusCodes.statusCodes[code] = this;
    }

    protected StatusCodes(StatusCodes val) {
        super(val.getName(), val.getOrdinal());
        this.myPhrase = val.getDefaultPhrase();
        this.myPhraseBytes = val.getDefaultPhraseBytes();
        this.myIntCode = val.getIntCode();
        this.myError = val.getHttpError();
    }

    protected void init(int code, String phrase, boolean isError) {
        this.myPhrase = phrase;
        this.myPhraseBytes = HttpChannelUtils.getEnglishBytes(phrase);
        this.myIntCode = code;
        if (isError) {
            this.myError = new HttpError(code, this.myPhrase);
        }
        this.initSpecialArrays();
        this.checkForAllowedBody();
    }

    public static StatusCodes makeUndefinedValue(int value) {
        StatusCodes code = new StatusCodes(UNDEF);
        code.name = Integer.toString(value);
        code.byteArray = HttpChannelUtils.getEnglishBytes(code.getName());
        code.myIntCode = value;
        code.initSpecialArrays();
        code.checkForAllowedBody();
        code.hashcode = code.ordinal + code.name.hashCode();
        code.undefined = true;
        return code;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    protected void initSpecialArrays() {
        int len = this.getByteArray().length;
        this.bytesWithPhrase = new byte[len + 1 + this.myPhraseBytes.length];
        System.arraycopy(this.getByteArray(), 0, this.bytesWithPhrase, 0, len);
        this.bytesWithPhrase[len] = 32;
        System.arraycopy(this.myPhraseBytes, 0, this.bytesWithPhrase, len + 1, this.myPhraseBytes.length);
    }

    public byte[] getStatusWithPhrase() {
        return this.bytesWithPhrase;
    }

    public static StatusCodes getByOrdinal(int i) {
        if (0 > i || i >= 750) {
            throw new IndexOutOfBoundsException("Index " + i + " is out of bounds");
        }
        return statusCodes[i];
    }

    public String getDefaultPhrase() {
        return this.myPhrase;
    }

    public byte[] getDefaultPhraseBytes() {
        return this.myPhraseBytes;
    }

    public int getIntCode() {
        return this.myIntCode;
    }

    public boolean isErrorCode() {
        return null != this.getHttpError();
    }

    public HttpError getHttpError() {
        return this.myError;
    }

    public String toString() {
        return "Status code: " + this.getName();
    }

    public boolean isBodyAllowed() {
        return this.bBodyAllowed;
    }

    public void setBodyAllowed(boolean flag) {
        this.bBodyAllowed = flag;
    }

    protected void checkForAllowedBody() {
        int code = this.getIntCode();
        if (204 == code || 304 == code) {
            this.setBodyAllowed(false);
        } else if (100 <= code && 200 > code) {
            this.setBodyAllowed(false);
        } else {
            this.setBodyAllowed(true);
        }
    }
}

