/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.genericbnf;

import com.ibm.wsspi.genericbnf.GenericKeys;

public class BaseVersionValues
extends GenericKeys {
    private int major = 0;
    private int minor = 0;
    private String protocol = null;

    public BaseVersionValues(String s, int o) {
        super(s, o);
        this.parseVersion();
    }

    public BaseVersionValues(String inProtocol, int inMajor, int inMinor, int ord) {
        super(inProtocol + "/" + inMajor + "." + inMinor, ord);
        this.protocol = inProtocol;
        this.major = inMajor;
        this.minor = inMinor;
    }

    protected void parseVersion() {
        int slash_index = this.getName().indexOf("/");
        if (-1 == slash_index) {
            throw new IllegalArgumentException("Version missing slash");
        }
        int period_index = this.getName().indexOf(".", slash_index);
        if (-1 == period_index) {
            throw new IllegalArgumentException("Version missing period");
        }
        this.protocol = this.getName().substring(0, slash_index);
        try {
            this.major = Integer.parseInt(this.getName().substring(slash_index + 1, period_index));
            this.minor = Integer.parseInt(this.getName().substring(period_index + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid BaseVersionValues(versions)");
        }
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

