/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ws390.sm.smf.SmfConst;
import com.ibm.ws390.sm.smf.SmfOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public final class SmfProperty {
    private static final String ENCODING_UNICODE = SmfConst.UNICODE_BE;
    private static final String ENCODING_EBCDIC = SmfConst.EBCDIC;
    private static final String TYPE_INT = "I";
    private static final String TYPE_STRING_UNICODE = "U";
    private static final String TYPE_STRING_EBCDIC = "E";
    private static byte[] TYPE_INT_BA;
    private static byte[] TYPE_STRING_UNICODE_BA;
    private static byte[] TYPE_STRING_EBCDIC_BA;
    private static Hashtable UnicodeStringByteCache;
    private static Hashtable EbcdicStringByteCache;
    private byte[] m_type = null;
    private int m_name = -1;
    private String m_stringValue = "";
    private int m_intValue = 0;
    private int m_bytesStringValue = 0;
    private int m_bytesIntValue = 0;

    private SmfProperty(int aName) {
        this.m_name = aName;
    }

    public SmfProperty(int aName, int aValue) {
        this(aName);
        this.m_type = TYPE_INT_BA;
        this.m_intValue = aValue;
        this.m_bytesIntValue = 4;
        this.m_stringValue = "";
        this.m_bytesStringValue = 0;
    }

    public SmfProperty(int aName, String aValue, String anEncoding) {
        this(aName);
        this.m_stringValue = aValue == null ? "" : aValue;
        if (anEncoding == null || anEncoding.equals(ENCODING_UNICODE)) {
            this.m_type = TYPE_STRING_UNICODE_BA;
            this.m_bytesStringValue = 2 * this.m_stringValue.length() + SmfConst.getPaddingByteNumber(ENCODING_UNICODE);
        } else {
            this.m_type = TYPE_STRING_EBCDIC_BA;
            this.m_bytesStringValue = this.m_stringValue.length();
        }
        this.m_intValue = 0;
        this.m_bytesIntValue = 0;
    }

    public int getByteSize() {
        byte[] nameBytes;
        int byteCount = 0;
        if (this.m_type != null) {
            byteCount = this.m_type.length;
        }
        if (this.m_name > -1 && (nameBytes = SmfConst.getBytesForNameInt(this.m_name)) != null) {
            byteCount += nameBytes.length;
        }
        return 12 + byteCount + this.m_bytesIntValue + this.m_bytesStringValue;
    }

    public static final String getEbcdicEncoding() {
        return ENCODING_EBCDIC;
    }

    public int getIntValue() {
        return this.m_intValue;
    }

    public int getName() {
        return this.m_name;
    }

    public String getStringValue() {
        return this.m_stringValue;
    }

    public byte[] getType() {
        return this.m_type;
    }

    public static final String getUnicodeEncoding() {
        return ENCODING_UNICODE;
    }

    public void writeTo(SmfOutputStream aStream) {
        if (this.m_type == null) {
            aStream.putInteger4(0);
        } else {
            aStream.putInteger4(this.m_type.length);
            aStream.putBytes(this.m_type);
        }
        if (this.m_name == -1) {
            aStream.putInteger4(0);
        } else {
            byte[] nameBytes = SmfConst.getBytesForNameInt(this.m_name);
            if (nameBytes == null) {
                aStream.putInteger4(0);
            } else {
                aStream.putInteger4(nameBytes.length);
                aStream.putBytes(nameBytes);
            }
        }
        if (this.m_type[0] == TYPE_INT_BA[0]) {
            aStream.putInteger4(4);
            aStream.putInteger4(this.m_intValue);
        } else if (this.m_name == 8 || this.m_name == 15) {
            aStream.putInteger4(this.m_bytesStringValue);
            aStream.putString(this.m_stringValue, ENCODING_EBCDIC, this.m_bytesStringValue);
        } else {
            byte[] stringBytes = this.getBytesForString(this.m_stringValue);
            aStream.putInteger4(stringBytes.length);
            aStream.putBytes(stringBytes);
        }
    }

    private byte[] getBytesForString(String str) {
        if (this.m_type[0] == TYPE_STRING_UNICODE_BA[0]) {
            return this.findOrAddBytes(str, UnicodeStringByteCache);
        }
        return this.findOrAddBytes(str, EbcdicStringByteCache);
    }

    private byte[] findOrAddBytes(String str, Hashtable cache) {
        byte[] retBytes = (byte[])cache.get(str);
        if (retBytes == null) {
            retBytes = this.convertStringToBytes(str);
            cache.put(str, retBytes);
        }
        return retBytes;
    }

    private byte[] convertStringToBytes(String str) {
        byte[] bArray = null;
        String encoding = this.m_type[0] == TYPE_STRING_UNICODE_BA[0] ? ENCODING_UNICODE : ENCODING_EBCDIC;
        try {
            bArray = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                sb.append(" ");
            }
            bArray = sb.toString().getBytes();
        }
        return bArray;
    }

    static {
        try {
            TYPE_INT_BA = TYPE_INT.getBytes(SmfConst.EBCDIC);
            TYPE_STRING_UNICODE_BA = TYPE_STRING_UNICODE.getBytes(SmfConst.EBCDIC);
            TYPE_STRING_EBCDIC_BA = TYPE_STRING_EBCDIC.getBytes(SmfConst.EBCDIC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        UnicodeStringByteCache = new Hashtable();
        EbcdicStringByteCache = new Hashtable();
    }
}

