/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.csi.DispatchEventListenerCookie;
import com.ibm.ws390.sm.smf.SmfJActivity;

public class SmfEventRecorderCookie
implements DispatchEventListenerCookie {
    public static final int EJB_OPTYPE_ACTIVATE = 0;
    public static final int EJB_OPTYPE_LOAD = 1;
    public static final int EJB_OPTYPE_METHOD = 2;
    public static final int EJB_OPTYPE_STORE = 3;
    public static final int EJB_OPTYPE_PASSIVATE = 4;
    private static final int EJB_OPTYPE_MAX = 5;
    public static final int INVALID_TIME = -1;
    private long[] m_startTime;
    private int[] m_elapsedTime;
    private String m_containername = "Default";
    private String m_beanAmcName = null;
    private byte[] m_beanUuidName = null;
    private int m_beanType = 0;
    private int m_beanActivationPolicy = 0;
    private int m_beanLoadPolicy = 0;
    private int m_beanPinPolicy = 0;
    private int m_beanReentrancePolicy = 0;
    private int m_beanLocalTransContainmentPolicy = 0;
    private int m_beanLocalTransOutcomePolicy = 0;
    private int m_beanAccessControlPolicy = 0;
    private int m_beanReserved1 = 0;
    private int m_beanReserved2 = 0;
    private String m_methodNameAndSignature = null;
    private String m_methodRoles = null;
    private int m_methodTransactionPolicy = 0;
    private int m_methodInvocationIdentity = 0;
    private int m_methodPersistenceIdentity = 0;
    private int m_methodInvocationLocale = 0;
    private int m_methodUserSessionPolicy = 0;
    private long m_methodCpuTimeUsedStart = 0L;
    private long m_methodCpuTimeUsedEnd = 0L;
    private long m_methodCpuTimeUsed = 0L;
    private int m_methodReserved1 = 0;
    private int m_methodReserved2 = 0;
    private boolean m_methodInfoFlushed = false;
    private boolean m_verbose = false;

    public SmfEventRecorderCookie() {
        if (this.m_verbose) {
            System.out.println("SmfCookie.<init> called");
        }
        this.m_startTime = new long[5];
        this.m_elapsedTime = new int[5];
        for (int i = 0; i < 5; ++i) {
            this.m_startTime[i] = -1L;
            this.m_elapsedTime[i] = -1;
        }
        if (this.m_verbose) {
            System.out.println("SmfCookie.<init> done");
        }
    }

    public void create() {
        if (this.m_verbose) {
            System.out.println("SmfEventRecorderCookie.create(): where used???? Method looks useless!");
        }
        SmfEventRecorderCookie cookie = new SmfEventRecorderCookie();
    }

    public void start(int type) {
        if (this.m_verbose) {
            System.out.println("SmfCookie.start: entered, type=" + type);
        }
        this.m_startTime[type] = System.currentTimeMillis();
        if (this.m_verbose) {
            System.out.println("SmfCookie.start: done");
        }
    }

    public void stop(int type) {
        if (this.m_verbose) {
            System.out.println("SmfCookie.stop: entered, type=" + type);
        }
        long stopTime = System.currentTimeMillis();
        if (this.m_startTime[type] != -1L) {
            this.m_elapsedTime[type] = new Long(stopTime - this.m_startTime[type]).intValue();
        } else if (this.m_verbose) {
            System.out.println("SmfCookie.stop: Error: start has not been called before - ignoring value");
        }
        if (this.m_methodInfoFlushed) {
            this.writeSmfRecord(null);
        }
        if (this.m_verbose) {
            System.out.println("SmfCookie.stop: done");
        }
    }

    public void writeSmfRecord(EJBMethodInfo methodInfo) {
        if (this.m_verbose) {
            System.out.println("SmfCookie.writeSmfRecord: entered");
        }
        this.m_methodCpuTimeUsed = this.m_methodCpuTimeUsedEnd - this.m_methodCpuTimeUsedStart;
        this.evaluateMethodInfo(methodInfo);
        if (this.m_verbose) {
            this.print();
        }
        if (this.m_verbose) {
            System.out.println("SmfCookie.writeSmfRecord: creating SmfJActivity");
        }
        SmfJActivity activity = new SmfJActivity();
        if (this.m_verbose) {
            System.out.println("SmfCookie.writeSmfRecord: calling SmfJActivity.beanMethodInvoked");
        }
        activity.beanMethodInvoked(this.m_containername, this.m_beanAmcName, this.m_beanUuidName, this.m_beanType, this.m_beanActivationPolicy, this.m_beanLoadPolicy, this.m_beanPinPolicy, this.m_beanReentrancePolicy, this.m_beanLocalTransContainmentPolicy, this.m_beanLocalTransOutcomePolicy, this.m_beanAccessControlPolicy, this.m_elapsedTime[0], this.m_elapsedTime[4], this.m_elapsedTime[1], this.m_elapsedTime[3], this.m_beanReserved1, this.m_beanReserved2, this.m_methodNameAndSignature, this.m_methodRoles, this.m_elapsedTime[2], this.m_methodTransactionPolicy, this.m_methodInvocationIdentity, this.m_methodPersistenceIdentity, this.m_methodInvocationLocale, this.m_methodUserSessionPolicy, this.m_methodCpuTimeUsed, this.m_methodReserved1, this.m_methodReserved2);
        this.m_methodInfoFlushed = true;
        this.reinitialize();
        if (this.m_verbose) {
            System.out.println("SmfCookie.writeSmfRecord: done");
        }
    }

    public void cpuTimeUsedStart() {
        this.m_methodCpuTimeUsedStart = SmfJActivity.obtainTotalCpuTimeUsed();
    }

    public void cpuTimeUsedEnd() {
        this.m_methodCpuTimeUsedEnd = SmfJActivity.obtainTotalCpuTimeUsed();
    }

    private void evaluateMethodInfo(EJBMethodInfo methodInfo) {
        if (this.m_verbose) {
            System.out.println("SmfEventRecorderCookie.evaluateMethodInfo: entered");
        }
        if (methodInfo != null) {
            this.m_beanAmcName = methodInfo.getAMCName();
            if (this.m_beanAmcName == null) {
                this.m_beanAmcName = new String();
            }
            this.m_beanUuidName = methodInfo.getJ2EEName().getBytes();
            this.m_beanType = methodInfo.getBeanType();
            this.m_beanReentrancePolicy = methodInfo.isReentrant() ? 1 : 0;
            this.m_methodNameAndSignature = methodInfo.getMethodSignature();
            if (this.m_methodNameAndSignature == null) {
                this.m_methodNameAndSignature = new String();
            }
            this.m_methodTransactionPolicy = methodInfo.getTransactionAttribute().getValue();
            if (this.m_methodRoles == null) {
                this.m_methodRoles = new String();
            }
        } else if (this.m_verbose) {
            System.out.println("SmfEventRecorderCookie.evaluateMethodInfo: methodInfo == null");
        }
        if (this.m_verbose) {
            System.out.println("SmfEventRecorderCookie.evaluateMethodInfo: done");
        }
    }

    public long getMethodCpuTimeUsedStart() {
        return this.m_methodCpuTimeUsedStart;
    }

    public long getMethodCpuTimeUsedEnd() {
        return this.m_methodCpuTimeUsedEnd;
    }

    private void reinitialize() {
        if (this.m_verbose) {
            System.out.println("SmfEventRecorderCookie.reinitialize: entered");
        }
        this.m_beanType = 0;
        this.m_beanActivationPolicy = 0;
        this.m_beanLoadPolicy = 0;
        this.m_beanPinPolicy = 0;
        this.m_beanReentrancePolicy = 0;
        this.m_beanLocalTransContainmentPolicy = 0;
        this.m_beanLocalTransOutcomePolicy = 0;
        this.m_beanAccessControlPolicy = 0;
        this.m_beanReserved1 = 0;
        this.m_beanReserved2 = 0;
        this.m_methodRoles = new String();
        this.m_methodTransactionPolicy = 0;
        this.m_methodInvocationIdentity = 0;
        this.m_methodPersistenceIdentity = 0;
        this.m_methodInvocationLocale = 0;
        this.m_methodUserSessionPolicy = 0;
        this.m_methodCpuTimeUsed = 0L;
        this.m_methodCpuTimeUsedStart = 0L;
        this.m_methodCpuTimeUsedEnd = 0L;
        this.m_methodReserved1 = 0;
        this.m_methodReserved2 = 0;
        for (int i = 0; i < 5; ++i) {
            this.m_elapsedTime[i] = -1;
        }
        if (this.m_verbose) {
            System.out.println("SmfEventRecorderCookie.reinitialize: done");
        }
    }

    private void print() {
        System.out.println("SmfCookie.print: entered");
        System.out.println("   String m_containername=       " + this.m_containername);
        System.out.println("   String m_beanAmcName=         " + this.m_beanAmcName);
        System.out.println("   byte[] m_beanUuidName=        " + new String(this.m_beanUuidName));
        System.out.println("   int    m_beanType=            " + this.m_beanType);
        System.out.println("   int    m_beanActivationPolicy=" + this.m_beanActivationPolicy);
        System.out.println("   int    m_beanLoadPolicy=      " + this.m_beanLoadPolicy);
        System.out.println("   int    m_beanPinPolicy=       " + this.m_beanPinPolicy);
        System.out.println("   int    m_beanReentrancePolicy=" + this.m_beanReentrancePolicy);
        System.out.println("   int    m_beanLocalTransContainmentPolicy=" + this.m_beanLocalTransContainmentPolicy);
        System.out.println("   int    m_beanLocalTransOutcomePolicy=    " + this.m_beanLocalTransOutcomePolicy);
        System.out.println("   int    m_beanAccessControlPolicy=" + this.m_beanAccessControlPolicy);
        System.out.println("   int    m_elapsedTime[Activat]=" + this.m_elapsedTime[0]);
        System.out.println("   int    m_elapsedTime[Passiva]=" + this.m_elapsedTime[4]);
        System.out.println("   int    m_elapsedTime[Load]=   " + this.m_elapsedTime[1]);
        System.out.println("   int    m_elapsedTime[Store]=  " + this.m_elapsedTime[3]);
        System.out.println("   int    m_beanReserved1=       " + this.m_beanReserved1);
        System.out.println("   int    m_beanReserved2=       " + this.m_beanReserved2);
        System.out.println("   String m_methodNameAndSignature=" + this.m_methodNameAndSignature);
        System.out.println("   String m_methodRoles=         " + this.m_methodRoles);
        System.out.println("   int    m_elapsedTime[Method]= " + this.m_elapsedTime[2]);
        System.out.println("   int    m_methodTransactionPolicy=" + this.m_methodTransactionPolicy);
        System.out.println("   int    m_methodInvocationIdentity=" + this.m_methodInvocationIdentity);
        System.out.println("   int    m_methodPersistenceIdentity=" + this.m_methodPersistenceIdentity);
        System.out.println("   int    m_methodInvocationLocale=" + this.m_methodInvocationLocale);
        System.out.println("   int    m_methodUserSessionPolicy=" + this.m_methodUserSessionPolicy);
        System.out.println("   int    m_methodReserved1=     " + this.m_methodReserved1);
        System.out.println("   int    m_methodReserved2=     " + this.m_methodReserved2);
        System.out.println("   boolean m_methodInfoFlushed=  " + this.m_methodInfoFlushed);
        System.out.println("SmfCookie.print: done");
    }
}

