/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.smf.SmfEventNotifier;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws390.sm.smf.Smf120St9UserDataObject;
import com.ibm.ws390.sm.smf.Smf120St9UserDataTracker;
import com.ibm.ws390.sm.smf.SmfRequestTracker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmfContainerInfo {
    static TraceComponent tc = Tr.register(SmfContainerInfo.class, "PMI", null);
    private static final byte[] FOUR_NULL_BYTES = new byte[]{0, 0, 0, 0};
    private static boolean _smf120St9Enabled = false;
    private static boolean _smf120St9CpuUsageEnabled = false;
    private static boolean _smf120St9TimestampsEnabled = false;
    private static boolean _smf120St9SecurityEnabled = false;
    static WSThreadLocal<ArrayList<SmfRequestTracker>> smfReqTrackerArrayListThreadLocal = new WSThreadLocal<ArrayList<SmfRequestTracker>>(){

        @Override
        protected ArrayList<SmfRequestTracker> initialValue() {
            return new ArrayList<SmfRequestTracker>();
        }
    };
    static WSThreadLocal<Stack<SmfRequestTracker>> smfReqTrackerStackThreadLocal = new WSThreadLocal<Stack<SmfRequestTracker>>(){

        @Override
        protected Stack<SmfRequestTracker> initialValue() {
            return new Stack<SmfRequestTracker>();
        }
    };
    static WSThreadLocal<ArrayList<SmfEventNotifier>> smfEventNotifierArrayListThreadLocal = new WSThreadLocal<ArrayList<SmfEventNotifier>>(){

        @Override
        protected ArrayList<SmfEventNotifier> initialValue() {
            return new ArrayList<SmfEventNotifier>();
        }
    };
    static WSThreadLocal<Smf120St9UserDataTracker> smfUserDataThreadLocal = new WSThreadLocal<Smf120St9UserDataTracker>(){

        @Override
        protected Smf120St9UserDataTracker initialValue() {
            return new Smf120St9UserDataTracker(5);
        }
    };

    public static ArrayList<SmfEventNotifier> getSmfEventNotifierArrayListThreadLocal() {
        return smfEventNotifierArrayListThreadLocal.get();
    }

    public static Smf120St9UserDataTracker getSmfUserDataThreadLocal() {
        return smfUserDataThreadLocal.get();
    }

    public static void modifySmf120St9Flag(int eventId, int qualifier) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Entered modifySmf120St9Flag: eventId= " + eventId + " qualifier= " + qualifier);
        }
        boolean needToNotifyWebContainer = false;
        block0 : switch (qualifier) {
            case 9: {
                switch (eventId) {
                    case 1: 
                    case 2: {
                        _smf120St9Enabled = eventId == 1;
                        needToNotifyWebContainer = true;
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        _smf120St9CpuUsageEnabled = eventId == 3;
                        needToNotifyWebContainer = true;
                        break block0;
                    }
                    case 5: 
                    case 6: {
                        _smf120St9TimestampsEnabled = eventId == 5;
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        _smf120St9SecurityEnabled = eventId == 7;
                        break block0;
                    }
                }
                break;
            }
        }
        ArrayList<SmfEventNotifier> notifiers = smfEventNotifierArrayListThreadLocal.get();
        for (int i = 0; i < notifiers.size(); ++i) {
            SmfEventNotifier sen = notifiers.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification loop: Notifying SmfEventNotififer with identifySelf = " + sen.identifySelf());
            }
            sen.eventOccurred(eventId, qualifier);
        }
    }

    public static boolean isSmf120St9Enabled() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSmf120St9Enabled returning: " + _smf120St9Enabled);
        }
        return _smf120St9Enabled;
    }

    public static boolean isSmf120St9AndCpuUsageEnabled() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSmf120St9AndCpuUsageEnabled returning (st9 && st9Cpu): " + _smf120St9Enabled + " && " + _smf120St9CpuUsageEnabled);
        }
        return _smf120St9Enabled && _smf120St9CpuUsageEnabled;
    }

    public static void setIsDispatchThread(boolean b) {
        Smf120St9UserDataTracker userDataTracker = smfUserDataThreadLocal.get();
        userDataTracker.isDispatchThread = b;
    }

    public static void endDispatch() {
        if (SmfContainerInfo.isSmf120St9Enabled()) {
            Smf120St9UserDataTracker userDataTracker = smfUserDataThreadLocal.get();
            ArrayList<Smf120St9UserDataObject> userData = userDataTracker.userData;
            if (userData.size() > 0) {
                ByteArrayOutputStream baos;
                block5: {
                    baos = new ByteArrayOutputStream();
                    try {
                        baos.write(FOUR_NULL_BYTES);
                    }
                    catch (IOException ioe) {
                        if (!tc.isDebugEnabled()) break block5;
                        Tr.debug(tc, "IOException while clearing byte count area of in SMF120-9 User Data byte array output stream.\n" + ioe);
                    }
                }
                for (int i = 0; i < userData.size(); ++i) {
                    userData.get(i).writeTo(baos);
                }
                SmfContainerInfo.setSmfSt9UserData(baos.toByteArray());
                userData.clear();
            }
        }
    }

    public static native void setSmfSt9UserData(byte[] var0);
}

