/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.rt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;

public class HexOutputStream
extends OutputStream {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private StringWriter writer;

    public HexOutputStream(StringWriter w) {
        this.writer = w;
    }

    public synchronized void write(int b) throws IOException {
        this.writer.write(hex[b >> 4 & 0xF]);
        this.writer.write(hex[b >> 0 & 0xF]);
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        char[] buf = new char[2 * len];
        for (int i = 0; i < len; ++i) {
            buf[2 * i] = hex[b[i] >> 4 & 0xF];
            buf[2 * i + 1] = hex[b[i] >> 0 & 0xF];
        }
        this.writer.write(buf, 0, buf.length);
    }

    public synchronized String dump() {
        return this.writer.toString();
    }
}

