/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.ClientRequest;
import com.ibm.CORBA.iiop.ClientResponse;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.InterceptorManager;
import com.ibm.CORBA.iiop.Request;
import com.ibm.CORBA.iiop.Response;
import com.ibm.CORBA.iiop.ServerRequest;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.iiop.ClientResponseImpl;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.channel.ziop.ZIOPConnectionContext;
import com.ibm.ws390.orb.ClientDelegate;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.orb.ResponseHandlerImpl;
import com.ibm.ws390.orb.WS390ServerRequestInfoImpl;
import com.ibm.ws390.ziop.ZIOPChannelTransport;
import com.ibm.ws390.ziop.ZIOPConnectionState;
import com.ibm.ws390.ziop.ZIOPConnectionStateElement;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.PortableInterceptor.ForwardRequest;

public class WS390InterceptorManager {
    private static TraceComponent tc = Tr.register(WS390InterceptorManager.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static InterceptorManager _interceptorManager = null;
    private static boolean isClientJVM = false;

    private static InterceptorManager getInterceptorManager(com.ibm.CORBA.iiop.ORB orb) {
        if (isClientJVM) {
            return orb.getInterceptorManager();
        }
        if (_interceptorManager == null) {
            InterceptorManager im = orb.getInterceptorManager();
            isClientJVM = PlatformHelperFactory.getPlatformHelper().isClientJvm();
            if (isClientJVM) {
                return im;
            }
            _interceptorManager = im;
        }
        return _interceptorManager;
    }

    public static ExtendedClientRequestInfo createClientInfo(com.ibm.CORBA.iiop.ORB orb, ClientRequest clientReq, ClientDelegate delegate, Object target, java.lang.Object connInfo, boolean isLocal) {
        InterceptorManager interceptorManager = WS390InterceptorManager.getInterceptorManager(orb);
        return interceptorManager.createClientInfo((Request)clientReq, null, (com.ibm.rmi.corba.ClientDelegate)delegate, target, null, connInfo, isLocal);
    }

    public static void interceptOutboundRequest(com.ibm.CORBA.iiop.ORB orb, ExtendedClientRequestInfo clientRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interceptOutboundRequest", clientRequestInfo);
        }
        try {
            InterceptorManager interceptorManager = WS390InterceptorManager.getInterceptorManager(orb);
            interceptorManager.iterateSendRequest(clientRequestInfo);
        }
        catch (Throwable t) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "InterceptorManager.iterateSendRequest threw throwable", t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interceptOutboundRequest");
        }
    }

    public static void prepareInboundResponse(com.ibm.CORBA.iiop.ORB orb, ClientResponse resp, ExtendedClientRequestInfo clientRequestInfo, ServiceContext[] scList, boolean isLittleEndian) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareInboundResponse", clientRequestInfo);
        }
        if (resp == null) {
            try {
                resp = ORB.createClientResponse((com.ibm.CORBA.iiop.ORB)orb, null, (int)0, (boolean)isLittleEndian);
            }
            catch (IOException ex) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught IOException creating response", ex);
                }
                throw new INTERNAL(-910010457, CompletionStatus.COMPLETED_NO);
            }
        }
        if (scList != null) {
            for (int i = 0; i < scList.length; ++i) {
                ((ClientResponseImpl)resp).setServiceContext(scList[i], true);
            }
        }
        clientRequestInfo.setReply((Response)resp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareInboundResponse", clientRequestInfo);
        }
    }

    public static void interceptInboundResponse(com.ibm.CORBA.iiop.ORB orb, ExtendedClientRequestInfo clientRequestInfo, int resultType, Throwable responseException) throws RemarshalException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interceptInboundResponse", clientRequestInfo);
        }
        InterceptorManager interceptorManager = WS390InterceptorManager.getInterceptorManager(orb);
        Throwable currentException = responseException;
        Throwable interceptorException = null;
        while (true) {
            try {
                if (currentException == null) {
                    interceptorManager.iterateReceiveReply(clientRequestInfo);
                    break;
                }
                if (currentException instanceof RemarshalException) {
                    clientRequestInfo.setLocationForward(null);
                    interceptorManager.iterateReceiveOther(clientRequestInfo);
                    break;
                }
                if (currentException instanceof ForwardRequest) {
                    clientRequestInfo.setLocationForward(((ForwardRequest)currentException).forward);
                    interceptorManager.iterateReceiveOther(clientRequestInfo);
                    break;
                }
                clientRequestInfo.setException(currentException);
                interceptorManager.iterateReceiveException(clientRequestInfo);
            }
            catch (Throwable t) {
                if (currentException != null && t instanceof SystemException) {
                    if (currentException instanceof SystemException) {
                        ((SystemException)t).completed = ((SystemException)currentException).completed;
                    } else if (currentException instanceof UserException) {
                        ((SystemException)t).completed = CompletionStatus.COMPLETED_YES;
                    }
                }
                interceptorException = currentException = t;
                continue;
            }
            break;
        }
        if (interceptorException != null) {
            if (interceptorException instanceof ForwardRequest) {
                throw new RemarshalException();
            }
            if (interceptorException instanceof RuntimeException) {
                throw (RuntimeException)interceptorException;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", interceptorException);
            }
            throw new UNKNOWN(interceptorException.getMessage(), -910010561, CompletionStatus.COMPLETED_MAYBE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interceptInboundResponse");
        }
    }

    public static ExtendedServerRequestInfo prepareServerRequestInfo(com.ibm.CORBA.iiop.ORB orb, String operation, ServiceContext[] scInboundList, byte[] connHandleBytes, byte[] userKey) {
        ConnectionHandle handle = null;
        if (connHandleBytes != null) {
            handle = new ConnectionHandle(connHandleBytes);
        }
        return WS390InterceptorManager.prepareServerRequestInfo(orb, operation, scInboundList, handle, userKey);
    }

    public static ExtendedServerRequestInfo prepareServerRequestInfo(com.ibm.CORBA.iiop.ORB orb, String operation, ServiceContext[] scInboundList, ConnectionHandle handle) {
        return WS390InterceptorManager.prepareServerRequestInfo(orb, operation, scInboundList, handle, null);
    }

    public static ExtendedServerRequestInfo prepareServerRequestInfo(com.ibm.CORBA.iiop.ORB orb, String operation, ServiceContext[] scInboundList, ConnectionHandle handle, byte[] userKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareServerRequestInfo", new java.lang.Object[]{operation, orb, userKey});
        }
        WS390ServerRequestInfoImpl serverRequestInfo = null;
        ServerRequest serverRequest = ORB.createServerRequest((String)operation, (boolean)false);
        if (scInboundList != null) {
            for (int i = 0; i < scInboundList.length; ++i) {
                serverRequest.setServiceContext(scInboundList[i], true);
            }
        }
        java.lang.Object connInfo = null;
        if (handle != null && !PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
            ZIOPConnectionStateElement ziopState;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connHandle", handle);
            }
            if ((ziopState = ZIOPConnectionState.checkConnection((ConnectionHandle)handle)) != null) {
                ZIOPConnectionContext ctx = ziopState.getConnectionContext();
                ZIOPChannelTransport transport = ZIOPChannelTransport.getInstance((com.ibm.CORBA.iiop.ORB)orb);
                connInfo = transport.getServerConnectionData((GIOPConnectionContext)ctx);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connInfo", connInfo);
            }
        }
        serverRequestInfo = new WS390ServerRequestInfoImpl(orb, serverRequest, null, connInfo, false, userKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareServerRequestInfo", (java.lang.Object)serverRequestInfo);
        }
        return serverRequestInfo;
    }

    public static void interceptInboundContexts(com.ibm.CORBA.iiop.ORB orb, ExtendedServerRequestInfo serverRequestInfo) throws ForwardRequest, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interceptInboundContexts", serverRequestInfo);
        }
        InterceptorManager interceptorManager = WS390InterceptorManager.getInterceptorManager(orb);
        interceptorManager.iterateReceiveContext(serverRequestInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interceptInboundContexts");
        }
    }

    public static void interceptInboundRequest(com.ibm.CORBA.iiop.ORB orb, ExtendedServerRequestInfo serverRequestInfo) throws ForwardRequest, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interceptInboundRequest", serverRequestInfo);
        }
        InterceptorManager interceptorManager = WS390InterceptorManager.getInterceptorManager(orb);
        interceptorManager.iterateReceiveRequest(serverRequestInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interceptInboundRequest");
        }
    }

    public static void interceptOutboundResponse(com.ibm.CORBA.iiop.ORB orb, ExtendedServerRequestInfo serverRequestInfo, Throwable responseException, ResponseHandlerImpl rh) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interceptOutboundResponse", serverRequestInfo);
        }
        InterceptorManager interceptorManager = WS390InterceptorManager.getInterceptorManager(orb);
        Throwable currentException = responseException;
        Throwable interceptorException = null;
        if (currentException == null) {
            if (rh.responseStatus == 1) {
                currentException = new UnknownUserException();
            } else if (rh.responseStatus == 2 || rh.responseStatus == 999) {
                currentException = rh.systemException;
            }
        }
        while (true) {
            try {
                if (currentException == null) {
                    interceptorManager.iterateSendReply(serverRequestInfo);
                    break;
                }
                if (currentException instanceof ForwardRequest) {
                    serverRequestInfo.setLocationForward(((ForwardRequest)currentException).forward);
                    interceptorManager.iterateSendOther(serverRequestInfo);
                    break;
                }
                serverRequestInfo.setException(currentException);
                interceptorManager.iterateSendException(serverRequestInfo);
            }
            catch (Throwable t) {
                if (currentException != null && t instanceof SystemException) {
                    if (currentException instanceof SystemException) {
                        ((SystemException)t).completed = ((SystemException)currentException).completed;
                    } else if (currentException instanceof UserException) {
                        ((SystemException)t).completed = CompletionStatus.COMPLETED_YES;
                    }
                }
                interceptorException = currentException = t;
                continue;
            }
            break;
        }
        if (interceptorException != null) {
            if (interceptorException instanceof RuntimeException) {
                throw (RuntimeException)interceptorException;
            }
            if (interceptorException instanceof ForwardRequest) {
                throw (ForwardRequest)interceptorException;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", interceptorException);
            }
            throw new UNKNOWN(interceptorException.getMessage(), -910010562, CompletionStatus.COMPLETED_MAYBE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interceptOutboundResponse");
        }
    }
}

