/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.XmlNotValidException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMQRAClassificationParser {
    private static final TraceComponent tc = Tr.register(WMQRAClassificationParser.class, "ORB", null);
    public static final String SCHEMA_VERSION = "1.0";
    private List<Element> elements = new ArrayList<Element>();
    private static final WMQRAClassificationParser instance = new WMQRAClassificationParser();

    private WMQRAClassificationParser() {
    }

    public void parse(Element element) throws XmlNotValidException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "parse");
        }
        String version = element.getAttribute("schema_version");
        String defaultTansactionClass = element.getAttribute("default_transaction_class");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parse", new Object[]{"element " + element.getTagName(), "default_transaction_class=" + defaultTansactionClass, "schema_version=" + version});
        }
        if (!version.equals(SCHEMA_VERSION)) {
            String message = "Unsupported version of WMQRAClassification element (supported version is 1.0)";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unsupported version of WMQRAClassification element (supported version is 1.0)");
            }
            throw new XmlNotValidException("Unsupported version of WMQRAClassification element (supported version is 1.0)");
        }
        WMQRAClassificationParser.validateTransactionClass(defaultTansactionClass);
        NodeList nodes = element.getElementsByTagName("wmqra_classification_info");
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            this.validateClassificationInfo((Element)nodes.item(i));
        }
        this.getElements().add(element);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    private void validateClassificationInfo(Element element) throws XmlNotValidException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClassificationInfo");
        }
        String transactionClass = element.getAttribute("transaction_class");
        String selector = element.getAttribute("selector");
        String queueManager = element.getAttribute("queue_manager");
        String destination = element.getAttribute("destination");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "validateClassificationInfo", new Object[]{"element " + element.getTagName(), "transaction_class=" + transactionClass, "selector=" + selector, "queue_manager=" + queueManager, "destination=" + destination, "description=" + element.getAttribute("description")});
        }
        WMQRAClassificationParser.validateTransactionClass(transactionClass);
        if (selector.trim().equals("") && queueManager.trim().equals("") && destination.trim().equals("")) {
            String message = "At least one of the attributes selector, queue_manager and destination must be specified";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "At least one of the attributes selector, queue_manager and destination must be specified");
            }
            throw new XmlNotValidException("At least one of the attributes selector, queue_manager and destination must be specified");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClassificationInfo");
        }
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        this.elements = new ArrayList<Element>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public static WMQRAClassificationParser getInstance() {
        return instance;
    }

    private static void validateTransactionClass(String transactionClass) throws XmlNotValidException {
        if (transactionClass.trim().equals("") || transactionClass.length() > 8) {
            String message = "Transaction class \"" + transactionClass + "\" must not be empty or longer than 8 characters";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, message);
            }
            throw new XmlNotValidException(message);
        }
    }
}

