/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ws.bootstrap.ClassLoaderGateway;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws390.orb.ControlRegionBridge;
import com.ibm.ws390.orb.ORBEJSBridge;
import com.ibm.ws390.orb.ORBEJSBridgeInterface;
import com.ibm.ws390.orb.ServerRegionBridge;
import com.ibm.ws390.orb.parameters.ORBEJSBridgeInitCSI;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ServerStartup
implements IPlatformRunnable {
    public Object run(Object arg0) throws Exception {
        ClassLoader gwcl = ClassLoaderGateway.instance().getClassLoader();
        ExtClassLoader ecl = null;
        ecl = gwcl != null ? new ExtClassLoader(System.getProperty("ws.ext.dirs"), gwcl) : new ExtClassLoader(System.getProperty("ws.ext.dirs"));
        ecl.installGateway(ClassLoaderGateway.instance());
        Thread.currentThread().setContextClassLoader(ecl);
        ORBEJSBridge.extclassloader = ecl;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.ws.bootstrap.manual-bundle-start");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                String bundleName = extensions[i].getNamespace();
                Bundle bundle = Platform.getBundle(bundleName);
                if (bundle == null || bundle.getState() == 32) continue;
                try {
                    bundle.start();
                    continue;
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
        }
        ORBEJSBridgeInterface bridge = null;
        ORBEJSBridgeInitCSI parms = ORBEJSBridge.getInitCSIParms();
        try {
            switch (parms.as_orbtype) {
                case 2: {
                    bridge = ServerRegionBridge.init();
                    break;
                }
                case 1: 
                case 4: {
                    bridge = ControlRegionBridge.init();
                    break;
                }
                default: {
                    throw new Exception("Unknown Bridge Type");
                }
            }
            if (bridge != null) {
                ORBEJSBridge.initBridgeCallback(bridge);
                byte[] server_pv = bridge.initCSI(parms);
                ORBEJSBridge.initBridgeReturn(server_pv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return new Integer(0);
    }
}

