/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.ServantInitializationListener;
import com.ibm.ws.util.ServantInitializedException;
import java.util.LinkedList;

public class ServantInitializedNotifier {
    private static final char[] charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final TraceComponent tc = Tr.register(ServantInitializedNotifier.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static LinkedList listenerList;
    private static boolean servantInitialized;

    private static native void setListenerHandle();

    public static synchronized void registerListener(ServantInitializationListener listener) throws ServantInitializedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServantInitializedNotifier.registerListener");
        }
        if (servantInitialized) {
            throw new ServantInitializedException("Servant has already initialized");
        }
        listenerList.add(listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServantInitializedNotifier.registerListener");
        }
    }

    public static synchronized void servantInitialized(byte[] stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServantInitializedNotifier.servantInitialized", stoken);
        }
        String stringStoken = null;
        if (stoken != null && stoken.length > 0) {
            StringBuffer stokenBuf = new StringBuffer();
            for (int i = 0; i < stoken.length; ++i) {
                int hoNibble = (stoken[i] & 0xF0) / 16;
                int loNibble = stoken[i] & 0xF;
                stokenBuf.append(charValues[hoNibble]);
                stokenBuf.append(charValues[loNibble]);
            }
            stringStoken = stokenBuf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantInitializedNotifier.stringStoken", stringStoken);
            }
            for (ServantInitializationListener currentListener : listenerList) {
                try {
                    currentListener.servantInitialized(stringStoken);
                }
                catch (Exception ex) {
                    Tr.event(tc, "ServantInitializedNotifier.servantInitialized", ex);
                }
            }
            listenerList = null;
            servantInitialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServantInitializedNotifier.servantInitialized");
        }
    }

    static {
        String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
        int bitmode = Integer.parseInt(CurrentBitmode);
        if (bitmode == 64) {
            System.loadLibrary("bbgboa");
        } else {
            System.loadLibrary("bboboa");
        }
        ServantInitializedNotifier.setListenerHandle();
        listenerList = new LinkedList();
        servantInitialized = false;
    }
}

