/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.orb.BOSSObjectKey;
import com.ibm.ws390.orb.ClientDelegate;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.orb.ORBEJSBridge;
import com.ibm.ws390.orb.SRObjectElement;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public class SRAggregator
implements com.ibm.ws.util.SRAggregator {
    private static TraceComponent tc = Tr.register(SRAggregator.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static final byte[] NULL_STOKEN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final char[] charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String SIB_Z_DISPATCH = "com.ibm.ws.sib.z.dispatcher.WorkObjectImpl";
    private LinkedList srObjectElementList = null;
    private ListIterator srObjectElementListIterator = null;
    private SRObjectElement singleServantObject = null;
    private ByteBuffer stokenElements = null;
    private String type_id = null;
    private String classname = null;
    private String applenv = null;
    private boolean queueInternal = true;

    public SRAggregator() {
    }

    public SRAggregator(Object x, boolean want_all_srs) {
        this(x, want_all_srs, NULL_STOKEN, null);
    }

    public SRAggregator(Object x, boolean want_all_srs, String applenv) {
        this(x, want_all_srs, NULL_STOKEN, applenv);
    }

    public SRAggregator(Object x, boolean want_all_srs, byte[] target_stoken) {
        this(x, want_all_srs, target_stoken, null);
    }

    public SRAggregator(Object x, boolean want_all_srs, byte[] target_stoken, boolean queue_internal) {
        this(x, want_all_srs, target_stoken, null, queue_internal);
    }

    public SRAggregator(Object x, boolean want_all_srs, byte[] target_stoken, String appl_env) {
        this(x, want_all_srs, target_stoken, appl_env, true);
    }

    public SRAggregator(Object x, boolean want_all_srs, byte[] target_stoken, String appl_env, boolean queue_internal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SRAggregator::SRAggregator");
        }
        this.initialize(x, want_all_srs, target_stoken, appl_env, queue_internal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SRAggregator::SRAggregator");
        }
    }

    public void initialize(Object x, boolean want_all_srs) {
        this.initialize(x, want_all_srs, NULL_STOKEN);
    }

    public void initialize(Object x, boolean want_all_srs, byte[] target_stoken) {
        this.initialize(x, want_all_srs, target_stoken, null);
    }

    public void initialize(Object x, boolean want_all_srs, byte[] target_stoken, String appl_env) {
        this.initialize(x, want_all_srs, target_stoken, appl_env, true);
    }

    public void initialize(Object x, boolean want_all_srs, byte[] target_stoken, String appl_env, boolean queue_internal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.type_id = ((ObjectImpl)x)._ids()[0];
        this.classname = ((ObjectImpl)x).getClass().getName();
        this.applenv = appl_env;
        this.queueInternal = queue_internal;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createSRAggregator " + this.type_id + " " + this.classname + " " + want_all_srs + " " + this.applenv, target_stoken);
        }
        this.createSRAggregator(want_all_srs, target_stoken != null ? target_stoken : NULL_STOKEN);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        if (this.singleServantObject == null) {
            LinkedList linkedList = this.srObjectElementList;
            synchronized (linkedList) {
                int i;
                byte[] stokenElementsBytes = SRAggregator.getStokenElements();
                this.stokenElements = ByteBuffer.wrap(stokenElementsBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stokenElementsBytes", stokenElementsBytes);
                }
                int numStokenElements = this.stokenElements.getInt();
                int initialListSize = this.srObjectElementList.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initial list size", new Integer(initialListSize));
                }
                boolean[] refreshValidated = new boolean[initialListSize];
                for (i = 0; i < initialListSize; ++i) {
                    refreshValidated[i] = false;
                }
                for (i = 0; i < numStokenElements; ++i) {
                    boolean isCRA;
                    byte[] stoken = new byte[8];
                    this.stokenElements.get(stoken);
                    boolean bl = isCRA = this.stokenElements.get() == 1;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "refreshing stoken", stoken);
                    }
                    boolean found = false;
                    for (int j = 0; j < initialListSize; ++j) {
                        SRObjectElement srElement = (SRObjectElement)this.srObjectElementList.get(j);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing to srElement at index: " + j, srElement.getStokenBytes());
                        }
                        if (!Arrays.equals(srElement.getStokenBytes(), stoken)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found stoken in list at index " + j, srElement);
                        }
                        refreshValidated[j] = true;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.srObjectElementList.addLast(this.createSRObjectElement(this.createBOSSObjectKey(), stoken, isCRA));
                }
                for (i = initialListSize - 1; i >= 0; --i) {
                    if (refreshValidated[i]) continue;
                    SRObjectElement removedElement = (SRObjectElement)this.srObjectElementList.remove(i);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "removed element", removedElement);
                }
                this.srObjectElementListIterator = this.srObjectElementList.listIterator(0);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    public boolean hasNext() {
        if (this.singleServantObject != null) {
            return true;
        }
        return this.srObjectElementListIterator != null ? this.srObjectElementListIterator.hasNext() : false;
    }

    public java.lang.Object next() {
        if (this.singleServantObject != null) {
            return this.singleServantObject.getSRObject();
        }
        try {
            return ((SRObjectElement)this.srObjectElementListIterator.next()).getSRObject();
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException();
        }
    }

    public com.ibm.ws.util.SRObjectElement nextSRObjectElement() {
        if (this.singleServantObject != null) {
            return this.singleServantObject;
        }
        if (this.srObjectElementListIterator != null) {
            return (com.ibm.ws.util.SRObjectElement)this.srObjectElementListIterator.next();
        }
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getSRObjectElementHT() {
        Hashtable<String, java.lang.Object> retval = new Hashtable<String, java.lang.Object>();
        LinkedList linkedList = this.srObjectElementList;
        synchronized (linkedList) {
            this.refresh();
            ListIterator iter = this.srObjectElementList.listIterator(0);
            while (iter.hasNext()) {
                SRObjectElement srElement = (SRObjectElement)iter.next();
                retval.put(srElement.getStoken(), srElement.getSRObject());
            }
        }
        return retval;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSRObject(byte[] stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSRObject", stoken);
        }
        SRObjectElement removedElement = null;
        LinkedList linkedList = this.srObjectElementList;
        synchronized (linkedList) {
            ListIterator iter = this.srObjectElementList.listIterator(0);
            while (iter.hasNext()) {
                SRObjectElement srElement = (SRObjectElement)iter.next();
                if (!Arrays.equals(srElement.getStokenBytes(), stoken)) continue;
                removedElement = srElement;
                iter.remove();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSRObject", removedElement);
        }
    }

    public boolean isServantActive(byte[] srStoken) {
        if (ORBEJSBridge.getOrbType() == 1) {
            return PlatformHelperFactory.getPlatformHelper().isServantActive(srStoken);
        }
        throw new IllegalStateException("SRAggrator.isServantActive is only supported in a Controller");
    }

    private void createSRAggregator(boolean want_all_srs, byte[] target_stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSRAggregator");
        }
        if (!want_all_srs && (target_stoken == NULL_STOKEN || Arrays.equals(target_stoken, NULL_STOKEN))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating singleServantObject to ANY servant");
            }
            BOSSObjectKey bossObjectKey = this.createBOSSObjectKey();
            bossObjectKey.resetFlag(Integer.MIN_VALUE);
            this.singleServantObject = this.createSRObjectElement(bossObjectKey, target_stoken, false);
        } else {
            byte[] stokenElementsBytes = SRAggregator.getStokenElements(!want_all_srs);
            this.stokenElements = ByteBuffer.wrap(stokenElementsBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stokenElementsBytes", stokenElementsBytes);
            }
            int numStokenElements = this.stokenElements.getInt();
            if (want_all_srs) {
                this.srObjectElementList = new LinkedList();
            }
            for (int i = 0; i < numStokenElements; ++i) {
                boolean isCRA;
                byte[] stoken = new byte[8];
                this.stokenElements.get(stoken);
                boolean bl = isCRA = this.stokenElements.get() == 1;
                if (want_all_srs) {
                    this.srObjectElementList.add(this.createSRObjectElement(this.createBOSSObjectKey(), stoken, isCRA));
                    continue;
                }
                if (!Arrays.equals(target_stoken, stoken)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found target stoken", stoken);
                }
                this.singleServantObject = this.createSRObjectElement(this.createBOSSObjectKey(), target_stoken, isCRA);
                break;
            }
            if (want_all_srs) {
                this.srObjectElementListIterator = this.srObjectElementList.listIterator(0);
                this.singleServantObject = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSRAggregator");
        }
    }

    private BOSSObjectKey createBOSSObjectKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBOSSObjectKey");
        }
        BOSSObjectKey bossObjectKey = new BOSSObjectKey(this.type_id, this.classname, null, true, false, true);
        if (this.applenv != null) {
            bossObjectKey.addQueueByApplenvData(this.applenv);
            bossObjectKey.setFlag(262144);
        }
        if (this.classname != SIB_Z_DISPATCH && this.queueInternal) {
            bossObjectKey.setFlag(0x100000);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBOSSObjectKey", bossObjectKey);
        }
        return bossObjectKey;
    }

    private SRObjectElement createSRObjectElement(BOSSObjectKey bossObjectKey, byte[] stoken, boolean isCRA) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSRObjectElement", stoken);
        }
        if (stoken != NULL_STOKEN) {
            bossObjectKey.addQueueByStokenData(stoken);
        }
        ORB _orb = (ORB)GlobalORBFactory.globalORB();
        IOR ior = _orb.createIOR(this.type_id, _orb.getControllerIIOPProfile(), bossObjectKey);
        java.lang.Object srObject = this.createStubObject(ior);
        SRObjectElement srObjectElement = new SRObjectElement(srObject, SRAggregator.getStokenString(stoken), stoken, isCRA);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSRObjectElement", srObjectElement);
        }
        return srObjectElement;
    }

    private static String getStokenString(byte[] stoken) {
        String stokenStr = null;
        if (stoken != null && stoken.length > 0) {
            StringBuffer stokenBuf = new StringBuffer();
            for (int i = 0; i < stoken.length; ++i) {
                int hoNibble = (stoken[i] & 0xF0) / 16;
                int loNibble = stoken[i] & 0xF;
                stokenBuf.append(charValues[hoNibble]);
                stokenBuf.append(charValues[loNibble]);
            }
            stokenStr = stokenBuf.toString();
        }
        return stokenStr;
    }

    private java.lang.Object createStubObject(IOR ior) {
        final String stub_classname = ORBUtil.stubNameFromRepId((String)this.type_id);
        java.lang.Object SRObject_instance = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stub_classname " + stub_classname);
            }
            Class<?> stub_class = null;
            try {
                stub_class = (Class<?>)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws ClassNotFoundException {
                        return Class.forName(stub_classname, true, Thread.currentThread().getContextClassLoader());
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "PAE ClassNotFound: " + stub_classname, pae.getException());
                }
                stub_class = Class.forName(stub_classname);
            }
            SRObject_instance = stub_class.newInstance();
            ORB _orb = (ORB)GlobalORBFactory.globalORB();
            ClientDelegate cd = new ClientDelegate(_orb, ior);
            ((org.omg.CORBA.portable.ObjectImpl)SRObject_instance)._set_delegate((Delegate)cd);
        }
        catch (ClassNotFoundException ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ClassNotFoundException", ex);
            }
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "InstantiationException", ex);
            }
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "IllegalAccessException", ex);
            }
            throw new RuntimeException(ex);
        }
        return SRObject_instance;
    }

    private static byte[] getStokenElements() {
        return SRAggregator.getStokenElements(false);
    }

    private static native byte[] getStokenElements(boolean var0);
}

