/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.nio.Sink;
import com.ibm.CORBA.nio.StreamFactory;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.orb.OutboundResponseCDRFragmentHandler;
import com.ibm.ws390.orb.PartnerVersion;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.ServiceContext;

public class ResponseHandlerImpl
implements ResponseHandler {
    static TraceComponent tc = Tr.register(ResponseHandlerImpl.class, "ORB", null);
    protected CDROutputStream responseBuffer = null;
    public static final int NoReply = -1;
    public static final int NO_EXCEPTION = 0;
    public static final int USER_EXCEPTION = 1;
    public static final int SYSTEM_EXCEPTION = 2;
    public static final int LOCATION_FORWARD = 3;
    public static final int UNKNOWN_EXCEPTION = 999;
    public int responseStatus = -1;
    public SystemException systemException = null;
    protected byte giop_major;
    protected byte giop_minor;
    protected int charEncodingId;
    protected int wcharEncodingId;
    private boolean outEndian;
    private short partner_version_extended = 0;
    private short partner_version_major = 0;
    private short partner_version_minor = 0;
    private byte customMaxStreamFormatVersion;
    private boolean isHTTP_Request;
    private int initialSize = 0;
    private final ORB orb;
    private boolean useDefault = false;
    private OutboundResponseCDRFragmentHandler cdrHandler = null;
    private boolean responseFragmentEnabled = false;

    protected static ResponseHandlerImpl getHandler(ResponseHandlerImpl rh) {
        if (rh == null) {
            rh = new ResponseHandlerImpl();
        }
        return rh;
    }

    protected ResponseHandlerImpl(boolean outEndian, boolean isPassthru, int charOSFid, int wcharOSFid, short giop_version, byte customMaxStreamFormat, boolean isHTTP_Request) {
        this.orb = GlobalORBFactory.globalORB();
        this.outEndian = outEndian;
        this.charEncodingId = charOSFid;
        this.wcharEncodingId = wcharOSFid;
        this.giop_major = (byte)(giop_version >>> 8);
        this.giop_minor = (byte)giop_version;
        this.customMaxStreamFormatVersion = this.validatedMaxStreamFormat(customMaxStreamFormat);
        this.isHTTP_Request = isHTTP_Request;
    }

    protected ResponseHandlerImpl(boolean outEndian, boolean isPassthru, int charOSFid, int wcharOSFid, short giop_version, byte customMaxStreamFormat, boolean isHTTP_Request, OutboundResponseCDRFragmentHandler handler, boolean responseFragmentEnabled) {
        this.orb = GlobalORBFactory.globalORB();
        this.outEndian = outEndian;
        this.charEncodingId = charOSFid;
        this.wcharEncodingId = wcharOSFid;
        this.giop_major = (byte)(giop_version >>> 8);
        this.giop_minor = (byte)giop_version;
        this.customMaxStreamFormatVersion = this.validatedMaxStreamFormat(customMaxStreamFormat);
        this.isHTTP_Request = isHTTP_Request;
        this.cdrHandler = handler;
        this.responseFragmentEnabled = responseFragmentEnabled;
    }

    protected ResponseHandlerImpl(ORB orb, boolean outEndian, int charOSFid, int wcharOSFid, short giop_version, byte customMaxStreamFormat, PartnerVersion use_pv) {
        this.orb = orb == null ? GlobalORBFactory.globalORB() : orb;
        this.isHTTP_Request = false;
        this.outEndian = outEndian;
        this.charEncodingId = charOSFid;
        this.wcharEncodingId = wcharOSFid;
        this.giop_major = (byte)(giop_version >>> 8);
        this.giop_minor = (byte)giop_version;
        this.customMaxStreamFormatVersion = this.validatedMaxStreamFormat(customMaxStreamFormat);
        this.partner_version_extended = use_pv.extract_pv_extended();
        this.partner_version_major = use_pv.extract_pv_major();
        this.partner_version_minor = use_pv.extract_pv_minor();
    }

    ResponseHandlerImpl() {
        this.orb = GlobalORBFactory.globalORB();
        this.isHTTP_Request = false;
        this.useDefault = true;
    }

    protected byte[] getBytes() {
        byte[] result = this.cdrHandler != null ? WsByteBufferUtils.asByteArray(this.responseBuffer.toByteBuffer()) : this.responseBuffer.toByteArray();
        return result;
    }

    public CDRInputStream getParameterInputStream(byte[] params, int pad) {
        CDRInputStream paramStream = null;
        if (params != null && params.length > 0) {
            paramStream = ORB.createCDRInputStream((ORB)this.orb, (byte[])params, (int)params.length, (boolean)this.outEndian, (int)this.charEncodingId, (int)this.wcharEncodingId);
            paramStream.setGIOPVersions(this.giop_major, this.giop_minor, this.partner_version_major, this.partner_version_minor, this.partner_version_extended);
            if (pad > 7) {
                paramStream.read_long();
                pad -= 4;
            }
            if (pad > 3) {
                paramStream.read_long();
                pad -= 4;
            }
            if (pad > 1) {
                paramStream.read_short();
                pad -= 2;
            }
            if (pad > 0) {
                paramStream.read_octet();
            }
        }
        return paramStream;
    }

    public OutputStream createReply(int size) {
        this.initialSize = Math.max(size + 16, this.orb.getLargeDataBufferSize());
        return this.createReply();
    }

    public OutputStream createReply() {
        this.responseStatus = 0;
        this.createOutputStream();
        return this.responseBuffer;
    }

    public OutputStream createExceptionReply() {
        this.responseStatus = 1;
        this.createOutputStream();
        return this.responseBuffer;
    }

    public OutputStream createSystemExceptionReply(SystemException e) {
        this.responseStatus = 2;
        this.systemException = e;
        this.createOutputStream();
        this.responseBuffer.writeSystemException(e);
        return this.responseBuffer;
    }

    byte[] createSystemExceptionReplyBytes(SystemException e) {
        CDROutputStream out = (CDROutputStream)this.createSystemExceptionReply(e);
        byte[] result = this.cdrHandler != null ? WsByteBufferUtils.asByteArray(out.toByteBuffer()) : out.toByteArray();
        out.releaseBuffer();
        return result;
    }

    public OutputStream createUnknownExceptionReply(UnknownException e) {
        return this.createUnknownExceptionReply(e, null);
    }

    public OutputStream createUnknownExceptionReply(UnknownException e, ExtendedServerRequestInfo sri) {
        this.responseStatus = 999;
        this.systemException = e;
        this.createOutputStream();
        if (sri != null) {
            CDROutputStream exout = ORB.createCDROutputStream((ORB)this.orb, (boolean)this.outEndian);
            exout.putEndian();
            exout.write_value((Serializable)e.originalEx);
            ServiceContext exctx = new ServiceContext(9, exout.toByteArray());
            sri.add_reply_service_context(exctx, true);
        }
        int mc = 0;
        mc = e.originalEx instanceof RemoteException ? -910010480 : -910010465;
        String detail = RasHelper.throwableToString(e);
        UNKNOWN unk = new UNKNOWN(detail, mc, CompletionStatus.COMPLETED_NO);
        this.responseBuffer.writeSystemException((SystemException)unk);
        this.responseBuffer.putEndian();
        this.responseBuffer.write_value((Serializable)e.originalEx);
        return this.responseBuffer;
    }

    byte[] createUnknownExceptionReplyBytes(UnknownException e) {
        return this.createUnknownExceptionReplyBytes(e, null);
    }

    byte[] createUnknownExceptionReplyBytes(UnknownException e, ExtendedServerRequestInfo sri) {
        CDROutputStream out = (CDROutputStream)this.createUnknownExceptionReply(e, sri);
        byte[] result = this.cdrHandler != null ? WsByteBufferUtils.asByteArray(out.toByteBuffer()) : out.toByteArray();
        out.releaseBuffer();
        return result;
    }

    public void set_pv_extended(short pv_extended) {
        this.partner_version_extended = pv_extended;
    }

    public void set_pv_major(short pv_major) {
        this.partner_version_major = pv_major;
    }

    public void set_pv_minor(short pv_minor) {
        this.partner_version_minor = pv_minor;
    }

    private void createOutputStream() {
        if (this.useDefault) {
            this.responseBuffer = this.cdrHandler != null ? StreamFactory.createCDROutputHandler((Sink)this.cdrHandler) : ORB.createCDROutputStream();
        } else {
            this.responseBuffer = this.cdrHandler != null ? StreamFactory.createCDROutputHandler((ORB)this.orb, (Sink)this.cdrHandler, (boolean)this.outEndian, (int)this.initialSize) : ORB.createCDROutputStream((ORB)this.orb, (boolean)this.outEndian, (int)this.initialSize);
            this.responseBuffer.enableLargeDataBufferPool();
            if (this.charEncodingId != 0 || this.wcharEncodingId != 0) {
                this.responseBuffer.setCodeSets(this.charEncodingId, this.wcharEncodingId);
            }
            if (!this.isHTTP_Request) {
                this.responseBuffer.setGIOPVersions(this.giop_major, this.giop_minor, this.partner_version_major, this.partner_version_minor, this.partner_version_extended, this.customMaxStreamFormatVersion, this.responseFragmentEnabled);
            }
        }
        this.responseBuffer.write_long(this.responseStatus);
        this.responseBuffer.write_long(0);
    }

    public byte getCustomMaxStreamFormatForReply() {
        return this.customMaxStreamFormatVersion;
    }

    private byte validatedMaxStreamFormat(byte maxStreamFormat) {
        String methodName = "ResponseHandlerImpl.validatedMaxStreamFormat";
        byte sfv = maxStreamFormat;
        byte maxsfv = ORB.getMaximumCustomMarshalStreamFormatVersion();
        if (sfv > maxsfv) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ResponseHandlerImpl.validatedMaxStreamFormat", new Object[]{"SFV reduced to max supported by our ORB", "Target SFV = " + sfv, "ORB SFV = " + maxsfv});
            }
            sfv = maxsfv;
        }
        return sfv;
    }
}

