/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.ClientRequest;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.BaseCDRFragmentHandler;
import com.ibm.ws390.orb.ClientDelegate;
import com.ibm.ws390.orb.GIOPFragmentCppUtilities;
import com.ibm.ws390.orb.RequestEncap;
import com.ibm.ws390.orb.WS390InterceptorManager;
import com.ibm.ws390.orb.parameters.ORBEJSBridgeInvoke;
import com.ibm.ws390.ziop.ServiceContextManager;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OutboundRequestCDRFragmentHandler
extends BaseCDRFragmentHandler {
    private static final TraceComponent tc;
    private static boolean littleEndian;
    private boolean abnormalResponseReceived = false;
    private ClientRequest req = null;
    private ClientDelegate delegate = null;
    private ExtendedClientRequestInfo clientRequestInfo = null;
    private boolean isLocal = false;

    public OutboundRequestCDRFragmentHandler() {
    }

    public OutboundRequestCDRFragmentHandler(ORB orb) {
        super(orb);
    }

    public OutboundRequestCDRFragmentHandler(ORBEJSBridgeInvoke inv, ORB orb) {
        super(orb, inv.endian);
    }

    public void setRequestData(ClientRequest req, ClientDelegate delegate, boolean isLocal) {
        this.req = req;
        this.delegate = delegate;
        this.isLocal = isLocal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush(WsByteBuffer[] data) throws IOException {
        WsByteBuffer scDataManagedBuffer;
        WsByteBuffer outboundMessage;
        int rc;
        block22: {
            block21: {
                rc = -1;
                outboundMessage = null;
                ByteBuffer scDataOutbound = null;
                scDataManagedBuffer = null;
                String methodName = "flush";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "flush");
                }
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < data.length; ++i) {
                        byte[] tempBytes = new byte[data[i].remaining()];
                        int curPos = data[i].position();
                        data[i].get(tempBytes);
                        Tr.debug(tc, "flush fragment buffer[" + i + "]: ", tempBytes);
                        data[i].position(curPos);
                    }
                }
                try {
                    try {
                        RequestEncap encapInfo = (RequestEncap)this.req.getRequestEncap();
                        if (!this.firstWriteComplete) {
                            this.abnormalResponseReceived = false;
                            this.firstWriteComplete = true;
                            this.clientRequestInfo = WS390InterceptorManager.createClientInfo(this.orb, this.req, this.delegate, encapInfo.getTarget(), encapInfo.getClientConnectionInfo(), this.isLocal);
                            WS390InterceptorManager.interceptOutboundRequest(this.orb, this.clientRequestInfo);
                            byte[] scBytes = ServiceContextManager.marshalServiceContextData((ServiceContext[])this.req.getServiceContextList(), (boolean)littleEndian);
                            if (scBytes != null) {
                                scDataManagedBuffer = this.getBuffer(scBytes.length);
                                scDataManagedBuffer.put(scBytes);
                                scDataOutbound = scDataManagedBuffer.getWrappedByteBuffer();
                            }
                        }
                        if (this.abnormalResponseReceived) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "flush", "Exiting flush early because we already got a response");
                            }
                            Object var11_12 = null;
                            break block21;
                        }
                        if (data.length == 1) {
                            outboundMessage = data[0];
                        } else {
                            outboundMessage = this.getBuffer(WsByteBufferUtils.lengthOf(data));
                            outboundMessage.put(data);
                            outboundMessage.rewind();
                        }
                        rc = GIOPFragmentCppUtilities.flushRequestFragment(scDataOutbound, outboundMessage.getWrappedByteBuffer().slice(), encapInfo.requestPtr);
                        break block22;
                    }
                    catch (Throwable t) {
                        IOException ioe = new IOException("Native GIOP outbound request flush failed");
                        ioe.initCause(t);
                        throw ioe;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    WsByteBufferUtils.releaseBufferArray(data);
                    if (data.length > 1) {
                        outboundMessage.release();
                    }
                    if (scDataManagedBuffer != null) {
                        scDataManagedBuffer.release();
                    }
                    throw throwable;
                }
            }
            WsByteBufferUtils.releaseBufferArray(data);
            if (data.length > 1) {
                outboundMessage.release();
            }
            if (scDataManagedBuffer != null) {
                scDataManagedBuffer.release();
            }
            return;
        }
        Object var11_13 = null;
        WsByteBufferUtils.releaseBufferArray(data);
        if (data.length > 1) {
            outboundMessage.release();
        }
        if (scDataManagedBuffer != null) {
            scDataManagedBuffer.release();
        }
        if (rc < 0) {
            this.abnormalResponseReceived = true;
            throw new IOException("Native GIOP outbound request flush failed for unknown reason");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush");
        }
    }

    public ExtendedClientRequestInfo getClientRequestInfo() {
        return this.clientRequestInfo;
    }

    static {
        littleEndian = false;
        tc = Tr.register(OutboundRequestCDRFragmentHandler.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    }
}

