/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.ziop.ServiceContextManager;

public class ORBRServiceContextCache {
    private static final TraceComponent tc = Tr.register(ORBRServiceContextCache.class, "ORB", null);
    private static final int IBM_VSCID = 1229081856;
    private static final int MIN_OMG_VSCID = 0;
    private static final int MAX_OMG_VSCID = 3840;
    private ServiceContextManager scMgr = new ServiceContextManager();

    protected ORBRServiceContextCache() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ORBRServiceContextCache constructed");
        }
    }

    public void processIncomingContext(ServiceContext[] scArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processIncomingContext", scArray);
        }
        if (scArray != null) {
            for (int i = 0; i < scArray.length; ++i) {
                ServiceContext sc = scArray[i];
                if (sc == null) continue;
                int vscid = sc.getId() & 0xFFFFFF00;
                if (sc.getId() == 1229081890) {
                    this.scMgr.add(sc, true);
                }
                if (vscid == 1229081856 || vscid <= 3840 && vscid >= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caching service context with id:", new Integer(sc.getId()));
                }
                this.scMgr.add(sc, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processIncomingContext", this.scMgr);
        }
    }

    public void setServiceContext(int scId, byte[] scData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceContext", new Integer(scId));
        }
        ServiceContext sc = ORB.createServiceContext((int)scId, (byte[])scData);
        this.scMgr.add(sc, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceContext", scData);
        }
    }

    public ServiceContext getServiceContext(int scId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceContext", new Integer(scId));
        }
        ServiceContext sc = this.scMgr.get(scId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceContext", sc);
        }
        return sc;
    }

    public byte[] getServiceContextData(int scId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceContextData", new Integer(scId));
        }
        byte[] retData = null;
        ServiceContext sc = this.scMgr.get(scId);
        if (sc != null) {
            retData = sc.getContextData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceContextData", retData);
        }
        return retData;
    }

    public ServiceContext[] getServiceContexts() {
        return this.scMgr.get();
    }
}

