/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws390.interrupt.RoadKillCppUtilities;
import com.ibm.ws390.orb.CommonBridge;
import com.ibm.ws390.orb.ORBEJSBridge;
import com.ibm.ws390.orb.ORBRServiceContextCache;
import com.ibm.ws390.orb.ServerRegionBridge;
import com.ibm.ws390.orb.parameters.CommonInvoke;
import com.ibm.ws390.orb.parameters.HTTPInvoke;
import com.ibm.ws390.orb.parameters.ORBEJSBridgeInvoke;
import com.ibm.ws390.sm.smf.SmfContainerInfo;
import com.ibm.ws390.utility.JAVAtoCPPUtilities;

public class DispatchInterceptor {
    private static TraceComponent tc = Tr.register(DispatchInterceptor.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    public static final boolean PROPAGATE_UNKNOWN_SERVICE_CONTEXTS = JAVAtoCPPUtilities.getNativeBooleanVariable((String)"protocol_iiop_propagate_unknown_service_ctxs", (boolean)false);
    public static final boolean PROPAGATE_WLM_ENCLAVE_TOKEN = JAVAtoCPPUtilities.getNativeBooleanVariable((String)"protocol_iiop_local_propagate_wlm_enclave", (boolean)true);
    private static WSThreadLocal<DispatchInterceptor> dispatchState = new WSThreadLocal<DispatchInterceptor>(){

        @Override
        protected DispatchInterceptor initialValue() {
            return new DispatchInterceptor();
        }
    };
    private ORBRServiceContextCache _unknownContextsCache = null;
    private byte[] _wlmEnclaveToken = null;

    private DispatchInterceptor() {
    }

    private static void beginDispatchCommon(CommonBridge caller, CommonInvoke inv_params) {
        String mName = "beginDispatchCommon";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beginDispatchCommon");
        }
        dispatchState.get().resetDispatchState();
        caller.threadStarted();
        if (PROPAGATE_WLM_ENCLAVE_TOKEN && inv_params.wlmEnclaveToken != null) {
            DispatchInterceptor.setWlmEnclaveToken(inv_params.wlmEnclaveToken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caching wlmEnclaveToken under dispatch", inv_params.wlmEnclaveToken);
            }
        }
        if (SmfContainerInfo.isSmf120St9Enabled()) {
            SmfContainerInfo.setIsDispatchThread(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beginDispatchCommon");
        }
    }

    public static void beginHTTPDispatch(ServerRegionBridge caller, HTTPInvoke inv_params) {
        DispatchInterceptor.beginDispatchCommon(caller, (CommonInvoke)inv_params);
    }

    public static void beginIIOPDispatch(CommonBridge caller, ORBEJSBridgeInvoke inv_params) {
        DispatchInterceptor.beginDispatchCommon(caller, (CommonInvoke)inv_params);
        if (PROPAGATE_UNKNOWN_SERVICE_CONTEXTS) {
            DispatchInterceptor.dispatchState.get()._unknownContextsCache = new ORBRServiceContextCache();
        }
    }

    public static void endHTTPDispatch(ServerRegionBridge caller, HTTPInvoke inv_params) {
        DispatchInterceptor.endDispatchCommon(caller, (CommonInvoke)inv_params);
    }

    public static void endIIOPDispatch(CommonBridge caller, ORBEJSBridgeInvoke inv_params) {
        DispatchInterceptor.endDispatchCommon(caller, (CommonInvoke)inv_params);
    }

    private static void endDispatchCommon(CommonBridge caller, CommonInvoke inv_params) {
        block8: {
            String mName = "endDispatchCommon";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "endDispatchCommon");
            }
            try {
                inv_params.callerID = ContextManagerFactory.getInstance().getFirstAuthUser();
                if (inv_params.callerID != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "inv_params.callerID", inv_params.callerID);
                }
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) break block8;
                Tr.event(tc, "Caught exception obtaining first authenticated user", e);
            }
        }
        try {
            SmfContainerInfo.endDispatch();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws390.orb.DispatchInterceptor.endDispatchCommon", "210", caller);
        }
        caller.threadReturned();
        if (ORBEJSBridge.getOrbType() == 2 || ORBEJSBridge.getOrbType() == 5) {
            RoadKillCppUtilities.deregisterRequest((Object)null);
        }
        dispatchState.get().resetDispatchState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDispatchCommon");
        }
    }

    private void resetDispatchState() {
        this._wlmEnclaveToken = null;
        this._unknownContextsCache = null;
    }

    public static byte[] getWlmEnclaveToken() {
        return DispatchInterceptor.dispatchState.get()._wlmEnclaveToken;
    }

    public static byte[] setWlmEnclaveToken(byte[] newToken) {
        DispatchInterceptor.dispatchState.get()._wlmEnclaveToken = newToken;
        return newToken;
    }

    public static ORBRServiceContextCache getUnknownContextsCache() {
        return DispatchInterceptor.dispatchState.get()._unknownContextsCache;
    }
}

