/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.CustomService;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CustomServices {
    static Hashtable cs_Htable;
    static TraceComponent tc;

    public CustomServices() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CustomServices");
        }
        try {
            String filenames = System.getProperty("com.ibm.websphere.preconfiguredCustomServices");
            String delimeter = System.getProperty("path.separator");
            String next_file_name = null;
            int end_index = 0;
            int start_index = 0;
            int file_names_length = 0;
            int last_delimeter_index = 0;
            boolean end_of_file_names = true;
            if (filenames != null && (file_names_length = filenames.length()) > 0) {
                end_of_file_names = false;
                last_delimeter_index = filenames.lastIndexOf(delimeter);
                cs_Htable = new Hashtable();
                next_file_name = "";
            }
            while (!end_of_file_names) {
                try {
                    if (end_index < last_delimeter_index) {
                        end_index = filenames.indexOf(delimeter, end_index);
                        next_file_name = filenames.substring(start_index, end_index);
                    }
                    if (next_file_name.length() == 0 && end_index < file_names_length && end_index >= last_delimeter_index) {
                        next_file_name = filenames.substring(start_index, file_names_length);
                    }
                    if (next_file_name.length() != 0) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Custom Service xml file " + next_file_name + " is being installed");
                        }
                        this.installCustomServices(next_file_name);
                        next_file_name = "";
                    }
                    if (last_delimeter_index == -1 || end_index > last_delimeter_index) {
                        end_of_file_names = true;
                    }
                    start_index = ++end_index;
                }
                catch (Exception ex5) {
                    end_of_file_names = true;
                    Tr.audit(tc, "BBOJ0021");
                    Tr.error(tc, "Custom Services caught an exception while reading xml files");
                    ex5.printStackTrace();
                }
            }
        }
        catch (Exception ex4) {
            Tr.audit(tc, "BBOJ0022");
            Tr.error(tc, "Custom Services caught an internal exception");
            ex4.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CustomServices");
        }
    }

    public void installCustomServices(String xml_FileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CustomServices.installCustomService");
        }
        try {
            DOMParser parser = new DOMParser();
            parser.parse(xml_FileName);
            Document document = parser.getDocument();
            NodeList cs_list = document.getElementsByTagName("customServices");
            if (cs_list.getLength() == 0) {
                Tr.audit(tc, "BBOJ0023", xml_FileName);
            }
            for (int i = 0; i < cs_list.getLength(); ++i) {
                Element current_element = (Element)cs_list.item(i);
                String description = current_element.getAttribute("description");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Custom Service description -> " + description);
                }
                if (current_element.getAttribute("enable").compareTo("true") == 0) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Custom Service " + description + " is enabled");
                    }
                    String class_name = current_element.getAttribute("classname");
                    String config_URL = current_element.getAttribute("externalConfigURL");
                    if (class_name == null || class_name.compareTo("") == 0) {
                        Tr.audit(tc, "BBOJ0024", description);
                    } else if (tc.isEventEnabled()) {
                        Tr.event(tc, "Custom Service class name is -> " + class_name);
                    }
                    try {
                        Class<?> classToNewUp = Class.forName(class_name);
                        Object newClassInstance = classToNewUp.newInstance();
                        Properties initilization_parameters = new Properties();
                        initilization_parameters.setProperty("com.ibm.websphere.runtime.CustomService.externalConfigURLKey", config_URL);
                        if (config_URL == null || config_URL.compareTo("") == 0) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Custom Service " + description + " has no configuration parameters");
                            }
                        } else if (tc.isEventEnabled()) {
                            Tr.event(tc, "Custom Service " + description + " configuration parameters -> " + config_URL);
                        }
                        try {
                            ((CustomService)newClassInstance).initialize(initilization_parameters);
                            cs_Htable.put(class_name, newClassInstance);
                        }
                        catch (Exception ex1) {
                            Tr.audit(tc, "BBOJ0025", description);
                            Tr.error(tc, "Custom Services caught an exception while initializing {0}", description);
                            ex1.printStackTrace();
                        }
                    }
                    catch (Exception ex2) {
                        Tr.audit(tc, "BBOJ0026", description);
                        Tr.error(tc, "Custom Services caught an exception while newing up {0}", description);
                        ex2.printStackTrace();
                    }
                    continue;
                }
                Tr.audit(tc, "BBOJ0027", description);
            }
        }
        catch (Exception ex3) {
            Tr.audit(tc, "BBOJ0028", xml_FileName);
            Tr.error(tc, "Custom Services caught an exception while reading {0}", xml_FileName);
            ex3.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CustomServices.installCustomService");
        }
    }

    public static void shutdownCustomServices() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CustomServices.shutdownCustomServices");
        }
        if (cs_Htable != null) {
            Enumeration cs_keys = cs_Htable.keys();
            while (cs_keys.hasMoreElements()) {
                try {
                    Object next_key_in_table = cs_keys.nextElement();
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Custom Services is Shutting Down -> " + next_key_in_table.toString());
                    }
                    Class<?> classToShutDown = Class.forName(next_key_in_table.toString());
                    Object obj_Instance = cs_Htable.get(next_key_in_table);
                    ((CustomService)obj_Instance).shutdown();
                    cs_Htable.remove(next_key_in_table);
                }
                catch (Exception esd) {
                    Tr.audit(tc, "BBOJ0029", esd);
                    Tr.error(tc, "Custom Services caught an exception in shutdownCustomServices");
                    esd.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CustomServices.shutdownCustomServices");
        }
    }

    static {
        tc = Tr.register(CustomServices.class, "ORB");
    }
}

