/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.CodeSetComponentInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ServerSubcontract;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.CORBA.iiop.SubcontractRegistry;
import com.ibm.CORBA.poa.POAServerDelegate;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.pi.ServerRequestInfoImpl;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws390.channel.ziop.ORBServiceContextFilter;
import com.ibm.ws390.channel.ziop.ZIOPMessageContext;
import com.ibm.ws390.orb.Constants;
import com.ibm.ws390.orb.PartnerVersion;
import com.ibm.ws390.orb.ResponseHandlerImpl;
import com.ibm.ws390.orb.ServiceContextUtils;
import com.ibm.ws390.orb.WS390InterceptorManager;
import com.ibm.ws390.orb.parameters.ORBEJSBridgeInvoke;
import com.ibm.ws390.ziop.ServiceContextManager;
import com.ibm.ws390.ziop.ZIOPConnectionState;
import com.ibm.ws390.ziop.ZIOPConnectionStateElement;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import java.nio.ByteBuffer;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.ServiceContext;

public class ClientCallbackDispatch
extends ORBEJSBridgeInvoke {
    private static final String ME = ClientCallbackDispatch.class.getName();
    private static final TraceComponent tc = Tr.register(ME, Constants.ORB_TR_GROUP, null);
    private static final PartnerVersion callback_pv = new PartnerVersion();
    public ByteBuffer objKeyData = null;
    public byte[] scDataOutbound = null;
    protected boolean isPOAObject = false;
    protected boolean attemptedRequestInterceptors = false;
    protected ORB invoke_orb = null;
    protected ConnectionHandle connID = null;
    protected ZIOPConnectionStateElement connState = null;
    protected CDRInputStream paramStream = null;
    protected ExtendedServerRequestInfo sri = null;
    protected Throwable responseException = null;
    protected com.ibm.CORBA.iiop.ServiceContext[] scInboundList = null;
    protected ObjectKey objectKey = null;
    protected Object servant = null;
    protected ServerSubcontract serverSC = null;
    protected ResponseHandlerImpl rh = null;
    private static boolean cachedContexts = false;
    private static ORBServiceContextFilter contextFilter = null;
    private static ServiceContext localPVContext = null;
    private static ServiceContext localMaxStreamVersion = null;
    private static ServiceContext localSendingRuntimeContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] invoke(String operation, ByteBuffer objKeyData, ByteBuffer scDataInbound, byte[] handleBytes, byte[] params, short bodyPad, short req_giop_version, boolean endian) {
        String m_name = "invoke";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{operation});
        }
        this.operation = operation;
        this.objKeyData = objKeyData;
        this.scDataInbound = scDataInbound;
        this.scDataOutbound = null;
        this.connectionHandle = handleBytes;
        this.params = params;
        this.pad = bodyPad;
        this.endian = endian;
        this.req_giop_version = req_giop_version;
        byte[] result = null;
        CDROutputStream resultStream = null;
        try {
            this.connID = new ConnectionHandle(this.connectionHandle);
            this.connState = ZIOPConnectionState.checkConnection((ConnectionHandle)this.connID);
            if (this.connState == null || !this.connState.isConnectionHealthy()) {
                throw new COMM_FAILURE("Connection is null or broken: " + this.connState, -910010564, CompletionStatus.COMPLETED_NO);
            }
            this.invoke_orb = this.connState.getORB();
            if (this.invoke_orb == null) {
                throw new INTERNAL("No ORB found for this connection: " + this.connState, -910010568, CompletionStatus.COMPLETED_NO);
            }
            this.runInboundContextInterceptors();
            this.createStreamHandlers();
            this.getServant();
            resultStream = this.dispatch();
            result = resultStream.toByteArray();
            resultStream.releaseBuffer();
        }
        catch (OBJECT_NOT_EXIST one_ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "invoke Object Not Exist", (Object)one_ex);
            }
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            result = this.rh.createSystemExceptionReplyBytes((SystemException)one_ex);
        }
        catch (Throwable ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "invoke Unexpected Exception", ex);
            }
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            if (ex instanceof SystemException) {
                SystemException sys_ex = (SystemException)ex;
                result = this.rh.createSystemExceptionReplyBytes(sys_ex);
            } else {
                UnknownException ukex = new UnknownException(ex);
                result = this.rh.createUnknownExceptionReplyBytes(ukex, this.sri);
            }
        }
        finally {
            this.runOutboundContextInterceptors();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", result);
        }
        return result;
    }

    protected CDROutputStream dispatch() throws Throwable {
        String m_name = "dispatch()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispatch()", new Object[]{this.servant, this.operation});
        }
        Throwable responseException = null;
        CDROutputStream resultStream = null;
        try {
            if (this.operation.equals("_is_a")) {
                boolean answer = this.objectIsA();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatch()", "operation = _is_a " + String.valueOf(answer));
                }
                resultStream = (CDROutputStream)this.rh.createReply();
                resultStream.write_boolean(answer);
            } else if (this.operation.equals("_non_existent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatch()", "operation = _non_existent " + (this.servant == null));
                }
                resultStream = (CDROutputStream)this.rh.createReply();
                resultStream.write_boolean(this.servant == null);
            } else if (this.operation.equals("_interface")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatch()", "operation = _interface ");
                }
                NO_IMPLEMENT ex = new NO_IMPLEMENT("_interface is not supported", -910010565, CompletionStatus.COMPLETED_NO);
                resultStream = (CDROutputStream)this.rh.createSystemExceptionReply((SystemException)ex);
            } else {
                this.attemptedRequestInterceptors = true;
                WS390InterceptorManager.interceptInboundRequest(this.invoke_orb, this.sri);
                resultStream = (CDROutputStream)((InvokeHandler)this.servant)._invoke(this.operation, (InputStream)this.paramStream, (ResponseHandler)this.rh);
            }
        }
        catch (BAD_OPERATION boex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "dispatch() Bad Operation", (Object)boex);
            }
            responseException = boex;
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            resultStream = (CDROutputStream)this.rh.createSystemExceptionReply((SystemException)boex);
        }
        catch (UnknownException ukex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "dispatch() Unknown User Eception", (Object)ukex);
            }
            responseException = ukex;
            this.rh = ResponseHandlerImpl.getHandler(this.rh);
            resultStream = (CDROutputStream)this.rh.createUnknownExceptionReply(ukex, this.sri);
        }
        catch (ThreadDeath tdex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "dispatch() Thread Death", tdex);
            }
            responseException = tdex;
            throw tdex;
        }
        catch (Throwable t) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "exception occurred in dispatch", t);
            }
            responseException = t;
            throw t;
        }
        finally {
            if (this.attemptedRequestInterceptors) {
                WS390InterceptorManager.interceptOutboundResponse(this.invoke_orb, this.sri, responseException, this.rh);
            }
            if (this.isPOAObject) {
                ((POAServerDelegate)this.serverSC).releasePOAServant(this.servant, this.objectKey, this.sri);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispatch()");
        }
        return resultStream;
    }

    protected void createStreamHandlers() throws Exception {
        String m_name = "createStreamHandlers";
        if (this.req_tcsc == 0 || this.req_tcsw == 0) {
            throw new INTERNAL("Unable to create data streams; codeSet information is missing (tcsc=" + this.req_tcsc + ",tcsw=" + this.req_tcsw + ")", -910010567, CompletionStatus.COMPLETED_NO);
        }
        PartnerVersion use_pv = PartnerVersion.getPartnerVersion(this.req_pv_major, this.req_pv_minor, this.req_pv_extended, this.req_pv_status, callback_pv);
        this.rh = new ResponseHandlerImpl(this.invoke_orb, this.endian, this.req_tcsc, this.req_tcsw, this.req_giop_version, this.customMaxStreamFormatForReply, use_pv);
        this.paramStream = this.rh.getParameterInputStream(this.params, this.pad);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createStreamHandlers", new Object[]{"PartnerVersion", "Client(remote) = " + use_pv.toString(), "Server(this) = " + callback_pv.toString()});
        }
    }

    protected void getServant() throws Exception {
        String m_name = "getServant";
        this.objectKey = this.invoke_orb.createObjectKey(this.objKeyData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServant", this.objectKey);
        }
        SubcontractRegistry registry = this.invoke_orb.getSubcontractRegistry();
        if (this.objectKey != null && registry != null) {
            this.serverSC = registry.getServerSubcontract(this.objectKey);
            if (this.serverSC != null) {
                if (this.serverSC.isServantSupported()) {
                    this.servant = this.serverSC.getServant(this.objectKey);
                } else {
                    this.servant = ((POAServerDelegate)this.serverSC).getPOAServant(this.objectKey, this.sri);
                    this.isPOAObject = true;
                }
            }
        }
        if (this.servant == null && !this.isPOAObject && !this.operation.equals("_non_existent")) {
            throw new OBJECT_NOT_EXIST("Requested Object does not exist: " + this.objectKey, -910010566, CompletionStatus.COMPLETED_NO);
        }
        if (this.servant != null && this.sri instanceof ServerRequestInfoImpl) {
            ((ServerRequestInfoImpl)this.sri).setTarget(this.servant);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServant", new Object[]{this.servant, Boolean.toString(this.isPOAObject)});
        }
    }

    protected ExtendedServerRequestInfo runInboundContextInterceptors() throws Throwable {
        String m_name = "runInboundContextInterceptors";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "runInboundContextInterceptors parsing contexts", this.invoke_orb);
        }
        if (!cachedContexts) {
            ClientCallbackDispatch.initializeContexts(this.invoke_orb);
        }
        ServiceContextManager scMgr = new ServiceContextManager(this.scDataInbound, this.endian);
        ZIOPMessageContext msg = new ZIOPMessageContext();
        msg.setServiceContexts((ServiceContextList)scMgr);
        msg.setType(0);
        contextFilter.processIncomingContext(this.invoke_orb, (GIOPMessageContext)msg, (GIOPConnectionContext)this.connState.getConnectionContext(), (ConnectionStateElement)this.connState);
        this.scInboundList = ServiceContextUtils.consumeServiceContexts(this.invoke_orb, scMgr, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "runInboundContextInterceptors", this.scInboundList.length + " inbound contexts");
        }
        this.sri = WS390InterceptorManager.prepareServerRequestInfo(this.invoke_orb, this.operation, this.scInboundList, this.connID);
        WS390InterceptorManager.interceptInboundContexts(this.invoke_orb, this.sri);
        return this.sri;
    }

    protected void runOutboundContextInterceptors() {
        block7: {
            String m_name = "runOutboundContextInterceptors";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "runOutboundContextInterceptors marshalling contexts", this.invoke_orb);
            }
            if (this.sri == null) {
                return;
            }
            try {
                if (!cachedContexts) {
                    ClientCallbackDispatch.initializeContexts(this.invoke_orb);
                }
                this.sri.add_reply_service_context(localPVContext, true);
                this.sri.add_reply_service_context(localMaxStreamVersion, true);
                if (this.invoke_orb.getCbSupported() && localSendingRuntimeContext != null) {
                    this.sri.add_reply_service_context(localSendingRuntimeContext, true);
                }
                CodeSetComponentInfo.CodeSetContext cs = ORB.createCodeSetContext((int)this.req_tcsc, (int)this.req_tcsw);
                com.ibm.CORBA.iiop.ServiceContext[] scOutboundList = this.sri.getReplyServiceContextList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "runOutboundContextInterceptors", scOutboundList.length + " outbound contexts");
                }
                this.scDataOutbound = ServiceContextManager.marshalServiceContextData((com.ibm.CORBA.iiop.ServiceContext[])scOutboundList, (boolean)this.endian);
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Exception while marshalling outbound contexts", e);
            }
        }
    }

    protected boolean objectIsA() {
        if (this.paramStream == null || this.paramStream.isAtEnd()) {
            return false;
        }
        String clientId = this.paramStream.read_string();
        for (int i = 0; i < ((ObjectImpl)this.servant)._ids().length; ++i) {
            if (!((ObjectImpl)this.servant)._ids()[i].equals(clientId)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void initializeContexts(ORB orb) {
        if (cachedContexts) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeContexts");
        }
        contextFilter = ORBServiceContextFilter.instance();
        localPVContext = ServiceContextUtils.getPVServiceContext(orb);
        localMaxStreamVersion = ServiceContextUtils.getCustomMaxStreamFormatContext(orb);
        localSendingRuntimeContext = ServiceContextUtils.getSendingRuntimeContext(orb);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeContexts");
        }
    }
}

