/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.jms.listener.WS390EndPointClassificationInfo;
import com.ibm.ejs.jms.listener.WS390EndPointClassificationParser;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.orb.SibClassificationParser;
import com.ibm.ws390.orb.WMQRAClassificationParser;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClassificationParser
implements ErrorHandler {
    private static final String DEFAULTCLASSIFICATION_STRING = "defaultclassification";
    private static final String NAME_STRING = "name";
    private static final String CLASSIFICATION_STRING = "classification";
    private static final String SELECTOR_STRING = "selector";
    private static final String CLASSIFICATIONENTRY_STRING = "classificationentry";
    private static final short iiop_type = 1;
    private static final short http_type = 2;
    private static final short mdb_type = 3;
    private static final short internal_type = 4;
    private static final short sip_type = 5;
    private static boolean got_iiop = false;
    private static boolean got_http = false;
    private static boolean got_mdb = false;
    private static boolean got_internal = false;
    private static boolean got_sip = false;
    private static TraceComponent tc;

    public void error(SAXParseException spe) throws SAXException {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Error parsing WLM classification XML " + spe);
        }
        throw spe;
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Fatal error parsing WLM classification XML " + spe);
        }
        throw spe;
    }

    public void warning(SAXParseException spe) throws SAXException {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Warning parsing WLM classification XML " + spe);
        }
    }

    private static native void createIIOPRoot(String var0);

    private static native void makeIIOPChild(String var0, String var1, String var2, String var3, String var4, String var5, String var6);

    private static native void goUpIIOP();

    private static native void createHTTPRoot(String var0);

    private static native void goUpHTTP();

    private static native void makeHTTPChild(String var0, String var1, String var2, String var3, String var4);

    private static native void createInternalRoot(String var0);

    private static native void createSIPRoot(String var0);

    private static native void parseError();

    private static String validatetc(String tc) {
        if (tc.length() > 8) {
            throw new IllegalArgumentException("Transaction Class " + tc + " is greater than 8 bytes long");
        }
        return tc;
    }

    private static void iterateChildren(Element e, short type) {
        NodeList iiopnl = e.getChildNodes();
        block7: for (int j = 0; j < iiopnl.getLength(); ++j) {
            Node n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "iterateChildren node #" + j);
            }
            if ((n = iiopnl.item(j)) == null || n.getNodeType() != 1) continue;
            switch (type) {
                case 1: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "iterateChildren node is IIOP, adding element");
                    }
                    ClassificationParser.addIIOPElement((Element)n);
                    continue block7;
                }
                case 2: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "iterateChildren node is HTTP, adding element");
                    }
                    ClassificationParser.addHTTPElement((Element)n);
                    continue block7;
                }
                case 3: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "iterateChildren node is MDB, adding element");
                    }
                    ClassificationParser.addMDBElement((Element)n);
                    continue block7;
                }
                case 4: {
                    throw new IllegalArgumentException("Internal node should have no child nodes");
                }
                case 5: {
                    throw new IllegalArgumentException("SIP node should have no child nodes");
                }
            }
        }
    }

    private static void addIIOPElement(Element e) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding IIOP element");
        }
        ClassificationParser.makeIIOPChild(ClassificationParser.validatetc(e.getAttribute("transaction_class")), e.getAttribute("application_name"), e.getAttribute("module_name"), e.getAttribute("component_name"), e.getAttribute("method_name"), e.getAttribute("activity_workload_classification"), e.getAttribute("description"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added IIOP element, iterating children");
        }
        ClassificationParser.iterateChildren(e, (short)1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Going up (IIOP)");
        }
        ClassificationParser.goUpIIOP();
    }

    private static void addHTTPElement(Element e) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding HTTP element");
        }
        ClassificationParser.makeHTTPChild(ClassificationParser.validatetc(e.getAttribute("transaction_class")), e.getAttribute("uri"), e.getAttribute("host"), e.getAttribute("port"), e.getAttribute("description"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added HTTP element, iterating children");
        }
        ClassificationParser.iterateChildren(e, (short)2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Going up (HTTP)");
        }
        ClassificationParser.goUpHTTP();
    }

    private static void addMDBElement(Element endpointElement) {
        NodeList classificationEntriesList;
        String name = endpointElement.getAttribute(NAME_STRING);
        WS390EndPointClassificationInfo epci = new WS390EndPointClassificationInfo(name);
        epci.setDefaultClassificationString(ClassificationParser.validatetc(endpointElement.getAttribute(DEFAULTCLASSIFICATION_STRING)));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting up epci name=" + name + " default=" + endpointElement.getAttribute(DEFAULTCLASSIFICATION_STRING));
        }
        if ((classificationEntriesList = endpointElement.getElementsByTagName(CLASSIFICATIONENTRY_STRING)) != null) {
            for (int k = 0; k < classificationEntriesList.getLength(); ++k) {
                Element classificationEntryElement = (Element)classificationEntriesList.item(k);
                if (classificationEntryElement == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding to epci name=" + name + " selector=" + classificationEntryElement.getAttribute(SELECTOR_STRING) + " classification=" + classificationEntryElement.getAttribute(CLASSIFICATION_STRING));
                }
                epci.addEntry(classificationEntryElement.getAttribute(SELECTOR_STRING), ClassificationParser.validatetc(classificationEntryElement.getAttribute(CLASSIFICATION_STRING)));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding MDB classification name=" + name);
        }
        WS390EndPointClassificationParser.getInstance().addClassification(name, epci);
    }

    private static Element validateXML(String filename, String dtd_loc) {
        Document doc = null;
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory docBuilderFactory = null;
        Element e = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(true);
            docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ClassificationParser());
            doc = docBuilder.parse(new FileInputStream(filename), dtd_loc);
            e = doc.getDocumentElement();
            if (e != null) {
                if (!e.getTagName().equals("Classification")) {
                    throw new IllegalArgumentException("root node is wrong tag");
                }
                if (!e.getAttribute("schema_version").equals("1.0")) {
                    throw new IllegalArgumentException("unsupported version of Classification");
                }
            }
        }
        catch (Exception ex) {
            Tr.audit(tc, "BBOJ0085", ex.toString());
            e = null;
        }
        return e;
    }

    public static void parseClassificationXML(String filename, String dtd_loc) {
        Element e;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parsing classification XML " + filename + " via " + dtd_loc);
        }
        if ((e = ClassificationParser.validateXML(filename, dtd_loc)) != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XML valid, fetching nodes");
                }
                NodeList nl = e.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el;
                    String name;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing node #" + i);
                    }
                    if (nl.item(i).getNodeType() != 1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "node is an element");
                    }
                    if ((name = (el = (Element)nl.item(i)).getTagName()).equals("InboundClassification")) {
                        if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) continue;
                        ClassificationParser.parseInboundClassification(el);
                        continue;
                    }
                    if (name.equals("SibClassification")) {
                        SibClassificationParser.getInstance().parse(el);
                        continue;
                    }
                    if (name.equals("WMQRAClassification")) {
                        WMQRAClassificationParser.getInstance().parse(el);
                        continue;
                    }
                    throw new IllegalArgumentException("Node inside root is not InboundClassification or SibClassification");
                }
            }
            catch (Exception ex) {
                Tr.audit(tc, "BBOJ0085", ex.toString());
                ClassificationParser.parseError();
                WS390EndPointClassificationParser.getInstance().parseError();
                SibClassificationParser.getInstance().clear();
                WMQRAClassificationParser.getInstance().clear();
            }
        }
    }

    private static void parseInboundClassification(Element el) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parsing InboundClassification");
        }
        if (!el.getAttribute("schema_version").equals("1.0")) {
            throw new IllegalArgumentException("unsupported version of InboundClassification");
        }
        String type = el.getAttribute("type");
        if (type.equals("iiop")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IIOP classification element");
            }
            if (got_iiop) {
                throw new IllegalArgumentException("more than one IIOP classification section found");
            }
            got_iiop = true;
            String default_tc = ClassificationParser.validatetc(el.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating IIOP root tc=" + default_tc);
            }
            ClassificationParser.createIIOPRoot(default_tc);
            ClassificationParser.iterateChildren(el, (short)1);
        } else if (type.equals("mdb")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MDB classification element");
            }
            if (got_mdb) {
                throw new IllegalArgumentException("more than one MDB classification section found");
            }
            got_mdb = true;
            String default_tc = ClassificationParser.validatetc(el.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting MDB default tc=" + default_tc);
            }
            WS390EndPointClassificationParser.getInstance().setMDB_DEFAULT_CLASSIFICATION(default_tc);
            ClassificationParser.iterateChildren(el, (short)3);
        } else if (type.equals("http")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HTTP classification element");
            }
            if (got_http) {
                throw new IllegalArgumentException("more than one HTTP classification section found");
            }
            got_http = true;
            String default_tc = ClassificationParser.validatetc(el.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating HTTP root tc=" + default_tc);
            }
            ClassificationParser.createHTTPRoot(default_tc);
            ClassificationParser.iterateChildren(el, (short)2);
        } else if (type.equals("internal")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Internal classification element");
            }
            if (got_internal) {
                throw new IllegalArgumentException("more than one Internal classification section found");
            }
            got_internal = true;
            String default_tc = ClassificationParser.validatetc(el.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating Internal root tc=" + default_tc);
            }
            ClassificationParser.createInternalRoot(default_tc);
            ClassificationParser.iterateChildren(el, (short)4);
        } else if (type.equals("sip")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SIP classification element");
            }
            if (got_sip) {
                throw new IllegalArgumentException("more than one sip classification section found");
            }
            got_sip = true;
            String default_tc = ClassificationParser.validatetc(el.getAttribute("default_transaction_class"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating sip root tc=" + default_tc);
            }
            ClassificationParser.createSIPRoot(default_tc);
            ClassificationParser.iterateChildren(el, (short)5);
        }
    }

    public static void clearFlags() {
        got_iiop = false;
        got_http = false;
        got_mdb = false;
        got_internal = false;
        got_sip = false;
    }

    static {
        String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
        int bitmode = Integer.parseInt(CurrentBitmode);
        if (bitmode == 64) {
            System.loadLibrary("bbgboa");
        } else {
            System.loadLibrary("bboboa");
        }
        tc = Tr.register(ClassificationParser.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    }
}

