/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.MultiDomainHelper;
import com.ibm.ws390.orb.ORBEJSBridge;
import com.ibm.ws390.tx.TranAffinityRouterHelper;
import com.ibm.ws390.utility.JAVAtoCPPUtilities;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_IMPLEMENT;

public class BOSSObjectKey
extends ObjectKey
implements com.ibm.ws.orb.BOSSObjectKey {
    private static final TraceComponent tc = Tr.register(BOSSObjectKey.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static final int UUID_LEN = 20;
    private static final int GENERIC_SERVER_NAME_LEN = 8;
    private static final int BOSSKEY_MAP_LEN = 196;
    private static final int QUEUE_BY_STOKEN_LEN = 20;
    private static final int QUEUE_BY_APPLENV_LEN = 36;
    public static final int ORBK_EYE = -690371886;
    private static final int CKEY_EYE = -1009596952;
    private static final int CLAS_EYE = -1009532446;
    private static final int TYPE_EYE = -471279675;
    private static final int SECD_EYE = -490355772;
    private static final int APPL_EYE = -1042819117;
    private static final int STOK_EYE = -488384814;
    private static final byte[] ORBK_EYE_BYTES = new byte[]{-42, -39, -62, -46};
    private static final int I_uuid = 12;
    private static final int I_genericServerName = 44;
    private static final int I_orbkEye = 0;
    private static final int I_scId = 1;
    private static final int I_serverId = 2;
    private static final int I_userKeyOffset = 8;
    private static final int I_userKeyLength = 9;
    private static final int I_version = 10;
    private static final int I_flags = 13;
    private static final int I_typeIdOffset = 23;
    private static final int I_typeIdLength = 24;
    private static final int I_classNameOffset = 25;
    private static final int I_classNameLength = 26;
    private static final int I_ckeyOffset = 27;
    private static final int I_ckeyLength = 28;
    private static final int I_queueByStokenOffset = 31;
    private static final int I_queueByStokenLength = 32;
    private static final int I_queueByApplenvOffset = 33;
    private static final int I_queueByApplenvLength = 34;
    private static final int I_securityDomainOffset = 37;
    private static final int I_securityDomainLength = 38;
    private static final int I_LAST = 48;
    private static final byte[] localGenericServerNameBytes;
    private static final byte[] localGenericUuid;
    private static final byte[] localSpecificUuid;
    private static final byte[] localIplTime;
    private static final boolean localNoInternalWorkThreads;
    private ByteBuffer _objKeyWithLen = null;
    private ByteBuffer _objKey;
    private IntBuffer _objKeyIntView;
    private String _typeId = null;
    private String _className = null;
    private byte[] _ckey = null;
    private byte[] _securityDomain = null;
    private String _applenv = null;
    private byte[] _stoken = null;
    private byte[] _uuid = null;
    private String _genericServerName = null;

    public BOSSObjectKey() {
    }

    public BOSSObjectKey(ByteBuffer objKey) {
        super(objKey);
        this._objKey = objKey.duplicate();
        this._objKey.rewind();
        this._objKeyIntView = this._objKey.asIntBuffer();
        if (this._objKeyIntView.get(0) != -690371886) {
            throw new INV_OBJREF("Invalid object key for WebSphere Application Server for z/OS", -910010558, CompletionStatus.COMPLETED_NO);
        }
    }

    public BOSSObjectKey(byte[] objKey) {
        super(objKey);
        if (objKey.length > 0) {
            this._objKey = ByteBuffer.wrap(objKey);
            this._objKeyIntView = this._objKey.asIntBuffer();
            if (this._objKeyIntView.get(0) != -690371886) {
                throw new INV_OBJREF("Invalid object key for WebSphere Application Server for z/OS", -910010559, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public BOSSObjectKey(String typeId, String className, byte[] containerKey, boolean isDirect, boolean isCallback, boolean isCorbaObject, byte[] clusterData) {
        throw new NO_IMPLEMENT("deprecated BOSSObjectKey CTOR");
    }

    public BOSSObjectKey(String typeId, String className, UserKey userKey, boolean isDirect, boolean isCallback, boolean isCorbaObject) {
        this(typeId, className, null, userKey, isDirect, isCallback, isCorbaObject);
    }

    public BOSSObjectKey(String typeId, String className, byte[] containerKey, UserKey userKey, boolean isDirect, boolean isCallback, boolean isCorbaObject) {
        super(ORBK_EYE_BYTES);
        String mName = "BOSSObjectKey.CTOR";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BOSSObjectKey.CTOR", new Object[]{typeId, className, containerKey, userKey, new Boolean(isDirect), new Boolean(isCallback), new Boolean(isCorbaObject)});
        }
        this._typeId = typeId;
        this._className = className;
        this._ckey = userKey != null ? userKey.getBytes() : containerKey;
        boolean isTranObject = TranAffinityRouterHelper.isTransactionalSystemObject((String)this._typeId);
        this._securityDomain = MultiDomainHelper.getSecurityDomain(this._ckey, this._className);
        this.buildBOSSObjectKey();
        this.setFlag(0x4000000);
        if (ORBEJSBridge.getOrbType() == 1) {
            this.setFlag(Integer.MIN_VALUE);
        } else if (userKey != null && ByteBuffer.wrap(this._ckey).getInt(0) == 1229277776) {
            ByteBuffer ejbKey;
            com.ibm.ejs.oa.UserKey uk = (com.ibm.ejs.oa.UserKey)userKey;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checking userkey.servantKey for stateful session", uk.getServantKey());
            }
            if ((ejbKey = ByteBuffer.wrap(uk.getServantKey())).getShort(0) == 44204 && ejbKey.get(6) == 2) {
                this.setFlag(0x1000000);
            }
        }
        if (isTranObject) {
            this.setFlag(131072);
            isDirect = true;
        }
        if (isDirect) {
            this._objKey.position(12);
            this._objKey.put(localSpecificUuid);
            this.setFlag(0x20000000);
        } else {
            this._objKey.position(12);
            this._objKey.put(localGenericUuid);
        }
        if (isCallback) {
            this.setFlag(0x2000000);
        }
        if (isCorbaObject) {
            this.setFlag(0x400000);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BOSSObjectKey.CTOR", this.getBytes());
        }
    }

    private void buildBOSSObjectKey() {
        String mName = "buildBOSSObjectKey";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildBOSSObjectKey");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "typeId", this._typeId);
            Tr.debug(tc, "className", this._className);
            Tr.debug(tc, "ckey", this._ckey);
            Tr.debug(tc, "securityDomain", this._securityDomain);
        }
        int typeIdCompDataLen = this._typeId != null ? 4 + (this._typeId.length() + 1 + 3) / 4 * 4 : 0;
        int classNameCompDataLen = this._className != null ? 4 + (this._className.length() + 1 + 3) / 4 * 4 : 0;
        int ckeyCompDataLen = this._ckey != null ? 4 + (this._ckey.length + 3) / 4 * 4 : 0;
        int securityDomainCompDataLen = this._securityDomain != null ? 4 + (this._securityDomain.length + 3) / 4 * 4 : 0;
        int totalCompDataLen = typeIdCompDataLen + classNameCompDataLen + ckeyCompDataLen + securityDomainCompDataLen;
        int totalBufferLen = 200 + totalCompDataLen + 20 + 36;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "various lengths", new Object[]{"typeIdCompDataLen", new Integer(typeIdCompDataLen), "classNameCompDataLen", new Integer(classNameCompDataLen), "ckeyCompDataLen", new Integer(ckeyCompDataLen), "securityDomainCompDataLen", new Integer(securityDomainCompDataLen), "totalBufferLen", new Integer(totalBufferLen)});
        }
        this._objKeyWithLen = ByteBuffer.allocate(totalBufferLen);
        this._objKey = ((ByteBuffer)this._objKeyWithLen.position(4)).slice();
        this._objKeyIntView = this._objKey.asIntBuffer();
        this._objKeyWithLen.putInt(0, 196 + totalCompDataLen);
        this._objKeyIntView.put(0, -690371886);
        this._objKeyIntView.put(1, 16);
        this._objKeyIntView.put(8, 40);
        this._objKeyIntView.put(9, 156 + totalCompDataLen);
        this._objKeyIntView.put(10, 3);
        this._objKey.position(44);
        this._objKey.put(localGenericServerNameBytes);
        int compData_i = 196;
        try {
            if (typeIdCompDataLen > 0) {
                this._objKeyIntView.put(23, compData_i);
                this._objKeyIntView.put(24, this._typeId.length() + 1);
                this._objKey.position(compData_i);
                this._objKey.putInt(-471279675);
                this._objKey.put(this._typeId.getBytes("Cp1047"));
                this._objKey.put((byte)0);
                compData_i += typeIdCompDataLen;
            }
            if (classNameCompDataLen > 0) {
                this._objKeyIntView.put(25, compData_i);
                this._objKeyIntView.put(26, this._className.length() + 1);
                this._objKey.position(compData_i);
                this._objKey.putInt(-1009532446);
                this._objKey.put(this._className.getBytes("Cp1047"));
                this._objKey.put((byte)0);
                compData_i += classNameCompDataLen;
            }
        }
        catch (UnsupportedEncodingException ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getBytes(Cp1047) failed", ex);
            }
            throw new RuntimeException(ex);
        }
        if (ckeyCompDataLen > 0) {
            this._objKeyIntView.put(27, compData_i);
            this._objKeyIntView.put(28, this._ckey.length);
            this._objKey.position(compData_i);
            this._objKey.putInt(-1009596952);
            this._objKey.put(this._ckey);
            compData_i += ckeyCompDataLen;
        }
        if (securityDomainCompDataLen > 0) {
            this._objKeyIntView.put(37, compData_i);
            this._objKeyIntView.put(38, this._securityDomain.length);
            this._objKey.position(compData_i);
            this._objKey.putInt(-490355772);
            this._objKey.put(this._securityDomain);
            this.setFlag(65536);
            compData_i += securityDomainCompDataLen;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildBOSSObjectKey", this.getBytes());
        }
    }

    public byte[] getServerUUID() {
        if (this._uuid == null) {
            this._uuid = new byte[20];
            ByteBuffer _objKey = this._objKey.duplicate();
            _objKey.position(12);
            _objKey.get(this._uuid);
        }
        return this._uuid;
    }

    public int getSCID() {
        return this._objKeyIntView.get(1);
    }

    public int getServerId() {
        return this._objKeyIntView.get(2);
    }

    public String getGenericServerName() {
        if (this._genericServerName == null) {
            byte[] gsnBytes = new byte[8];
            ByteBuffer _objKey = this._objKey.duplicate();
            _objKey.position(44);
            _objKey.get(gsnBytes);
            try {
                this._genericServerName = new String(gsnBytes, "Cp1047");
            }
            catch (UnsupportedEncodingException ex) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getGenericServerName could not convert to Cp1047 encoding", ex);
                }
                throw new RuntimeException(ex);
            }
        }
        return this._genericServerName;
    }

    public byte[] getContainerKey() {
        if (this._ckey == null) {
            this._ckey = new byte[this._objKeyIntView.get(28)];
            ByteBuffer _objKey = this._objKey.duplicate();
            _objKey.position(this._objKeyIntView.get(27) + 4);
            _objKey.get(this._ckey);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning container key", this._ckey);
        }
        return this._ckey;
    }

    public void setFlag(int flag) {
        int flags = this._objKeyIntView.get(13);
        if (flag == 0x100000 && ((flags |= flag) & 0x20000000) != 0 && localNoInternalWorkThreads) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "resetting ORBK_QUEUE_INTERNAL flag because object is direct and there are no internal-work threads");
            }
        } else {
            this._objKeyIntView.put(13, flags);
        }
    }

    public void resetFlag(int flag) {
        int flags = this._objKeyIntView.get(13);
        this._objKeyIntView.put(13, flags &= ~flag);
    }

    public boolean getFlag(int flag) {
        int flags = this._objKeyIntView.get(13);
        return (flags & flag) != 0;
    }

    public void addQueueByStokenData() {
        this.addQueueByStokenData(ORBEJSBridge.getStoken());
    }

    public void addQueueByStokenData(byte[] stoken) {
        this._stoken = stoken;
        if (stoken.length != 8) {
            throw new RuntimeException("Invalid stoken length: " + stoken.length);
        }
        ByteBuffer _objKey = this._objKey.duplicate();
        if (this.getFlag(0x200000)) {
            int compData_i = this._objKeyIntView.get(31);
            _objKey.position(compData_i + 4 + 8);
            _objKey.put(stoken);
        } else {
            this.setFlag(0x200000);
            this.resetFlag(Integer.MIN_VALUE);
            int compData_i = this._objKeyWithLen.getInt(0);
            this._objKeyIntView.put(31, compData_i);
            this._objKeyIntView.put(32, 20);
            _objKey.position(compData_i);
            _objKey.putInt(-488384814);
            _objKey.put(localIplTime);
            _objKey.put(this._stoken);
            this._objKeyWithLen.putInt(0, compData_i += 20);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "added queue_by_stoken data", this.getBytes());
        }
    }

    public void addQueueByApplenvData(String applenv) {
        this._applenv = applenv;
        this.setFlag(524288);
        int compData_i = this._objKeyWithLen.getInt(0);
        this._objKeyIntView.put(33, compData_i);
        this._objKeyIntView.put(34, this._applenv.length());
        ByteBuffer _objKey = this._objKey.duplicate();
        _objKey.position(compData_i);
        _objKey.putInt(-1042819117);
        try {
            _objKey.put(this._applenv.getBytes("Cp1047"));
        }
        catch (UnsupportedEncodingException ex) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getBytes(Cp1047) failed", ex);
            }
            throw new RuntimeException(ex);
        }
        this._objKeyWithLen.putInt(0, compData_i += 4 + (this._applenv.length() + 3) / 4 * 4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "added queue_by_applenv data", this.getBytes());
        }
    }

    public byte[] getBytes() {
        byte[] byteData = new byte[this.length()];
        ByteBuffer _objKey = this._objKey.duplicate();
        _objKey.position(0);
        _objKey.get(byteData);
        return byteData;
    }

    public int length() {
        if (this._objKeyWithLen != null) {
            return this._objKeyWithLen.getInt(0);
        }
        return this._objKey.limit();
    }

    public void write(CDROutputStream s) {
        s.write_octet_array(this.getBytes(), 0, this.length());
    }

    public String getClassName() {
        if (this._className == null) {
            byte[] classNameBytes = new byte[this._objKeyIntView.get(26) - 1];
            ByteBuffer _objKey = this._objKey.duplicate();
            _objKey.position(this._objKeyIntView.get(25) + 4);
            _objKey.get(classNameBytes);
            if (classNameBytes != null) {
                try {
                    this._className = new String(classNameBytes, "Cp1047");
                }
                catch (UnsupportedEncodingException uee) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "caught UnsupportedEncodingException", uee);
                    }
                    throw new RuntimeException(uee);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning className", this._className);
        }
        return this._className;
    }

    public byte[] getUserKey() {
        return this.getUserKeyBytes();
    }

    public byte[] getUserKeyBytes() {
        return this.getContainerKey();
    }

    public UserKey getUserKeyObject() {
        throw new NO_IMPLEMENT("Cannot instantiate UserKey object.  Use BOSSObjectKey.getUserKeyBytes()");
    }

    public byte[] getSecurityDomain() {
        if (this._securityDomain == null) {
            this._securityDomain = new byte[this._objKeyIntView.get(38)];
            ByteBuffer _objKey = this._objKey.duplicate();
            _objKey.position(this._objKeyIntView.get(37) + 4);
            _objKey.get(this._securityDomain);
        }
        return this._securityDomain;
    }

    public String getTypeId() {
        if (this._typeId == null) {
            byte[] typeIdBytes = new byte[this._objKeyIntView.get(24) - 1];
            ByteBuffer _objKey = this._objKey.duplicate();
            _objKey.position(this._objKeyIntView.get(23) + 4);
            _objKey.get(typeIdBytes);
            if (typeIdBytes != null) {
                try {
                    this._typeId = new String(typeIdBytes, "Cp1047");
                }
                catch (UnsupportedEncodingException uee) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "caught UnsupportedEncodingException", uee);
                    }
                    throw new RuntimeException(uee);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning typeId", this._typeId);
        }
        return this._typeId;
    }

    public boolean isLocalToJVM() {
        int localOrbType = ORBEJSBridge.getOrbType();
        boolean orbkCtlFlag = this.getFlag(Integer.MIN_VALUE);
        boolean isLocal = false;
        if (orbkCtlFlag && localOrbType == 1 || !orbkCtlFlag && (localOrbType == 2 || localOrbType == 5)) {
            isLocal = this.getFlag(0x20000000) ? Arrays.equals(this.getServerUUID(), localSpecificUuid) : Arrays.equals(this.getServerUUID(), localGenericUuid);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isLocalToJVM flags", new Object[]{"ORBK_CTL", new Boolean(this.getFlag(Integer.MIN_VALUE)), "ORBK_DIRECT_COM", new Boolean(this.getFlag(0x20000000))});
            Tr.debug(tc, "localGenericUuid", localGenericUuid);
            Tr.debug(tc, "localSpecificUuid", localSpecificUuid);
            Tr.debug(tc, "object key uuid", this.getServerUUID());
            Tr.debug(tc, "isLocalToJVM isLocal", new Boolean(isLocal));
        }
        return isLocal;
    }

    static {
        if (ORBEJSBridge.getOrbType() != 3) {
            localNoInternalWorkThreads = JAVAtoCPPUtilities.getNativeIntegerVariable((String)"private_bboo_internal_work_thread_pool_size", (int)3) == 0;
            localGenericUuid = ORBEJSBridge.getGenericUuid();
            localSpecificUuid = ORBEJSBridge.getSpecificUuid();
            localIplTime = ORBEJSBridge.getIplTime();
            try {
                localGenericServerNameBytes = ORBEJSBridge.getGenericServerName().getBytes("Cp1047");
            }
            catch (UnsupportedEncodingException ex) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getBytes(Cp1047) failed", ex);
                }
                throw new RuntimeException(ex);
            }
        } else {
            localNoInternalWorkThreads = true;
            localGenericUuid = null;
            localSpecificUuid = null;
            localIplTime = null;
            localGenericServerNameBytes = null;
        }
    }
}

