/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.xcf.groupservices;

import com.ibm.ws.xcf.groupservices.AnswerRecord;
import com.ibm.ws.xcf.groupservices.MemberInfoListener;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class XcfFascade {
    public static final int LIVE = 0;
    public static final int ALL = 1;
    public static final int GENOTDEF = 0;
    public static final int GECREATE = 2;
    public static final int GEACTIVE = 3;
    public static final int GEQUIESC = 4;
    public static final int GEFAILED = 5;
    public static final int IXCRETCODEOK = 0;
    public static final int IXCRETCODEWARNING = 4;
    public static final int IXCRETCODEPARMERROR = 8;
    public static final int IXCRETCODEENVERROR = 12;
    public static final int IXCRETCODECOMPERROR = 16;
    public static final int GEMSTATE = 1;
    public static final int GEUSTATE = 2;
    public static final int GEMSUMSE = 7;
    public static final int GEMSUMDI = 8;
    public static final int GEMNOSUM = 9;
    public static final int IXCJOINRSNFIRSTACTIVEMEMBER = 4;
    public static final String DLLNAME = "bboorb";

    public native long xcfJoin(String var1, byte[] var2, byte[] var3, int var4, int var5, MemberInfoListener var6);

    public native long xcfLeave(long var1);

    public native byte[] xcfQuery(String var1, int var2);

    public native long xcfSendMsgToMbr(long var1, long var3, String var5, int var6);

    public native long xcfSendMsgToOthers(long var1, String var3, int var4);

    public native ByteBuffer xcfGetStatusField();

    public native void setTraceLevel(int var1);

    public native boolean requestDump(int var1);

    public static int getGEPLTYPE(long rc) {
        long status = rc;
        int type = (int)(status >> 16);
        return type;
    }

    public static int getGEPMOLD(long rc) {
        long status = rc;
        int type = (int)(status >> 8 & 0xFFL);
        return type;
    }

    public static int getGEPMNEW(long rc) {
        long status = rc;
        int type = (int)(status & 0xFFL);
        return type;
    }

    public static int getActiveFromQueryStatus(int status) {
        int answer = status;
        return answer >> 8;
    }

    public static int getAdditionalInfoFromQueryStatus(int status) {
        int answer = status;
        return answer & 0xFF;
    }

    public static int getReason(long rc) {
        long status = rc;
        int reason = (int)(status & 0xFFL);
        return reason;
    }

    public static int getReturnCode(long rc) {
        long status = rc;
        int retCode = (int)(status >> 16);
        return retCode;
    }

    public static AnswerRecord convertByteBuffer2QueryAnswer(ByteBuffer answer) {
        int NAME_SIZE = 16;
        AnswerRecord queryReturnRecord = null;
        int numAnswers = answer.getInt();
        if (numAnswers > 0) {
            String[] queryAnswer = new String[numAnswers];
            int[] queryStatus = new int[numAnswers];
            byte[] rawData = new byte[16];
            for (int i = 0; i < queryAnswer.length; ++i) {
                answer.get(rawData);
                queryStatus[i] = answer.getShort();
                try {
                    for (int j = 0; j < rawData.length; ++j) {
                        if (rawData[j] != 0) continue;
                        queryAnswer[i] = new String(rawData, 0, j, "Cp1047");
                        break;
                    }
                    if (queryAnswer[i] != null) continue;
                    queryAnswer[i] = new String(rawData, "Cp1047");
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
            }
            queryReturnRecord = new AnswerRecord(queryAnswer, queryStatus);
        }
        return queryReturnRecord;
    }

    public static int convertStatus(int xcfStatus) {
        int active = XcfFascade.getActiveFromQueryStatus(xcfStatus);
        return active;
    }

    public static void main(String[] args) {
        long test1 = 66051L;
        long test2 = 262149L;
        int test3 = 768;
        int test4 = 784;
        if (args != null) {
            if (args.length > 1) {
                test1 = Integer.parseInt(args[1]);
            }
            if (args.length > 2) {
                test1 = Integer.parseInt(args[2]);
            }
        }
        int rc1 = XcfFascade.getGEPLTYPE(test1);
        int rc2 = XcfFascade.getGEPMNEW(test1);
        int rc3 = XcfFascade.getGEPMOLD(test1);
        int rc4 = XcfFascade.getReason(test2);
        int rc5 = XcfFascade.getReturnCode(test2);
        System.out.println("0x" + Long.toHexString(test1) + " type=" + rc1 + " old=" + rc3 + " new=" + rc2);
        System.out.println("0x" + Long.toHexString(test2) + " rc=" + rc5 + " reason=" + rc4);
        int answer1 = XcfFascade.convertStatus(test3);
        int answer2 = XcfFascade.convertStatus(test4);
        System.out.println("0x" + Long.toHexString(test3) + " new=" + answer1);
        System.out.println("0x" + Long.toHexString(test4) + " new=" + answer2);
    }
}

