/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.xcf.groupservices;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;

public class NameConverterZos {
    private static int _minSleep = 15000;
    private static int _randomSleep = 3000;
    private static boolean _continue = true;
    private static Random rand = new Random();
    public static final int GROUP = 0;
    public static final int MEMBER = 1;
    private static final String GROUP_PREFIX = "B";
    private final TypeObject group = new TypeObject(0, 7, "B");
    private final TypeObject member = new TypeObject(1, 16, "");
    private HashMap<String, String> groupNameMap = new HashMap();
    private HashMap<String, Map<String, String>> group2MemberMap = new HashMap();

    private NameConverterZos() {
    }

    public NameConverterZos(String groupName) {
        String prevObj;
        String shortGroupName = null;
        shortGroupName = groupName.length() <= 8 ? new String(groupName) : this.long2shortName(groupName, 0);
        if (shortGroupName == null || (prevObj = this.groupNameMap.put(shortGroupName, groupName)) != null) {
            // empty if block
        }
    }

    public void addDefined(String groupName, String[] definedSet) {
        Map<String, String> memberNameMap;
        String shortGroupName = this.long2shortName(groupName, 0);
        if (shortGroupName != null && !this.groupNameMap.containsKey(shortGroupName)) {
            this.groupNameMap.put(shortGroupName, groupName);
        }
        if ((memberNameMap = this.group2MemberMap.get(groupName)) == null) {
            memberNameMap = new HashMap<String, String>();
            this.group2MemberMap.put(groupName, memberNameMap);
        }
        for (int i = 0; i < definedSet.length; ++i) {
            String memberName = definedSet[i];
            String shortMemberName = this.long2shortName(memberName, 1);
            memberNameMap.put(shortMemberName, memberName);
        }
    }

    public void addJoinedMemberName(String groupName, String shortMemberName, String memberName) {
        this.removeSupercededMemberName(groupName, memberName);
        Map<String, String> memberNameMap = this.group2MemberMap.get(groupName);
        if (memberNameMap == null) {
            memberNameMap = new HashMap<String, String>();
        }
        memberNameMap.put(shortMemberName, memberName);
        this.group2MemberMap.put(groupName, memberNameMap);
    }

    public void removeTerminatedMemberName(String groupName, String shortMemberName) {
        Map<String, String> memberNameMap = this.group2MemberMap.get(groupName);
        if (memberNameMap != null) {
            memberNameMap.remove(shortMemberName);
        }
    }

    public void removeSupercededMemberName(String groupName, String longMemberName) {
        Map<String, String> memberNameMap = this.group2MemberMap.get(groupName);
        String key = "";
        String value = "";
        boolean removeOldMember = false;
        try {
            if (memberNameMap != null) {
                for (Map.Entry<String, String> entry : memberNameMap.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (!value.equals(longMemberName)) continue;
                    removeOldMember = true;
                    break;
                }
                if (removeOldMember) {
                    memberNameMap.remove(key);
                    this.group2MemberMap.put(groupName, memberNameMap);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String long2shortName(String longName, int type) {
        TypeObject tobj = this.getTypeObject(type);
        String shortName = this.map(longName, tobj.hashLength);
        shortName = tobj.prefix + shortName;
        return shortName;
    }

    public String getShortGroupName(String groupName) {
        return this.keyFromValue(this.groupNameMap, groupName);
    }

    public String getLongGroupName(String shortGroupName) {
        String longGroupName = this.groupNameMap.get(shortGroupName);
        if (longGroupName == null) {
            longGroupName = "";
        }
        return longGroupName;
    }

    public String getShortMemberName(String longGroupName, String longMemberName) {
        Map<String, String> memberNameMap = this.group2MemberMap.get(longGroupName);
        if (memberNameMap == null) {
            throw new RuntimeException("cant find map for  group= " + longGroupName);
        }
        return this.keyFromValue(memberNameMap, longMemberName);
    }

    private String map(String longName, int length) {
        int hashLength = length;
        String key = longName;
        System.out.println("|" + key + "|");
        byte[] hashValue = NameConverterZos.hash(key, hashLength);
        char[] charValue = new char[hashLength];
        for (int i = 0; i < hashLength; ++i) {
            int myChar = hashValue[i] - -128;
            int myCharIndex = myChar % 36;
            charValue[i] = (char)(48 + myCharIndex);
            if (charValue[i] < ':') continue;
            charValue[i] = (char)(65 + (myCharIndex - 10));
        }
        String shortName = new String(charValue);
        System.out.println("|" + shortName + "|");
        return shortName;
    }

    private static byte[] hash(String input, int hashLength) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        messageDigest.update(input.getBytes());
        byte[] raw = messageDigest.digest();
        if (raw.length < hashLength) {
            // empty if block
        }
        byte[] hashName = new byte[hashLength];
        System.arraycopy(raw, 0, hashName, 0, hashLength);
        return hashName;
    }

    TypeObject getTypeObject(int type) {
        TypeObject tobj = null;
        switch (type) {
            case 0: {
                tobj = this.group;
                break;
            }
            case 1: {
                tobj = this.member;
                break;
            }
        }
        return tobj;
    }

    private String keyFromValue(Map myMap, String valueKey) {
        for (Map.Entry entry : myMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!valueKey.equals(value)) continue;
            return (String)key;
        }
        return null;
    }

    public String[] long2shortName(String[] names) {
        String[] snames = new String[2];
        snames[0] = this.keyFromValue(this.groupNameMap, names[0]);
        Map<String, String> memberNameMap = this.group2MemberMap.get(names[0]);
        snames[1] = this.keyFromValue(memberNameMap, names[1]);
        return snames;
    }

    public String short2longName(String longGroupName, String shortMemberName) {
        Map<String, String> memberNameMap = this.group2MemberMap.get(longGroupName);
        if (memberNameMap == null) {
            throw new RuntimeException("cant find map for  group= " + longGroupName);
        }
        String longName = memberNameMap.get(shortMemberName);
        if (longName == null) {
            longName = "";
            memberNameMap.put(shortMemberName, longName);
            this.group2MemberMap.put(longGroupName, memberNameMap);
        }
        return longName;
    }

    public static void main(String[] args) throws IOException {
        try {
            NameConverterZos nameConverter = new NameConverterZos();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String str = "";
            while (str != null) {
                System.out.println("> prompt");
                str = in.readLine();
                if (nameConverter.process(str)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean process(String str) {
        StringTokenizer st = new StringTokenizer(str, " ");
        boolean result = true;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf("add") >= 0) {
                String groupName = st.nextToken();
                int numMembers = Integer.parseInt(st.nextToken());
                String[] members = new String[numMembers];
                for (int i = 0; i < members.length; ++i) {
                    members[i] = st.nextToken();
                }
                this.addDefined(groupName, members);
                break;
            }
            if (t.indexOf("remove") >= 0) break;
            if (t.indexOf("S2L") >= 0) {
                String answer = this.short2longName(st.nextToken(), st.nextToken());
                if (answer == null) {
                    answer = "null";
                }
                System.out.println("longName= " + answer);
                break;
            }
            if (t.indexOf("L2S") >= 0) {
                String[] names = new String[]{st.nextToken(), st.nextToken()};
                String[] answers = this.long2shortName(names);
                System.out.println("shortGroupName= " + answers[0] + " shortMemberName= " + answers[1]);
                break;
            }
            if (t.indexOf("stop") >= 0) {
                result = false;
                break;
            }
            System.out.println("NameConverter command");
            System.out.println("Commands are:");
            System.out.println("add groupName numMembers memberName1 memberName2 memberName3 ...");
            System.out.println("remove groupName, memberName");
            System.out.println("S2L longGroupname, shortMemberName");
            System.out.println("L2S longGroupname, longMemberName");
            System.out.println("stop");
        }
        return result;
    }

    protected static void SleepBetweenActions() throws InterruptedException {
        int s = _minSleep + rand.nextInt(_randomSleep);
        if (_continue) {
            System.out.println("sleep between actions");
        }
        NameConverterZos.SleepBetweenActions(s);
    }

    protected static void SleepBetweenActions(int s) throws InterruptedException {
        Thread.sleep(s);
    }

    class TypeObject {
        final int hashLength;
        final int type;
        final String prefix;

        TypeObject(int type, int hashLength, String prefix) {
            this.type = type;
            this.hashLength = hashLength;
            this.prefix = prefix;
        }
    }
}

