/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityContext;
import com.ibm.ws.activity.ContextExtractor;
import com.ibm.ws.activity.coordination.WSCoorCoordinatorProxy;
import com.ibm.ws.cscope.CScopePGMgr;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.tx.WSTXVersion;
import com.ibm.ws.util.Base64;
import com.ibm.ws.wsba.WSBACoordinatorProxy;
import com.ibm.ws.wsba.ns0410.WSBA10Constants;
import com.ibm.ws.wsba.ns0606.WSBA11Constants;
import com.ibm.ws.wsba.ns0606.WSBA11CoordinatorProxy;
import com.ibm.ws.wsba.systemapp.WSBAServiceHelper;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.RegisterResponseOperationHandler;
import com.ibm.ws.wscoor.WSCoorConstants;
import com.ibm.ws.wstx.Axis2CoordinationContext;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;

public class Axis2WSBAContextExtractor
implements ContextExtractor {
    private static final TraceComponent tc = Tr.register(Axis2WSBAContextExtractor.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final List<QName> EXTENSIBILITY_ELEMENTS_LIST;

    public ActivityContext extractContext(Object message) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{message, this});
        }
        ActivityContext activityContext = null;
        if (message instanceof MessageContext) {
            try {
                SOAPHeader sh = ((MessageContext)message).getEnvelope().getHeader();
                if (sh != null) {
                    Axis2CoordinationContext coordinationContext = Axis2CoordinationContext.extractFromSOAPHeader(sh, CScopePGMgr.getSupportedCoordinationTypes(), EXTENSIBILITY_ELEMENTS_LIST);
                    activityContext = this.coordinationContextToActivityContext(coordinationContext);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsba.WSBAContextExtractor.extractContext", "60", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractContext", "CScopeSystemException");
                }
                throw new CScopeSystemException((Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", activityContext);
        }
        return activityContext;
    }

    private ActivityContext coordinationContextToActivityContext(CoordinationContext coordinationContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "coordinationContextToActivityContext", new Object[]{coordinationContext, this});
        }
        ActivityContext activityContext = null;
        if (coordinationContext != null) {
            boolean twoWayEnabled;
            String encodedUOWIdentifier;
            String identifier = coordinationContext.getIdentifier().getURI().toString();
            int wstxVersion = WSTXVersion.getWSTXVersionFromWSTXCoordinationType((String)coordinationContext.getCoordinationType().toString());
            EndpointReference participantProtocolService = null;
            if (wstxVersion == 0) {
                participantProtocolService = EndpointReferenceManager.createEndpointReference(WSBAServiceHelper.getWSBA10BusinessAgreementWithParticipantCompletionParticipantURI());
                participantProtocolService.setNamespace("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            } else {
                participantProtocolService = EndpointReferenceManager.createEndpointReference(WSBAServiceHelper.getWSBA11BusinessAgreementWithParticipantCompletionParticipantURI());
                participantProtocolService.setNamespace("http://www.w3.org/2005/08/addressing");
            }
            WSBAServiceHelper.pinEPRToServer((EndpointReference)participantProtocolService);
            if (wstxVersion == 0) {
                participantProtocolService.setReferenceParameter(WSBA10Constants.CONTEXT_ID_ELEMENT_QNAME, identifier);
                encodedUOWIdentifier = coordinationContext.getExtensibilityElement(WSBA10Constants.UOW_IDENTIFIER_NAME);
                twoWayEnabled = coordinationContext.getExtensibilityElement(WSBA10Constants.TWO_WAY_ENABLED_NAME) != null && WSCoorConstants.SUPPORT_TWO_WAY;
            } else {
                participantProtocolService.setReferenceParameter(WSBA11Constants.CONTEXT_ID_ELEMENT_QNAME, identifier);
                encodedUOWIdentifier = coordinationContext.getExtensibilityElement(WSBA11Constants.UOW_IDENTIFIER_NAME);
                twoWayEnabled = coordinationContext.getExtensibilityElement(WSBA11Constants.TWO_WAY_ENABLED_NAME) != null && WSCoorConstants.SUPPORT_TWO_WAY;
            }
            Serializable uowIdentifier = null;
            if (encodedUOWIdentifier != null && !encodedUOWIdentifier.equals("")) {
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(encodedUOWIdentifier));
                ObjectInputStream ois = new ObjectInputStream(bais);
                uowIdentifier = (Serializable)ois.readObject();
            }
            HashMap<String, Serializable> pgcMap = new HashMap<String, Serializable>();
            pgcMap.put("uowIdentifier", uowIdentifier);
            pgcMap.put("registrationService", coordinationContext.getRegistrationService());
            Object wsbaCoordinatorProxy = null;
            wsbaCoordinatorProxy = wstxVersion == 0 ? new WSBACoordinatorProxy(participantProtocolService, WSBA10Constants.PARTICIPANT_COMPLETION_PROTOCOL_URI, identifier, twoWayEnabled) : new WSBA11CoordinatorProxy(participantProtocolService, WSBA11Constants.PARTICIPANT_COMPLETION_PROTOCOL_URI, identifier, twoWayEnabled);
            activityContext = new ActivityContext(identifier, "com.ibm.ws.cscope", "com.ibm.ws.cscope", coordinationContext.getExpires(), new PropertyGroupContext("CScope", pgcMap), (WSCoorCoordinatorProxy)wsbaCoordinatorProxy, coordinationContext.getRegistrationService(), (RegisterResponseOperationHandler)wsbaCoordinatorProxy, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "coordinationContextToActivityContext", activityContext);
        }
        return activityContext;
    }

    public ActivityContext extractContext(Map data, String key) {
        ActivityContext activityContext;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "extractContext", new Object[]{data, key, this});
            }
            activityContext = null;
            try {
                CoordinationContext coordinationContext = CoordinationContext.extractFromSystemContextMap((Map)data, (String)key, (String)CScopePGMgr.COORDINATION_TYPE.toString());
                activityContext = this.coordinationContextToActivityContext(coordinationContext);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsba.WSBAContextExtractor.extractContext", "161", this);
                if (!tc.isEntryEnabled()) break block4;
                Tr.exit(tc, "extractContext", "CScopeSystemException");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", activityContext);
        }
        return activityContext;
    }

    static {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        EXTENSIBILITY_ELEMENTS_LIST = new ArrayList<QName>();
        EXTENSIBILITY_ELEMENTS_LIST.add(WSBA10Constants.UOW_IDENTIFIER_NAME);
        EXTENSIBILITY_ELEMENTS_LIST.add(WSBA11Constants.UOW_IDENTIFIER_NAME);
        EXTENSIBILITY_ELEMENTS_LIST.add(WSBA10Constants.TWO_WAY_ENABLED_NAME);
        EXTENSIBILITY_ELEMENTS_LIST.add(WSBA11Constants.TWO_WAY_ENABLED_NAME);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }
}

