/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTXPolicyTypeProvider
implements PolicyTypeProvider {
    private static final TraceComponent tc = Tr.register(WSTXPolicyTypeProvider.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static HashSet<String> validNames = new HashSet();
    private static HashSet<String> validValues = new HashSet();

    private boolean validateAttributes(Properties p) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAttributes", new Object[]{p, this});
        }
        if (p == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "validateAttributes", Boolean.FALSE);
            }
            return false;
        }
        for (String name : p.stringPropertyNames()) {
            if (!validNames.contains(name)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateAttributes", Boolean.FALSE);
                }
                return false;
            }
            if (validValues.contains(p.getProperty(name))) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "validateAttributes", Boolean.FALSE);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAttributes", Boolean.TRUE);
        }
        return true;
    }

    @Override
    public Properties getBinding(String bindingFileName, Properties attributes, Map context) throws Exception {
        return null;
    }

    @Override
    public boolean setBinding(String bindingFileName, Properties attributes, boolean replace, Map context) throws Exception {
        return false;
    }

    @Override
    public boolean setAttributes(String policyFileName, Properties attributes, boolean replace, Map context) throws Exception {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{policyFileName, attributes, replace, context, this});
        }
        if (!this.validateAttributes(attributes)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setAttributes", Boolean.FALSE);
            }
            return false;
        }
        if (replace) {
            result = WSTXPolicyTypeFileHelper.writePolicyType(policyFileName, attributes);
        } else {
            Properties old = WSTXPolicyTypeFileHelper.readPolicyType(policyFileName);
            for (String key : attributes.stringPropertyNames()) {
                old.setProperty(key, attributes.getProperty(key));
            }
            result = WSTXPolicyTypeFileHelper.writePolicyType(policyFileName, old);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", result);
        }
        return result;
    }

    @Override
    public Properties getAttributes(String policyFileName, Properties attributes, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{policyFileName, attributes, context, this});
        }
        Properties old = WSTXPolicyTypeFileHelper.readPolicyType(policyFileName);
        if (attributes == null || attributes.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttributes", old);
            }
            return old;
        }
        for (String key : old.stringPropertyNames()) {
            if (attributes.getProperty(key) != null) continue;
            old.remove(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", old);
        }
        return old;
    }

    @Override
    public String getType() {
        return "WSTransaction";
    }

    @Override
    public boolean validate(String policySetFileName, String policyFileName, Session session, Map context) throws Exception {
        return true;
    }

    @Override
    public InputStream downgradeBinding(InputStream bindingFileStream, Map<String, String> context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "downgradeBinding", new Object[]{bindingFileStream, context, this});
        }
        return bindingFileStream;
    }

    @Override
    public InputStream downgradePolicy(InputStream policyFileStream, Map<String, String> context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "downgradePolicy", new Object[]{policyFileStream, context, this});
        }
        return policyFileStream;
    }

    @Override
    public boolean mergeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "mergeBinding", new Object[]{oldBindingFilePath, newBindingFilePath, this});
        }
        return true;
    }

    @Override
    public boolean upgradeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "upgradeBinding", new Object[]{oldBindingFilePath, newBindingFilePath, this});
        }
        return true;
    }

    @Override
    public boolean upgradePolicy(String oldPolicyFilePath, String newPolicyFilePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "upgradePolicy", new Object[]{oldPolicyFilePath, newPolicyFilePath, this});
        }
        return true;
    }

    @Override
    public boolean mergeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindigFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "mergeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindigFile, this});
        }
        return true;
    }

    @Override
    public boolean upgradeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "upgradeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile, this});
        }
        return true;
    }

    @Override
    public boolean upgradePolicy(InputStream oldPolicyFile, InputStream newPolicyFile, OutputStream resultPolicyFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "upgradePolicy", new Object[]{oldPolicyFile, newPolicyFile, resultPolicyFile, this});
        }
        return true;
    }

    static {
        validNames.add("ATAssertion");
        validNames.add("BAAtomicOutcomeAssertion");
        validValues.add("mandatory");
        validValues.add("supports");
        validValues.add("never");
    }
}

