/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseHelper;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseTarget;
import com.ibm.ws.Transaction.wstx.WSATAsyncResource;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATCoordinatorPortDistImpl;
import com.ibm.ws.Transaction.wstx.WSATParticipantWrapper;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.tx.WSTXVersion;
import com.ibm.ws.tx.config.WASConfigurationProvider;
import com.ibm.ws.tx.jta.TranManagerSet;
import com.ibm.ws.tx.jta.TransactionImpl;
import com.ibm.ws.tx.jta.XidImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorHelper;
import com.ibm.ws.wstx.Axis2CoordinationContext;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSATGenerator {
    private static final TraceComponent tc = Tr.register(WSATGenerator.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int envType;
    private static final Integer nonPersistentDeliveryMode;
    private static WSThreadLocal<Object> _txEstablishedBySystemContextHandler;
    public static final Object NO_TX_ESTABLISHED;
    private static final boolean _isZOS;

    public static boolean handleOutbound(MessageContext mc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", mc);
        }
        WSATControlSet.clearTransactionAssociation();
        Properties ptc = WSTXHelper.getPolicyTypeConfig(mc, true);
        String policy = ptc.getProperty("ATAssertion", "never");
        Object object = WSATGenerator.getTxEstablishedBySystemContextHandler();
        if (object != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemContextHandler driven prior to global handler");
            }
            if (object instanceof TransactionImpl) {
                TransactionImpl txEstablishedBySystemContextHandler = (TransactionImpl)object;
                if (!txEstablishedBySystemContextHandler.equals((Object)((TranManagerSet)TranManagerSet.instance()).getTransactionImpl())) {
                    AxisFault af = new AxisFault("Tx established by SystemContextHandler is no longer on the thread");
                    if (TraceComponent.isAnyTracingEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Tx established by SystemContextHandler is no longer on the thread");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleOutbound", af);
                        }
                    }
                    throw af;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SystemContextHandler was invoked and did not import a transaction.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleOutbound", Boolean.TRUE);
                    }
                }
                return true;
            }
        }
        if (!"never".equals(policy)) {
            try {
                String wsatNamespace = ptc.getProperty("WSATNS");
                int wstxVersion = wsatNamespace != null ? WSTXVersion.getWSTXVersionFromWSATNS((String)wsatNamespace) : ((WASConfigurationProvider)ConfigurationProviderManager.getConfigurationProvider()).getDefaultWSTXSpecLevel();
                CoordinationContext cc = WSATControlSet.getCoordinationContextForCurrentTx((int)wstxVersion, null, (boolean)WSATControlSet.isDeferredRegistrationEnabled());
                if (cc != null) {
                    if (ServiceHelper.getInitFailed()) {
                        throw new AxisFault("WSAT Initialisation has failed, cannot process request");
                    }
                    if (WSTXHelper.isAsync(mc)) {
                        throw new AxisFault("WSAT is not supported on async requests");
                    }
                    String mep = mc.getAxisOperation().getMessageExchangePattern();
                    if (!("http://www.w3.org/2004/08/wsdl/out-in".equals(mep) || "http://www.w3.org/2006/01/wsdl/out-in".equals(mep) || "http://www.w3.org/ns/wsdl/out-in".equals(mep))) {
                        throw new AxisFault("Unsupported MEP: " + mep);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding CoordinationContext to SOAPHeader");
                    }
                    SOAPHeader sh = WSTXHelper.getSOAPHeader(mc);
                    Axis2CoordinationContext wcc = new Axis2CoordinationContext(cc);
                    wcc.insertIntoSOAPHeader(wstxVersion, sh);
                    HashMap contextMap = new HashMap();
                    WSCoorHelper.addAffinityToMap((String)cc.getIdentifier().toString(), contextMap);
                    mc.setProperty("com.ibm.ws.webservices.wlmselectioncriteria", contextMap);
                    mc.setProperty("deliveryMode", nonPersistentDeliveryMode);
                    WSATControlSet.suspendCurrentTransactionAssociation();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No CoordinationContext found");
                    }
                    if ("mandatory".equals(policy)) {
                        throw new AxisFault(nls.getString("WTRN0127_BLOCKED_BY_POLICY_ASSERTION"));
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.wstx.handler.WSATGenerator.handleOutbound", "208");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", t);
                }
                throw AxisFault.makeFault(new Exception(t));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
        }
        return true;
    }

    public static boolean handleInbound(MessageContext mc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInbound", mc);
        }
        if (WSTXHelper.DISABLED || envType != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleInbound", Boolean.TRUE);
            }
            return true;
        }
        TransactionImpl txImpl = WSATControlSet.resumeSuspendedTransactionAssociation();
        if (txImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleInbound", Boolean.TRUE);
            }
            return true;
        }
        WSATGenerator.processResponse(mc, txImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInbound", Boolean.TRUE);
        }
        return true;
    }

    protected static void setTxEstablishedBySystemContextHandler(Object tx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTxEstablishedBySystemContextHandler", tx);
        }
        _txEstablishedBySystemContextHandler.set(tx);
    }

    protected static Object getTxEstablishedBySystemContextHandler() {
        Object o = _txEstablishedBySystemContextHandler.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTxEstablishedBySystemContextHandler", o);
        }
        return o;
    }

    private static void processResponse(MessageContext mc, TransactionImpl txImpl) throws AxisFault {
        String txID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processResponse", new Object[]{mc, txImpl});
        }
        SOAPEnvelope se = null;
        EndpointReference participantEPR = null;
        if (mc != null && (se = mc.getEnvelope()) != null) {
            SOAPHeader sh;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP Envelope", se);
            }
            if ((sh = se.getHeader()) != null) {
                Iterator headerBlocks = sh.getChildElements();
                while (headerBlocks.hasNext()) {
                    SOAPHeaderBlock shb = (SOAPHeaderBlock)headerBlocks.next();
                    if (!"ParticipantRegistration".equals(shb.getLocalName())) continue;
                    try {
                        participantEPR = EndpointReferenceConverter.createEndpointReferenceFromOMElement(shb.getFirstElement());
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "292");
                    }
                    if (participantEPR == null) continue;
                    shb.detach();
                    break;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP header was null");
            }
        }
        if (se == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", "No envelope in response");
            }
            return;
        }
        if (participantEPR == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "processResponse", "No participant EPR");
            }
            SOAPFault sf = null;
            try {
                sf = se.getBody().getFault();
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "302");
            }
            if (sf == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "processResponse", "No fault in response");
                }
                return;
            }
            if (sf.getDetail() == null) {
                txImpl.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", "No participant EPR in response");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "participant EPR", participantEPR);
        }
        if ((txID = participantEPR.getReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME)) == null) {
            throw new AxisFault("No txID in participant EPR");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "txID", txID);
        }
        try {
            int wsatVersion = WSTXVersion.getWSTXVersionFromWSANS((String)participantEPR.getNamespace());
            String bqualIndex = null;
            if (_isZOS) {
                bqualIndex = "" + ((XidImpl)txImpl.getXidImpl()).getBqualBranchIndex();
            }
            EndpointReference cps = WSATControlSet.createCoordinatorEPR(null, (String)txID, (String)participantEPR.getAddress().getURI().toString(), bqualIndex, (int)wsatVersion, (boolean)true);
            WSATAsyncResource res = new WSATAsyncResource(participantEPR, cps, txID, bqualIndex);
            WSATParticipantWrapper wrapper = new WSATParticipantWrapper(res);
            txImpl.enlistAsyncResource(wrapper);
            if (!_isZOS) {
                JTAAsyncResponseHelper arh = WSATCoordinatorPortDistImpl.getJTAAsyncResponseHelper();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "AsyncResponseHelper", arh);
                }
                arh.addResponseTarget((JTAAsyncResponseTarget)wrapper);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "337");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", e);
            }
            throw AxisFault.makeFault(e);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.wstx.handler.WSATGenerator.processResponse", "339");
            AxisFault af = new AxisFault("Error processing deferred registration in response", t);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", af);
            }
            throw af;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processResponse");
        }
    }

    static {
        _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        envType = EnvironmentType.getEnvironmentType();
        nonPersistentDeliveryMode = new Integer(1);
        _txEstablishedBySystemContextHandler = new WSThreadLocal();
        NO_TX_ESTABLISHED = new Object();
        if (envType == 0) {
            WSATServices.initialize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }
}

