/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.Util;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.Transaction.wstx.WSATVersion;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.config.WASConfigurationProvider;
import com.ibm.ws.tx.jta.TranManagerSet;
import com.ibm.ws.tx.jta.TransactionImpl;
import com.ibm.ws.tx.jta.XidImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wstx.Axis2CoordinationContext;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws390.tx.TransactionManagerMessage;
import com.ibm.ws390.tx.WSATJMSSystemContextHandler;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.InvalidTransactionException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSATConsumer {
    private static final TraceComponent tc = Tr.register(WSATConsumer.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final OMNamespace ibmns = OMAbstractFactory.getOMFactory().createOMNamespace("http://wstx.Transaction.ws.ibm.com/extension", "websphere-wsat");
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();

    public static boolean establishContext(MessageContext mc) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContext", mc);
        }
        for (String coordinationType : WSATVersion.getSupportedCoordinationTypes()) {
            CoordinationContext cc = (CoordinationContext)mc.getProperty(coordinationType);
            if (cc == null) continue;
            try {
                WSATControlSet.setImportedTran(null);
                int branchIndex = 0;
                byte[] nativeXID = null;
                if (isZOS) {
                    String transportName = mc.getIncomingTransportName();
                    if ("http".equals(transportName)) {
                        XidImpl xid;
                        HttpServletRequest servletRequest = (HttpServletRequest)mc.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                        if (servletRequest == null) {
                            throw new Exception("No servlet request with xid data, cannot process request");
                        }
                        String tmmString = servletRequest.getHeader(HttpConstants.HDR_ZOS_TRAN_XID.getName());
                        if (tmmString != null) {
                            TransactionManagerMessage tmm = new TransactionManagerMessage(Util.byteArray(tmmString));
                            xid = tmm.getXid();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got transaction xid from message context", xid);
                            }
                        } else {
                            throw new Exception("No xid data in servlet request, cannot process request");
                        }
                        branchIndex = xid.getBqualBranchIndex();
                        nativeXID = xid.toBytes();
                        WSATConsumer.checkForTran();
                    } else if ("jms".equals(transportName)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got messsage from JMS so need xid from sys ctx handler");
                        }
                        if ((branchIndex = WSATJMSSystemContextHandler.getBranchIndex()) < 0) {
                            throw new Exception("No xid data in jms system context, cannot process request");
                        }
                        WSATConsumer.checkForTran();
                    }
                }
                WSATControlSet.establishCoordinationContext((CoordinationContext)cc, nativeXID, (int)branchIndex);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.wstx.handler.WSATConsumer.establishContext", "117");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "establishContext", e);
            }
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", Boolean.TRUE);
        }
        return true;
    }

    public static boolean handleOutbound(MessageContext inboundContext, MessageContext outboundContext) throws Exception {
        UOWCoordinator initialUOW;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", new Object[]{inboundContext, outboundContext});
        }
        if ((initialUOW = WSATControlSet.getinitialUOW()) != null && initialUOW.isGlobal()) {
            TranManagerSet tranManager;
            TransactionImpl tx;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the global tran ctx stored earlier; proceeding with local invocation handler behaviour");
            }
            if ((tx = (tranManager = (TranManagerSet)TranManagerSet.instance()).getTransactionImpl()) != null) {
                tx.suspendAssociation();
            }
        } else {
            TransactionImpl tx;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the local tran ctx stored earlier; proceeding with remote invocation handler behaviour");
            }
            try {
                tx = WSATControlSet.cleanupThreadContext();
            }
            catch (InvalidTransactionException e1) {
                AxisFault af = new AxisFault("No WSATRecoveryCoordinator");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", af);
                }
                throw af;
            }
            if (tx == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "No transaction returned from cleanupThreadContext()");
                }
                return true;
            }
            WSATRecoveryCoordinator wsatRC = tx.getWSATRecoveryCoordinator();
            if (wsatRC == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "No WSATRecoveryCoordinator as the transaction was not imported");
                }
                return true;
            }
            boolean deferRegistration = wsatRC.isDeferRegistration();
            if (!deferRegistration && !isZOS) {
                int secondsToWait = ((WASConfigurationProvider)ConfigurationProviderManager.getConfigurationProvider()).getAsyncResponseTimeout() / 1000;
                while (wsatRC.getSuperiorCoordinator() == null && secondsToWait-- > 0) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for register response");
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Sleep was interrupted", e);
                    }
                }
            }
            if (tx.getWSATRecoveryCoordinator().isRegisterSent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "Already sent registration EPR");
                }
                return true;
            }
            if (!deferRegistration) {
                if (!isZOS && wsatRC.getSuperiorCoordinator() == null) {
                    AxisFault af = new AxisFault("No WSATRecoveryCoordinator");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleOutbound", af);
                    }
                    throw af;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", "Got superior coordinator on another thread");
                }
                return true;
            }
            if (WSATControlSet.needToRegister()) {
                EndpointReference participantEPR = wsatRC.getParticipantEPR();
                inboundContext.setProperty(WSTXHelper.PARTICIPANT_EPR, participantEPR);
                tx.getWSATRecoveryCoordinator().setRegisterSent();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No need to register");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
        }
        return true;
    }

    private static void checkForTran() throws Exception {
        TranManagerSet tranManager = (TranManagerSet)TransactionManagerFactory.getTransactionManager();
        TransactionImpl tx = tranManager.getTransactionImpl();
        if (tx != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got transaction on thread", tx);
            }
            throw new Exception("Transaction already on thread");
        }
    }

    public static CoordinationContext extractContext(MessageContext mc, Properties ptc) throws AxisFault {
        String policy;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{mc, ptc});
        }
        if ((policy = ptc.getProperty("ATAssertion")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "extractContext", null);
            }
            return null;
        }
        SOAPHeader sh = mc.getEnvelope().getHeader();
        Axis2CoordinationContext cc = null;
        if (sh != null) {
            cc = Axis2CoordinationContext.extractFromSOAPHeader(sh, WSATVersion.getSupportedCoordinationTypes(), null);
        }
        if (cc == null && "mandatory".equals(policy) || cc != null && "never".equals(policy)) {
            AxisFault af = new AxisFault(nls.getString("WTRN0127_BLOCKED_BY_POLICY_ASSERTION"));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "extractContext", af);
            }
            throw af;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", (Object)cc);
        }
        return cc;
    }

    public static void cacheContext(MessageContext mc, CoordinationContext cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheContext", new Object[]{mc, cc});
        }
        if (cc != null) {
            mc.setProperty(cc.getCoordinationType().toString(), cc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheContext");
        }
    }
}

