/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsba.WSBAParticipantProxy;
import com.ibm.ws.wsba.ns0410.WSBA10Constants;
import com.ibm.ws.wsba.systemapp.WSBAServiceHelper;
import com.ibm.ws.wscoor.WSCoorConstants;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;

public class WSBAActivityHandlerCollaborator
extends com.ibm.ws.wsba.WSBAActivityHandlerCollaborator {
    private static final TraceComponent tc = Tr.register(WSBAActivityHandlerCollaborator.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");

    public static void outboundRequest(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "outboundRequest", new Object[]{messageContext});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "outboundRequest");
        }
    }

    public static void inboundRequest(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "inboundRequest", new Object[]{messageContext});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "inboundRequest");
        }
    }

    public static void inboundResponse(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "inboundResponse", new Object[]{messageContext});
        }
        if (messageContext != null) {
            try {
                SOAPHeader header;
                SOAPEnvelope envelope = messageContext.getEnvelope();
                if (envelope != null && (header = envelope.getHeader()) != null) {
                    Iterator headerBlocks = header.getChildElements();
                    while (headerBlocks.hasNext()) {
                        WSBAParticipantProxy proxy;
                        OMElement nextElement;
                        Iterator childElements;
                        String participantId;
                        String contextId;
                        SOAPHeaderBlock hb = (SOAPHeaderBlock)headerBlocks.next();
                        if (WSBA10Constants.DEFER_COMPLETED_NAME.getLocalName().equals(hb.getLocalName())) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found defer completion in response");
                            }
                            contextId = null;
                            participantId = null;
                            childElements = hb.getChildElements();
                            while (childElements.hasNext()) {
                                nextElement = (OMElement)childElements.next();
                                if (WSCoorConstants.CONTEXT_ID_ELEMENT_NAME.getLocalName().equals(nextElement.getLocalName())) {
                                    contextId = nextElement.getText();
                                    continue;
                                }
                                if (WSCoorConstants.INSTANCE_ID_ELEMENT_NAME.getLocalName().equals(nextElement.getLocalName())) {
                                    participantId = nextElement.getText();
                                    continue;
                                }
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Child element not recognised, " + nextElement.getLocalName());
                            }
                            if (contextId == null || participantId == null) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Could not extract values for both the contextId: " + contextId + " and the participantId: " + participantId);
                                continue;
                            }
                            proxy = WSBAServiceHelper.getParticipantProxy(participantId);
                            if (proxy == null) continue;
                            proxy.protocolMessageReceived(1, null);
                            continue;
                        }
                        if (!WSBA10Constants.DEFER_EXIT_NAME.getLocalName().equals(hb.getLocalName())) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found defer exit in response");
                        }
                        contextId = null;
                        participantId = null;
                        childElements = hb.getChildElements();
                        while (childElements.hasNext()) {
                            nextElement = (OMElement)childElements.next();
                            if (WSCoorConstants.CONTEXT_ID_ELEMENT_NAME.getLocalName().equals(nextElement.getLocalName())) {
                                contextId = nextElement.getText();
                                continue;
                            }
                            if (WSCoorConstants.INSTANCE_ID_ELEMENT_NAME.getLocalName().equals(nextElement.getLocalName())) {
                                participantId = nextElement.getText();
                                continue;
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Child element not recognised, " + nextElement.getLocalName());
                        }
                        if (contextId == null || participantId == null) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Could not extract both the contextId: " + contextId + "and the participantId: " + participantId);
                            continue;
                        }
                        proxy = WSBAServiceHelper.getParticipantProxy(participantId);
                        if (proxy == null) continue;
                        proxy.protocolMessageReceived(0, null);
                    }
                }
            }
            catch (RemoteException re) {
                FFDCFilter.processException(re, "com.ibm.ws.wsba.WSBAActivityHandlerCollaborator.inboundResponse", "120");
                JAXRPCException jaxrpce = new JAXRPCException(re);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "inboundResponse", jaxrpce);
                }
                throw jaxrpce;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "inboundResponse");
        }
    }

    public static void outboundResponse(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "outboundResponse", new Object[]{messageContext});
        }
        Integer action = (Integer)_deferedCompleted.get();
        _deferedCompleted.remove();
        if (action != null) {
            SOAPHeader header;
            String contextId = (String)_contextId.get();
            _contextId.remove();
            String participantId = (String)_participantId.get();
            _participantId.remove();
            if (action == 0) {
                SOAPHeader header2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "contextId = " + contextId + "; participantId = " + participantId);
                }
                if ((header2 = messageContext.getEnvelope().getHeader()) != null) {
                    OMFactory omFactory = header2.getOMFactory();
                    SOAPHeaderBlock shb = header2.addHeaderBlock(WSBA10Constants.DEFER_COMPLETED_NAME.getLocalName(), OMAbstractFactory.getOMFactory().createOMNamespace("http://www.ibm.com/ws-tx/wsba/ext", "websphere-wsba"));
                    OMElement contextElement = omFactory.createOMElement(new QName("http://www.ibm.com/ws-tx/wsba/ext", WSCoorConstants.CONTEXT_ID_ELEMENT_NAME.getLocalName(), "websphere-wsba"), shb);
                    OMElement participantElement = omFactory.createOMElement(new QName("http://www.ibm.com/ws-tx/wsba/ext", WSCoorConstants.INSTANCE_ID_ELEMENT_NAME.getLocalName(), "websphere-wsba"), shb);
                    OMText contextText = omFactory.createOMText((OMContainer)contextElement, contextId);
                    OMText participantText = omFactory.createOMText((OMContainer)participantElement, participantId);
                    contextElement.addChild(contextText);
                    participantElement.addChild(participantText);
                    shb.addChild(contextElement);
                    shb.addChild(participantElement);
                    WSBAServiceHelper.setParticipantState((String)contextId, (int)5);
                }
            } else if (action == 1 && (header = messageContext.getEnvelope().getHeader()) != null) {
                OMFactory omFactory = header.getOMFactory();
                SOAPHeaderBlock shb = header.addHeaderBlock(WSBA10Constants.DEFER_EXIT_NAME.getLocalName(), OMAbstractFactory.getOMFactory().createOMNamespace("http://www.ibm.com/ws-tx/wsba/ext", "websphere-wsba"));
                OMElement contextElement = omFactory.createOMElement(new QName("http://www.ibm.com/ws-tx/wsba/ext", WSCoorConstants.CONTEXT_ID_ELEMENT_NAME.getLocalName(), "websphere-wsba"), shb);
                OMElement participantElement = omFactory.createOMElement(new QName("http://www.ibm.com/ws-tx/wsba/ext", WSCoorConstants.INSTANCE_ID_ELEMENT_NAME.getLocalName(), "websphere-wsba"), shb);
                OMText contextText = omFactory.createOMText((OMContainer)contextElement, contextId);
                OMText participantText = omFactory.createOMText((OMContainer)participantElement, participantId);
                contextElement.addChild(contextText);
                participantElement.addChild(participantText);
                shb.addChild(contextElement);
                shb.addChild(participantElement);
                WSBAServiceHelper.setParticipantState((String)contextId, (int)11);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "outboundResponse");
        }
    }
}

