/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.util;

import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class SameDocumentEncryptedKeyRetriever
implements EncryptedKeyRetriever {
    private Map fEncryptedKeyLists = new HashMap();

    public SameDocumentEncryptedKeyRetriever(OMDocument doc) throws StructureException {
        if (doc == null) {
            throw new NullPointerException("Document not specified");
        }
        OMElement e = doc.getOMDocumentElement();
        if (e != null) {
            this.addEncryptedKeys(e);
        }
    }

    private void addEncryptedKeys(OMNode node) throws StructureException {
        if (node.getType() == 1) {
            OMElement elem = (OMElement)node;
            if (EncryptedKey.isOfType(elem)) {
                this.addEncryptedKeys(new EncryptedKey(elem));
            } else {
                for (OMNode n = elem.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                    this.addEncryptedKeys(n);
                }
            }
        }
    }

    private void addEncryptedKeys(EncryptedKey encKey) throws StructureException {
        KeyInfo ki;
        ReferenceList rl = encKey.getReferenceList();
        if (rl != null) {
            Iterator i = rl.getReferences().iterator();
            while (i.hasNext()) {
                String s = ((ReferenceType)i.next()).getURI();
                if (s == null) {
                    throw new StructureException("URI not specified");
                }
                if (!(s = s.trim()).startsWith("#") || s.length() < 2) continue;
                s = this.getId(s);
                this.retrieve(s).add(encKey);
            }
        }
        if ((ki = encKey.getKeyInfo()) != null) {
            for (Object o : ki.getKeyIds()) {
                if (!(o instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)o);
            }
        }
    }

    private String getId(String uri) {
        char c;
        String s;
        String id = uri.substring(1);
        if (id.startsWith("xpointer(") && id.endsWith(")") && (s = id.substring(9, id.length() - 1).trim()).startsWith("id(") && s.endsWith(")") && (s = s.substring(3, id.length() - 1).trim()).length() > 2 && ((c = s.charAt(0)) == '\"' || c == '\'') && c == s.charAt(s.length() - 1)) {
            id = s.substring(1, s.length() - 1);
        }
        return id;
    }

    public List retrieve(String id) {
        List encKeys = null;
        if (id != null) {
            if (!this.fEncryptedKeyLists.containsKey(id)) {
                this.fEncryptedKeyLists.put(id, new ArrayList());
            }
            encKeys = (List)this.fEncryptedKeyLists.get(id);
        }
        return encKeys;
    }
}

