/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.util;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;

public class DOMUtil {
    private static final boolean DEBUG = false;
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XMLNS_NS_PREFIX = "xmlns";

    public static Map getNamespaceDeclAttrNodes(OMNode node) {
        HashMap<String, OMNamespace> attrs = null;
        if (node != null) {
            attrs = new HashMap<String, OMNamespace>();
            DOMUtil._getNamespaceDeclAttrNodes(node, node, attrs);
            OMFactory d = node.getOMFactory();
            OMNamespace ns = d.createOMNamespace(XML_NS, XML_NS_PREFIX);
            attrs.put(ns.getPrefix(), ns);
        }
        return attrs;
    }

    private static void _getNamespaceDeclAttrNodes(OMNode current, OMNode start, Map attrs) {
        OMContainer cont = current.getParent();
        if (cont != null && cont instanceof OMElement) {
            DOMUtil._getNamespaceDeclAttrNodes((OMNode)((Object)cont), start, attrs);
        }
        if (current != start && current.getType() == 1) {
            Iterator i = ((OMElement)current).getAllDeclaredNamespaces();
            while (i.hasNext()) {
                OMNamespace ns = (OMNamespace)i.next();
                attrs.put(ns.getPrefix(), ns);
            }
        }
    }

    public static OMNode getRootNode(OMNode node) {
        OMNode root = null;
        if (node != null) {
            root = DOMUtil._getRootNode(node);
        }
        return root;
    }

    private static OMNode _getRootNode(OMNode node) {
        OMNode root = node;
        if (DOMUtil.hasParentNode(node)) {
            root = DOMUtil._getRootNode((OMNode)((Object)node.getParent()));
        }
        return root;
    }

    public static OMElement getFirstElement(ArrayList nodes) {
        return (OMElement)DOMUtil.getFirstNodeOfType(nodes, (short)1);
    }

    public static OMNode getFirstNodeOfType(ArrayList nodes, short type) {
        OMNode first = null;
        if (nodes != null) {
            int l = nodes.size();
            for (int i = 0; i < l; ++i) {
                OMNode n = (OMNode)nodes.get(i);
                if (n.getType() != type) continue;
                first = n;
                break;
            }
        }
        return first;
    }

    public static OMElement getFirstChildElement(OMNode node) {
        return (OMElement)DOMUtil.getFirstChildNodeOfType(node, (short)1);
    }

    public static OMNode getFirstChildNodeOfType(OMNode node, short type) {
        if (!(node instanceof OMContainer)) {
            return null;
        }
        OMNode first = ((OMContainer)((Object)node)).getFirstOMChild();
        if (first != null) {
            first = DOMUtil.getNextSiblingNodeOfType(first, type);
        }
        return first;
    }

    public static OMElement getNextSiblingElement(OMNode node) {
        return (OMElement)DOMUtil.getNextSiblingNodeOfType(node, (short)1);
    }

    public static OMNode getNextSiblingNodeOfType(OMNode node, short type) {
        OMNode next = null;
        if (node != null) {
            while (node != null) {
                if (node.getType() == type) {
                    next = node;
                    break;
                }
                node = node.getNextOMSibling();
            }
        }
        return next;
    }

    public static OMElement getLastChildElement(OMNode node) {
        return (OMElement)DOMUtil.getLastChildNodeOfType(node, (short)1);
    }

    public static OMNode getLastChildNodeOfType(OMNode node, short type) {
        OMNode last = null;
        if (!(node instanceof OMContainer)) {
            return null;
        }
        OMNode child = ((OMContainer)((Object)node)).getFirstOMChild();
        if (child != null) {
            while ((last = child.getNextOMSibling()) != null) {
                child = last;
            }
        }
        last = DOMUtil.getPreviousSiblingNodeOfType(child, type);
        return last;
    }

    public static OMNode getPreviousSiblingElement(OMNode node) {
        return DOMUtil.getPreviousSiblingNodeOfType(node, (short)1);
    }

    public static OMNode getPreviousSiblingNodeOfType(OMNode node, short type) {
        OMNode prev = null;
        if (node != null) {
            while (node != null) {
                if (node.getType() == type) {
                    prev = node;
                    break;
                }
                node = node.getPreviousOMSibling();
            }
        }
        return prev;
    }

    public static void moveChildNodes(OMNode oldNode, OMNode newNode) {
        if (oldNode == null || newNode == null) {
            return;
        }
        if (!(oldNode instanceof OMContainer) || !(newNode instanceof OMContainer)) {
            return;
        }
        OMNode n = ((OMContainer)((Object)oldNode)).getFirstOMChild();
        while (n != null) {
            OMNode next = n.getNextOMSibling();
            ((OMContainer)((Object)newNode)).addChild(n);
            n = next;
        }
    }

    public static void removeChildNodes(OMNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof OMContainer)) {
            return;
        }
        Iterator i = ((OMContainer)((Object)node)).getChildren();
        while (i.hasNext()) {
            ((OMNode)i.next()).detach();
        }
    }

    public static Iterator getChildNodes(OMNode node) {
        if (node == null) {
            return null;
        }
        if (!(node instanceof OMContainer)) {
            return null;
        }
        Iterator nodeList = ((OMContainer)((Object)node)).getChildren();
        return nodeList;
    }

    public static OMNode replaceNode(OMNode oldNode, OMNode newNode) {
        if (oldNode != null && newNode != null) {
            OMNode next = oldNode.getNextOMSibling();
            if (next != null) {
                oldNode.detach();
                if (newNode.getParent() != null) {
                    newNode.detach();
                }
                next.insertSiblingBefore(newNode);
            } else {
                OMContainer p = oldNode.getParent();
                oldNode.detach();
                p.addChild(newNode);
            }
        }
        return newNode;
    }

    public static Iterator replaceNode(OMNode oldNode, Iterator newNodes) {
        if (oldNode != null && DOMUtil.hasParentNode(oldNode) && newNodes != null && newNodes.hasNext()) {
            ArrayList<OMNode> nodeList = new ArrayList<OMNode>();
            OMContainer p = oldNode.getParent();
            OMNode next = oldNode.getNextOMSibling();
            oldNode.detach();
            if (next != null) {
                while (newNodes.hasNext()) {
                    OMNode n = (OMNode)newNodes.next();
                    if (n.getParent() != null) {
                        n.detach();
                    }
                    next.insertSiblingBefore(n);
                    nodeList.add(n);
                }
            } else {
                while (newNodes.hasNext()) {
                    OMNode n = (OMNode)newNodes.next();
                    p.addChild(n);
                    nodeList.add(n);
                }
            }
            return nodeList.iterator();
        }
        return newNodes;
    }

    public static OMNode replaceNodes(Iterator oldNodes, OMNode newNode) {
        if (oldNodes != null && oldNodes.hasNext() && newNode != null) {
            OMNode oldNode = (OMNode)oldNodes.next();
            OMContainer p = oldNode.getParent();
            OMNode next = oldNode.getNextOMSibling();
            oldNode.detach();
            if (next != null) {
                if (newNode.getParent() != null) {
                    newNode.detach();
                }
                next.insertSiblingBefore(newNode);
            } else {
                if (newNode.getParent() != null) {
                    newNode.detach();
                }
                p.addChild(newNode);
            }
            while (oldNodes.hasNext()) {
                ((OMNode)oldNodes.next()).detach();
            }
            return newNode;
        }
        return newNode;
    }

    public static ArrayList getElementsByTagNameNS(OMNode node, String nsUri, String localName) {
        ArrayList nodeList = null;
        if (node != null) {
            nodeList = new ArrayList();
            DOMUtil.getElementsByTagName(node, nsUri, localName, nodeList);
        }
        return nodeList;
    }

    public static Iterator getElementsByTagName(OMNode node, String name) {
        ArrayList nodeList = null;
        if (node != null) {
            nodeList = new ArrayList();
            DOMUtil.getElementsByTagName(node, null, name, nodeList);
        }
        return nodeList.iterator();
    }

    private static void getElementsByTagName(OMNode node, String nsUri, String localName, ArrayList nodeList) {
        if (node.getType() == 1) {
            String ns;
            OMElement e = (OMElement)node;
            String string = ns = e.getNamespace() == null ? null : e.getNamespace().getName();
            if (nsUri == null || nsUri.equals("*") || nsUri.equals(ns)) {
                String ln = e.getLocalName();
                if (localName == null || localName.equals("*") || localName.equals(ln)) {
                    nodeList.add(node);
                }
            }
            for (OMNode n = e.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                DOMUtil.getElementsByTagName(n, nsUri, localName, nodeList);
            }
        }
    }

    public static ArrayList getElementsByAttribute(OMNode node, String name, String value) {
        ArrayList nodeList = null;
        if (node != null) {
            nodeList = new ArrayList();
            DOMUtil.getElementsByAttribute(node, name, value, nodeList);
        }
        return nodeList;
    }

    private static void getElementsByAttribute(OMNode node, String name, String value, ArrayList nodeList) {
        if (node.getType() == 1) {
            if (name == null || name.equals("*")) {
                Iterator m = ((OMElement)node).getAllAttributes();
                while (m.hasNext()) {
                    String v = ((OMAttribute)m.next()).getAttributeValue();
                    if (value != null && !value.equals("*") && !value.equals(v)) continue;
                    nodeList.add(node);
                    break;
                }
            } else {
                OMElement e = (OMElement)node;
                if (value == null || value.equals("*") || value.equals(e.getAttributeValue(new QName(name)))) {
                    nodeList.add(node);
                }
            }
        }
        for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            DOMUtil.getElementsByAttribute(n, name, value, nodeList);
        }
    }

    static void printNode(OMNode node, boolean deep) {
        if (node != null) {
            DOMUtil.printNode(node, "", deep);
        }
    }

    private static void printNode(OMNode node, String indent, boolean deep) {
    }

    private static String getString(int type) {
        String str = null;
        switch (type) {
            case 12: {
                str = "CDATA_SECTION";
                break;
            }
            case 5: {
                str = "COMMENT";
                break;
            }
            case 11: {
                str = "DTD";
                break;
            }
            case 1: {
                str = "ELEMENT";
                break;
            }
            case 9: {
                str = "ENTITY_REFERENCE";
                break;
            }
            case 3: {
                str = "PI";
                break;
            }
            case 4: {
                str = "TEXT";
                break;
            }
            case 6: {
                str = "SPACE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + type);
            }
        }
        return str;
    }

    private static String getQuotedString(String str) {
        if (str != null) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    public static boolean isDescendantNode(Object node, OMNode ancestor) {
        boolean descendant = false;
        if (node != null && ancestor != null) {
            if (node instanceof OMNamespaceWithOwner) {
                node = ((OMNamespaceWithOwner)node).getOwnerElement();
                descendant = DOMUtil._isDescendantNode((OMNode)node, ancestor);
            } else if (node instanceof OMAttributeWithOwner) {
                node = ((OMAttributeWithOwner)node).getOwnerElement();
                descendant = DOMUtil._isDescendantNode((OMNode)node, ancestor);
            } else if (node instanceof OMNode) {
                descendant = DOMUtil._isDescendantNode((OMNode)node, ancestor);
            }
        }
        return descendant;
    }

    private static boolean _isDescendantNode(OMNode node, OMNode ancestor) {
        boolean descendant = false;
        if (node == ancestor) {
            descendant = true;
        } else if (DOMUtil.hasParentNode(node)) {
            descendant = DOMUtil._isDescendantNode((OMNode)((Object)node.getParent()), ancestor);
        }
        return descendant;
    }

    public static boolean contains(ArrayList nodes, int start, OMNode node) {
        return DOMUtil.contains(nodes, start, nodes != null ? nodes.size() : -1, node);
    }

    public static boolean contains(ArrayList nodes, int start, int end, OMNode node) {
        return DOMUtil.getIndex(node, nodes, start, end) >= 0;
    }

    public static int getIndex(OMNode node, ArrayList nodes, int start) {
        return DOMUtil.getIndex(node, nodes, start, nodes != null ? nodes.size() : -1);
    }

    public static int getIndex(OMNode node, ArrayList nodes, int start, int end) {
        int index = -1;
        if (node != null && nodes != null) {
            if (start < 0 || start >= nodes.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(start));
            }
            if (end <= start || end > nodes.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(end));
            }
            for (int i = start; index < 0 && i < end; ++i) {
                if (nodes.get(i) != node) continue;
                index = i;
            }
        }
        return index;
    }

    public static String getStringValue(ArrayList nodeSet, int index) {
        String value = null;
        if (nodeSet != null) {
            if (index < 0 || index >= nodeSet.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            Object obj = nodeSet.get(index);
            if (obj instanceof OMNamespace) {
                value = ((OMNamespace)obj).getName();
                return value;
            }
            if (obj instanceof OMAttribute) {
                value = ((OMAttribute)obj).getAttributeValue();
                return value;
            }
            OMNode n = (OMNode)obj;
            int s = n.getType();
            switch (s) {
                case 1: {
                    StringBuffer sb = new StringBuffer();
                    DOMUtil._getStringValue(n, nodeSet, index + 1, sb);
                    value = sb.toString();
                    break;
                }
                case 5: {
                    value = DOMUtil.getString(((OMComment)n).getValue());
                    break;
                }
                case 3: {
                    value = DOMUtil.getString(((OMProcessingInstruction)n).getValue());
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    value = DOMUtil.getString(((OMText)n).getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown node type: " + s);
                }
            }
        }
        return value;
    }

    private static int _getStringValue(OMNode node, ArrayList nodeSet, int index, StringBuffer buf) {
        int index2 = index;
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: 
                case 9: {
                    index2 = DOMUtil._getStringValue(n, nodeSet, index2, buf);
                    continue block4;
                }
                case 4: 
                case 12: {
                    int i = DOMUtil.getIndex(n, nodeSet, index2);
                    if (i < 0) continue block4;
                    DOMUtil.getStringValueFromText((OMText)n, buf);
                    index2 = i + 1;
                }
            }
        }
        return index2;
    }

    private static String getString(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }

    private static void getStringValueFromText(OMText omText, StringBuffer buffer) {
        Object dh;
        if (omText.isOptimized() && (dh = omText.getDataHandler()) instanceof DataHandler) {
            try {
                InputStream is = ((DataHandler)dh).getInputStream();
                if (is != null) {
                    DOMUtil.toStringValueFromInputStream(is, buffer);
                    return;
                }
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException("Internal Error: Unexpected IOException: " + e.getMessage());
                rte.initCause(e);
                throw rte;
            }
        }
        buffer.append(omText.getText());
    }

    private static void toStringValueFromInputStream(InputStream inStream, StringBuffer buffer) throws IOException {
        int avail = inStream.available();
        if (avail > 0) {
            buffer.ensureCapacity((int)((double)avail * 1.4) + buffer.length());
        }
        do {
            int len;
            byte[] data = new byte[1023];
            while ((len = inStream.read(data)) > 0) {
                Base64.encode(data, 0, len, buffer);
            }
        } while (inStream.available() > 0);
    }

    public static boolean hasParentNode(OMNode node) {
        return node != null && node.getParent() != null && !(node.getParent() instanceof OMDocument);
    }

    private static boolean canHaveParentNode(OMNode node) {
        boolean can = true;
        return can;
    }
}

