/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class Transform
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "Transform";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final QName ATTR_ALGORITHM_Q = new QName("", "Algorithm");
    private static final String ELEM_XPATH = "XPath";
    private String fAlgorithm;

    public Transform() {
        this((OMElement)null);
    }

    public Transform(OMElement trans) {
        super(trans);
        if (trans != null) {
            if (!Transform.isOfType(trans)) {
                throw new IllegalArgumentException("Not Transform element");
            }
            this.fAlgorithm = trans.getAttributeValue(ATTR_ALGORITHM_Q);
            this.init(trans);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(OMElement elem) {
        String s1 = elem.getNamespace() == null ? "" : elem.getNamespace().getName();
        String s2 = elem.getLocalName();
        return s1 != null && (!s1.equals(NAMESPACE) || s2 != null && s2.equals(ELEM_XPATH));
    }

    public void setAlgorithm(String uri) {
        this.fAlgorithm = uri;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(OMElement param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement trans = DOMUtils.createDsigOMElement(NAME, factory, parent);
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        trans.addAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm), null);
        super.addChildElement(trans, factory);
        return trans;
    }

    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        throw new StructureException("Internal error: creation of Transform element not supported with WSSObject");
    }
}

