/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public abstract class ReferenceType
extends ElementsType {
    private static final String ATTR_URI = "URI";
    private static final QName ATTR_URI_Q = new QName("", "URI");
    private String fUri;
    private VariablePartAttributeValue fVariablePartUri;

    public ReferenceType(OMElement refType) {
        super(refType);
        if (refType != null) {
            this.fUri = refType.getAttributeValue(ATTR_URI_Q);
            this.init(refType);
        }
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    abstract boolean isParameter(OMElement var1);

    public void setURI(String uri) {
        this.fUri = uri;
    }

    public void setVariablePartURI(VariablePartAttributeValue vPartUri) {
        this.fVariablePartUri = vPartUri;
    }

    public String getURI() {
        if (this.fVariablePartUri != null) {
            return this.fVariablePartUri.toString();
        }
        return this.fUri;
    }

    public void addParameter(OMElement param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    void addChildElement(OMElement refType, OMFactory factory) throws StructureException {
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        refType.addAttribute(ATTR_URI, Util.normalize(this.fUri), null);
        super.addChildElement(refType, factory);
    }

    void createElement(WSSObjectElement refType, WSSObjectDocumentImpl doc) throws StructureException {
        if (this.fVariablePartUri != null) {
            refType.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_URI, this.fVariablePartUri);
        } else if (this.fUri != null) {
            refType.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_URI, VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fUri)));
        } else {
            throw new StructureException("URI not specified");
        }
        super.createElement(refType, doc);
    }
}

