/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.RetrievalMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class KeyInfo
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "KeyInfo";
    private static final String ATTR_ID = "Id";
    private static final QName ATTR_ID_Q = new QName("", "Id");
    private static final String ELEM_KEY_VALUE = "KeyValue";
    private static final String ELEM_X509_DATA = "X509Data";
    private static final String ELEM_PGP_DATA = "PGPData";
    private static final String ELEM_SPKI_DATA = "SPKIData";
    private static final String ELEM_MGMT_DATA = "MgmtData";
    private String fId;

    public KeyInfo() {
        this((OMElement)null);
    }

    public KeyInfo(OMElement keyInfo) {
        super(keyInfo);
        if (keyInfo != null) {
            if (!KeyInfo.isOfType(keyInfo)) {
                throw new IllegalArgumentException("Not KeyInfo element");
            }
            this.fId = keyInfo.getAttributeValue(ATTR_ID_Q);
            this.init(keyInfo);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    Object o = null;
                    if (EncryptedKey.isOfType(e)) {
                        o = new EncryptedKey(e);
                    } else if (KeyName.isOfType(e)) {
                        o = new KeyName(e);
                    } else if (RetrievalMethod.isOfType(e)) {
                        o = new RetrievalMethod(e);
                    } else if (this.isKeyId(e)) {
                        o = e;
                    }
                    super.addElement(o);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isKeyId(OMElement elem) {
        String s1 = elem.getNamespace() == null ? null : elem.getNamespace().getName();
        String s2 = elem.getLocalName();
        return s1 != null && (!s1.equals(NAMESPACE) || s2 != null && (s2.equals(ELEM_KEY_VALUE) || s2.equals(ELEM_X509_DATA) || s2.equals(ELEM_PGP_DATA) || s2.equals(ELEM_SPKI_DATA) || s2.equals(ELEM_MGMT_DATA)));
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public void addEncryptedKey(EncryptedKey encKey) {
        super.addElement(encKey);
    }

    public void addKeyName(KeyName keyName) {
        super.addElement(keyName);
    }

    public void addRetrievalMethod(RetrievalMethod retMeth) {
        super.addElement(retMeth);
    }

    public void addKeyId(OMElement keyId) {
        if (keyId != null) {
            if (!this.isKeyId(keyId)) {
                throw new IllegalArgumentException("Wrong key id");
            }
            super.addElement(keyId);
        }
    }

    public List getKeyIds() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement keyInfo = DOMUtils.createDsigOMElement(NAME, factory, parent);
        if (this.fId != null) {
            keyInfo.addAttribute(ATTR_ID, Util.normalize(this.fId), null);
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Key ids not specified");
        }
        super.addChildElement(keyInfo, factory);
        return keyInfo;
    }

    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        com.ibm.ws.wssecurity.wssobject.impl.dsig.KeyInfo keyInfo = new com.ibm.ws.wssecurity.wssobject.impl.dsig.KeyInfo(doc);
        if (this.fId != null) {
            keyInfo.setId(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fId)));
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Key ids not specified");
        }
        super.createElement(keyInfo, doc);
        return keyInfo;
    }
}

