/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionProperties;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public abstract class EncryptedType
extends Type {
    private static final String ATTR_ID = "Id";
    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_MIME_TYPE = "MimeType";
    private static final String ATTR_ENCODING = "Encoding";
    private static final QName ATTR_ID_Q = new QName("", "Id");
    private static final QName ATTR_TYPE_Q = new QName("", "Type");
    private static final QName ATTR_MIME_TYPE_Q = new QName("", "MimeType");
    private static final QName ATTR_ENCODING_Q = new QName("", "Encoding");
    private String fId;
    private VariablePartAttributeValue fVariablePartId;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;
    private CipherData fCipherData;
    private EncryptionProperties fEncryptionProperties;

    public EncryptedType(OMElement encType) {
        super(encType);
        if (encType != null) {
            this.fId = encType.getAttributeValue(ATTR_ID_Q);
            if (!EncryptedHeader.isOfType(encType)) {
                this.fType = encType.getAttributeValue(ATTR_TYPE_Q);
                this.fMimeType = encType.getAttributeValue(ATTR_MIME_TYPE_Q);
                this.fEncoding = encType.getAttributeValue(ATTR_ENCODING_Q);
            }
            this.init(encType);
        }
    }

    public static EncryptedType getInstance(OMElement encType) {
        if (encType == null) {
            throw new NullPointerException("Element not specified");
        }
        EncryptedType encType2 = null;
        if (EncryptedData.isOfType(encType)) {
            encType2 = new EncryptedData(encType);
        } else if (EncryptedKey.isOfType(encType)) {
            encType2 = new EncryptedKey(encType);
        } else if (EncryptedHeader.isOfType(encType)) {
            encType2 = new EncryptedHeader(encType);
        } else {
            throw new IllegalArgumentException("Unknown element type: " + encType.getQName());
        }
        return encType2;
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (EncryptionMethod.isOfType(e)) {
                        this.fEncryptionMethod = new EncryptionMethod(e);
                        continue block4;
                    }
                    if (KeyInfo.isOfType(e)) {
                        this.fKeyInfo = new KeyInfo(e);
                        continue block4;
                    }
                    if (CipherData.isOfType(e)) {
                        this.fCipherData = new CipherData(e);
                        continue block4;
                    }
                    if (EncryptionProperties.isOfType(e)) {
                        this.fEncryptionProperties = new EncryptionProperties(e);
                        continue block4;
                    }
                    if (!EncryptedData.isOfType(e)) continue block4;
                    this.fType = "http://www.w3.org/2001/04/xmlenc#Element";
                    this.fMimeType = e.getAttributeValue(ATTR_MIME_TYPE_Q);
                    this.fEncoding = e.getAttributeValue(ATTR_ENCODING_Q);
                    this.init(n);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    public void setId(String id) {
        this.fId = id;
    }

    public void setVariablePartId(VariablePartAttributeValue vPartId) {
        this.fVariablePartId = vPartId;
    }

    public String getId() {
        if (this.fVariablePartId != null) {
            return this.fVariablePartId.toString();
        }
        return this.fId;
    }

    public void setType(String uri) {
        this.fType = uri;
    }

    public String getType() {
        return this.fType;
    }

    public void setMimeType(String mimeType) {
        this.fMimeType = mimeType;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncryptionMethod(EncryptionMethod encMeth) {
        this.fEncryptionMethod = encMeth;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.fEncryptionMethod;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.fKeyInfo;
    }

    public void setCipherData(CipherData ciphData) {
        this.fCipherData = ciphData;
    }

    public CipherData getCipherData() {
        return this.fCipherData;
    }

    public void setEncryptionProperties(EncryptionProperties encProps) {
        this.fEncryptionProperties = encProps;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.fEncryptionProperties;
    }

    void createElement(OMElement encType, OMFactory factory) throws StructureException {
        OMElement e;
        if (this.fId != null) {
            encType.addAttribute(ATTR_ID, Util.normalize(this.fId), null);
        }
        if (this.fType != null) {
            encType.addAttribute(ATTR_TYPE, Util.normalize(this.fType), null);
        }
        if (this.fMimeType != null) {
            encType.addAttribute(ATTR_MIME_TYPE, Util.normalize(this.fMimeType), null);
        }
        if (this.fEncoding != null) {
            encType.addAttribute(ATTR_ENCODING, Util.normalize(this.fEncoding), null);
        }
        if (this.fEncryptionMethod != null) {
            e = this.fEncryptionMethod.createElement(factory, encType);
            encType.addChild(e);
        }
        if (this.fKeyInfo != null) {
            e = this.fKeyInfo.createElement(factory, encType);
            encType.addChild(e);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        e = this.fCipherData.createElement(factory, encType);
        encType.addChild(e);
        if (this.fEncryptionProperties != null) {
            e = this.fEncryptionProperties.createElement(factory, encType);
            encType.addChild(e);
        }
    }

    void createElement(com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedType encType, WSSObjectDocumentImpl doc) throws StructureException {
        WSSObjectElement e;
        if (this.fVariablePartId != null) {
            encType.setId(this.fVariablePartId);
        } else if (this.fId != null) {
            encType.setId(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fId)));
        }
        if (this.fType != null && !(encType.getParent() instanceof com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader)) {
            encType.setType(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fType)));
        }
        if (this.fMimeType != null) {
            encType.setMimeType(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fMimeType)));
        }
        if (this.fEncoding != null) {
            encType.setEncoding(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fEncoding)));
        }
        if (this.fEncryptionMethod != null) {
            e = this.fEncryptionMethod.createElement(doc);
            encType.setEncryptionMethod((com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptionMethod)e);
        }
        if (this.fKeyInfo != null) {
            e = this.fKeyInfo.createElement(doc);
            encType.setKeyInfo((com.ibm.ws.wssecurity.wssobject.impl.dsig.KeyInfo)e);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        e = this.fCipherData.createElement(doc);
        encType.setCipherData((com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData)e);
        if (this.fEncryptionProperties != null) {
            e = this.fEncryptionProperties.createElement(doc);
            encType.setEncryptionProperties((com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptionProperties)e);
        }
    }

    void createElement(OMElement parent, OMElement encType, OMFactory factory, OMNamespace wsuNs) throws StructureException {
        if (this.fId != null) {
            boolean encHeaderPreV7Compatibility = false;
            if (this instanceof EncryptedHeader) {
                EncryptedHeader eh = (EncryptedHeader)this;
                encHeaderPreV7Compatibility = eh.getPreV7Compatibility();
            }
            if (encHeaderPreV7Compatibility) {
                parent.addAttribute(ATTR_ID, Util.normalize(this.fId), wsuNs);
            } else {
                encType.addAttribute(ATTR_ID, Util.normalize(this.fId), null);
            }
        }
        if (this.fMimeType != null) {
            encType.addAttribute(ATTR_MIME_TYPE, Util.normalize(this.fMimeType), null);
        }
        if (this.fEncoding != null) {
            encType.addAttribute(ATTR_ENCODING, Util.normalize(this.fEncoding), null);
        }
        if (this.fEncryptionMethod != null) {
            OMElement e = this.fEncryptionMethod.createElement(factory, encType);
            encType.addChild(e);
        }
        if (this.fKeyInfo != null) {
            OMElement e = this.fKeyInfo.createElement(factory, encType);
            encType.addChild(e);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        OMElement e = this.fCipherData.createElement(factory, encType);
        encType.addChild(e);
        if (this.fEncryptionProperties != null) {
            e = this.fEncryptionProperties.createElement(factory, encType);
            encType.addChild(e);
        }
    }
}

