/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class DigestMethod
extends ElementsType {
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "DigestMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final QName ATTR_ALGORITHM_Q = new QName("", "Algorithm");
    private String fAlgorithm;

    public DigestMethod() {
        this((OMElement)null);
    }

    public DigestMethod(OMElement digMeth) {
        super(digMeth);
        if (digMeth != null) {
            if (!DigestMethod.isOfType(digMeth)) {
                throw new IllegalArgumentException("Not DigestMethod element");
            }
            this.fAlgorithm = digMeth.getAttributeValue(ATTR_ALGORITHM_Q);
            this.init(digMeth);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(OMElement elem) {
        String s = elem.getNamespace() == null ? null : elem.getNamespace().getName();
        return s != null && !s.equals(NAMESPACE);
    }

    public void setAlgorithm(String uri) {
        this.fAlgorithm = uri;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(OMElement param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement digMeth = DOMUtils.createDsigOMElement(NAME, factory, parent);
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        digMeth.addAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm), null);
        super.addChildElement(digMeth, factory);
        return digMeth;
    }

    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        com.ibm.ws.wssecurity.wssobject.impl.dsig.DigestMethod digMeth = new com.ibm.ws.wssecurity.wssobject.impl.dsig.DigestMethod(doc);
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        digMeth.setAlgorithm(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fAlgorithm)));
        super.createElement(digMeth, doc);
        return digMeth;
    }
}

