/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.io.AsciiStringInputStream;
import com.ibm.ws.wssecurity.util.io.Base64DecodeInputStream;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.TextHelper;

public abstract class Base64BinaryType
extends Type {
    protected String fValueEncoded;
    ByteArrayHolder fByteArrayHolder;

    public Base64BinaryType(OMElement binType) {
        super(binType);
        if (binType != null) {
            this.fValueEncoded = DOMUtil.getStringValue(binType);
        }
    }

    protected void decode() {
        if (this.fByteArrayHolder == null && this.fValueEncoded != null && this.fValueEncoded.length() > 0) {
            byte[] value = Base64Table.decode(this.fValueEncoded, 0, this.fValueEncoded.length());
            this.fByteArrayHolder = new ByteArrayHolder(value);
        }
    }

    protected void encode() {
        if (this.fByteArrayHolder != null && this.fByteArrayHolder.getLength() > 0 && this.fValueEncoded == null) {
            this.fValueEncoded = Base64Table.encodeToString(this.fByteArrayHolder.getValue(), this.fByteArrayHolder.getOffset(), this.fByteArrayHolder.getLength());
        }
    }

    public void setValue(byte[] value) {
        this.fByteArrayHolder = new ByteArrayHolder(value);
    }

    public byte[] getValue() {
        this.decode();
        if (this.fByteArrayHolder == null) {
            return null;
        }
        return this.fByteArrayHolder.toByteArray();
    }

    public void setByteArrayHolder(ByteArrayHolder value) {
        this.fByteArrayHolder = value;
    }

    public ByteArrayHolder getByteArrayHolder() {
        this.decode();
        return this.fByteArrayHolder;
    }

    public InputStream getValueAsInputStream() {
        if (this.fByteArrayHolder != null) {
            return new ByteArrayInputStream(this.fByteArrayHolder.getValue(), this.fByteArrayHolder.getOffset(), this.fByteArrayHolder.getLength());
        }
        if (this.fValueEncoded != null) {
            AsciiStringInputStream asis = new AsciiStringInputStream(this.fValueEncoded);
            return new Base64DecodeInputStream(asis);
        }
        return null;
    }

    void createElement(OMElement binType, OMFactory factory) throws StructureException {
        this.createElement(binType, factory, false);
    }

    void createElement(OMElement binType, OMFactory factory, boolean mtomOptimize) throws StructureException {
        if (this.fByteArrayHolder != null && this.fByteArrayHolder.getLength() > 0 && this.fValueEncoded == null) {
            OMText cipherValueText;
            try {
                cipherValueText = TextHelper.toOMText(this.fByteArrayHolder.getValue(), this.fByteArrayHolder.getOffset(), this.fByteArrayHolder.getLength(), factory, mtomOptimize);
            }
            catch (Exception e) {
                StructureException se = new StructureException(e.getMessage());
                se.initCause(e);
                throw se;
            }
            binType.addChild(cipherValueText);
        } else if (this.fValueEncoded != null) {
            this.encode();
            OMText cipherValueText = factory.createOMText((OMContainer)binType, this.fValueEncoded);
            cipherValueText.setOptimize(mtomOptimize);
        }
    }
}

