/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

class XMLWriter {
    private static final String ENTITIES1 = "<>\"'&";
    private static final String[] ENTITY_NAMES = new String[]{"lt", "gt", "quot", "apos", "amp"};
    private static final String[] ENTITY_REFS = new String[]{"&lt;", "&gt;", "&amp;"};
    private static final String ENTITIES2 = "<>&";
    private Writer fOut;
    private Transformer fTransformer;
    private WriterChainHolder fWriterChainHolder = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();

    XMLWriter(OutputStream out) throws IOException {
        this.fWriterChainHolder.getProxyOutputStream().setOutputStream(out);
        this.fOut = this.fWriterChainHolder.getBufferedWriter();
    }

    void printText(String text) throws IOException {
        this.fOut.write(text);
    }

    void printText(char ch) throws IOException {
        this.fOut.write(ch);
    }

    private Throwable unwrapException(TransformerException exc) {
        Throwable thr = exc.getException();
        if (thr == null) {
            thr = exc;
        }
        return thr;
    }

    private String restoreEntities(String text) {
        for (int i = 0; i < ENTITY_REFS.length; ++i) {
            text = this.restoreEntity(text, ENTITY_REFS[i], ENTITIES2.charAt(i));
        }
        return text;
    }

    private String restoreEntity(String text, String ref, char entity) {
        StringBuffer sb = new StringBuffer();
        int tl = text.length();
        int rl = ref.length();
        for (int i = 0; i < tl; ++i) {
            int j = text.indexOf(ref, i);
            if (j >= 0) {
                sb.append(text.substring(i, j));
                sb.append(entity);
                i = j + rl;
                continue;
            }
            sb.append(text.substring(i));
            i = tl;
        }
        return sb.toString();
    }

    void printDoctypeURL(String url) throws IOException {
        this.printText('\"');
        int l = url.length();
        for (int i = 0; i < l; ++i) {
            if (url.charAt(i) == '\"' || url.charAt(i) < ' ' || url.charAt(i) > '\u007f') {
                this.printText('%');
                this.printText(Integer.toHexString(url.charAt(i)));
                continue;
            }
            this.printText(url.charAt(i));
        }
        this.printText('\"');
    }

    void printEscaped(String source) throws IOException {
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char lowch;
            int ch = source.charAt(i);
            if ((ch & 0xFC00) == 55296 && i + 1 < l && ((lowch = source.charAt(i + 1)) & 0xFC00) == 56320) {
                ch = 65536 + (ch - 55296 << 10) + lowch - 56320;
                ++i;
            }
            this.printEscaped(ch);
        }
    }

    private void printEscaped(int ch) throws IOException {
        if (ch >= 63 && ch <= 0x10FFFF && ch != 247 || ch >= 40 && ch <= 59 || ch == 32 || ch == 33 || ch == 35 || ch == 36 || ch == 37 || ch == 61 || ch == 10 || ch == 13 || ch == 9) {
            if (ch < 65536) {
                this.printText((char)ch);
            } else {
                this.printText((char)((ch - 65536 >> 10) + 55296));
                this.printText((char)((ch - 65536 & 0x3FF) + 56320));
            }
        } else {
            switch (ch) {
                case 60: {
                    this.printText("&lt;");
                    break;
                }
                case 62: {
                    this.printText("&gt;");
                    break;
                }
                case 39: {
                    this.printText("&apos;");
                    break;
                }
                case 34: {
                    this.printText("&quot;");
                    break;
                }
                case 38: {
                    this.printText("&amp;");
                    break;
                }
                default: {
                    this.printText("&#x");
                    this.printText(Integer.toHexString(ch));
                    this.printText(';');
                }
            }
        }
    }

    private String getEntityRef(int ch) {
        int i = ENTITIES1.indexOf(ch);
        String ref = null;
        if (i >= 0) {
            ref = ENTITY_NAMES[i];
        }
        return ref;
    }

    void flush() throws IOException {
        this.fOut.flush();
    }

    void close() {
        WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(this.fWriterChainHolder);
    }
}

