/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.om.OMElement;

class ResourceOutputStream
extends FilterOutputStream {
    private ResourceShower fResourceShower;
    private Object fData;
    private OMElement fEncryptedType;
    private WSSObjectElement fWSSObjectEncryptedType;
    private ByteArrayOutputStream fBuffer;

    ResourceOutputStream(OutputStream out, ResourceShower shower, Object data, OMElement encType) {
        super(out);
        this.fResourceShower = shower;
        this.fData = data;
        this.fEncryptedType = encType;
        this.fBuffer = new ByteArrayOutputStream();
    }

    ResourceOutputStream(OutputStream out, ResourceShower shower, Object data, WSSObjectElement encType) {
        super(out);
        this.fResourceShower = shower;
        this.fData = data;
        this.fWSSObjectEncryptedType = encType;
        this.fBuffer = new ByteArrayOutputStream();
    }

    OutputStream getOutputStream() {
        OutputStream os = this.out;
        return os;
    }

    void showResource() {
        try {
            this.fBuffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.fWSSObjectEncryptedType != null) {
            this.fResourceShower.showEncryptedResource(this.fBuffer.toByteArray(), this.fData, this.fWSSObjectEncryptedType);
        } else {
            this.fResourceShower.showEncryptedResource(this.fBuffer.toByteArray(), this.fData, this.fEncryptedType);
        }
    }

    public void write(int b) throws IOException {
        super.write(b);
        this.fBuffer.write(b);
    }

    public void flush() throws IOException {
        super.flush();
        this.fBuffer.flush();
    }

    public void close() throws IOException {
        super.close();
        this.fBuffer.close();
    }
}

