/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CarriedKeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.RetrievalMethod;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.xml.sax.EntityResolver;

public class KeyInfoResolverBase
implements KeyInfoResolver {
    private static final boolean DEBUG = false;
    protected boolean fInEncryptMode;
    private AlgorithmParameterSpec fKeyGenParameters;
    private AlgorithmFactory fAlgorithmFactory;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;

    public void setAlgorithmFactory(AlgorithmFactory factory) {
        this.fAlgorithmFactory = factory;
    }

    public void setIdResolver(IDResolver resolver2) {
        this.fIdResolver = resolver2;
    }

    public void setEntityResolver(EntityResolver resolver2) {
        this.fEntityResolver = resolver2;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever retriever) {
        this.fEncryptedKeyRetriever = retriever;
    }

    protected Key resolveEncryptedKey(EncryptedKey encKey, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        if (this.fInEncryptMode) {
            EncryptionContext ec = new EncryptionContext();
            ec.setAlgorithmFactory(this.fAlgorithmFactory);
            if (key == null) {
                ec.setEncryptedType(null, null, encMeth, null);
                try {
                    key = ec.generateKey();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ec.setKey(null);
            }
            ec.setData(key);
            ec.setEncryptedType(encKey, null, null, null);
            ec.setKeyInfoResolver(this);
            try {
                ec.encrypt();
            }
            catch (KeyInfoResolvingException e) {
                throw e;
            }
            catch (Exception e) {}
        } else {
            DecryptionContext dc;
            block11: {
                dc = new DecryptionContext();
                dc.setEncryptedType(encKey, null, null, null);
                dc.setEncryptionMethod(encMeth);
                dc.setAlgorithmFactory(this.fAlgorithmFactory);
                dc.setKeyInfoResolver(this);
                dc.setIdResolver(this.fIdResolver);
                dc.setEntityResolver(this.fEntityResolver);
                dc.setEncryptedKeyRetriever(this.fEncryptedKeyRetriever);
                try {
                    dc.decrypt();
                }
                catch (KeyInfoResolvingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Exception e2;
                    if (!(e instanceof XSignatureException) || (e2 = ((XSignatureException)e).getException()) == null) break block11;
                    e = e2;
                }
            }
            key = (Key)dc.getData();
        }
        return key;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        OMElement e;
        String s;
        if (!this.fInEncryptMode && (s = keyName.getName()) != null && (e = DOMUtil.getOwnerDocument(keyName.getBase()).getOMDocumentElement()) != null) {
            ArrayList l = new ArrayList();
            this.addEncryptedKeys(e, s, l);
            Iterator i = l.iterator();
            while (key == null && i.hasNext()) {
                key = this.resolveEncryptedKey((EncryptedKey)i.next(), encMeth, key);
            }
        }
        return key;
    }

    private void addEncryptedKeys(OMNode node, String name, List encKeys) {
        if (node.getType() == 1) {
            OMElement elem = (OMElement)node;
            if (EncryptedKey.isOfType(elem)) {
                this.addEncryptedKeys(new EncryptedKey((OMElement)node), name, encKeys);
            } else {
                for (OMNode n = elem.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                    this.addEncryptedKeys(n, name, encKeys);
                }
            }
        }
    }

    private void addEncryptedKeys(EncryptedKey encKey, String name, List encKeys) {
        KeyInfo ki;
        String s;
        CarriedKeyName kn = encKey.getCarriedKeyName();
        if (kn != null && (s = kn.getName()) != null && s.equals(name)) {
            encKeys.add(encKey);
        }
        if ((ki = encKey.getKeyInfo()) != null) {
            for (Object o : ki.getKeyIds()) {
                if (!(o instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)o, name, encKeys);
            }
        }
    }

    protected Key resolveRetrievalMethod(RetrievalMethod retMeth, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        if (!this.fInEncryptMode) {
            Object o;
            block4: {
                SignatureContext sc = new SignatureContext();
                sc.setAlgorithmFactory(this.fAlgorithmFactory);
                sc.setIDResolver(this.fIdResolver);
                sc.setEntityResolver(this.fEntityResolver);
                o = null;
                try {
                    o = sc.retrieve(retMeth.getBase());
                }
                catch (Exception e) {
                    Exception e2;
                    if (!(e instanceof XSignatureException) || (e2 = ((XSignatureException)e).getException()) == null) break block4;
                    e = e2;
                }
            }
            if (o instanceof EncryptedKey) {
                key = this.resolveEncryptedKey((EncryptedKey)o, encMeth, key);
            }
        }
        return key;
    }

    protected Key resolveKeyId(OMElement keyId, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        return key;
    }

    public void setOperationMode(int opMode) {
        boolean b = false;
        switch (opMode) {
            case 1: {
                b = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation mode: " + opMode);
            }
        }
        this.fInEncryptMode = b;
    }

    public Key resolve(KeyInfo keyInfo, EncryptionMethod encMeth) throws KeyInfoResolvingException {
        if (keyInfo == null) {
            throw new NullPointerException("KeyInfo not specified");
        }
        Key key = null;
        for (Object o : keyInfo.getKeyIds()) {
            if (o instanceof EncryptedKey) {
                key = this.resolveEncryptedKey((EncryptedKey)o, encMeth, key);
            } else if (o instanceof KeyName) {
                key = this.resolveKeyName((KeyName)o, encMeth, key);
            } else if (o instanceof RetrievalMethod) {
                key = this.resolveRetrievalMethod((RetrievalMethod)o, encMeth, key);
            } else if (o instanceof OMElement) {
                key = this.resolveKeyId((OMElement)o, encMeth, key);
            }
            if (this.fInEncryptMode || key == null) continue;
            break;
        }
        return key;
    }
}

