/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.core.EngineFactory;
import com.ibm.ws.wssecurity.core.KeyGenerationEngine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public abstract class EncryptionEngineImpl
implements EncryptionEngine {
    private static SecureRandom fSecureRandom = new SecureRandom();

    static SecureRandom getRandom() {
        return fSecureRandom;
    }

    public byte[] update(byte[] input) {
        return this.update(input, 0, input != null ? input.length : 0);
    }

    public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        return this.doFinal(null);
    }

    public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
        return this.doFinal(input, 0, input != null ? input.length : 0);
    }

    public static class RSAOAEP
    extends RSA {
        private static final String TRANS = "RSA/ /OAEPPADDINGSHA-1";
        private static final String TRANS256 = "RSA/ /OAEPPADDINGSHA-256";
        private static final String TRANS512 = "RSA/ /OAEPPADDINGSHA-512";

        public RSAOAEP(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(TRANS, provider, factory, true);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
        }

        protected static Cipher getOaepCipher(AlgorithmParameterSpec spec, Provider provider) {
            Method m;
            Cipher cipher = null;
            String trans = TRANS;
            Class clazz = OAEPHelper.OAEPParameterSpecClass;
            if (spec != null && clazz != null && clazz.isInstance(spec) && (m = OAEPHelper.getDigestAlgorithm) != null) {
                try {
                    Object obj = m.invoke((Object)spec, new Object[0]);
                    String digestMethod = null;
                    if (obj != null && obj instanceof String) {
                        digestMethod = (String)obj;
                        if ("SHA-1".equals(digestMethod) || "SHA1".equals(digestMethod)) {
                            trans = TRANS;
                        } else if ("SHA-256".equals(digestMethod) || "SHA256".equals(digestMethod)) {
                            trans = TRANS256;
                        } else if ("SHA-512".equals(digestMethod) || "SHA512".equals(digestMethod)) {
                            trans = TRANS512;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            try {
                cipher = provider == null ? Cipher.getInstance(trans) : Cipher.getInstance(trans, provider);
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (NoSuchPaddingException e) {
                // empty catch block
            }
            return cipher;
        }

        private static class OAEPHelper {
            static Class OAEPParameterSpecClass = null;
            static Method getDigestAlgorithm = null;

            private OAEPHelper() {
            }

            static {
                try {
                    OAEPParameterSpecClass = Class.forName("javax.crypto.spec.OAEPParameterSpec");
                    getDigestAlgorithm = OAEPParameterSpecClass.getMethod("getDigestAlgorithm", new Class[0]);
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public static class RSA15
    extends RSA {
        private static final String TRANS = "RSA";

        public RSA15(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(TRANS, provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
    }

    public static abstract class RSA
    extends EncryptionEngineImpl {
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Cipher fCipher;
        private Provider fProvider = null;
        private boolean fIsOaep = false;

        protected RSA(String trans, Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            this.fEngineFactory = factory;
            this.fProvider = provider;
            try {
                this.fCipher = provider != null ? Cipher.getInstance(trans, provider) : Cipher.getInstance(trans);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException(e.toString());
            }
        }

        protected RSA(String trans, Provider provider, EngineFactory factory, boolean isOaep) throws NoSuchAlgorithmException {
            this(trans, provider, factory);
            this.fIsOaep = isOaep;
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            Cipher cipher;
            this.fOpMode = opMode;
            switch (opMode) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    opMode = 1;
                    break;
                }
                case 4: {
                    opMode = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
            if (this.fIsOaep && spec != null && (cipher = RSAOAEP.getOaepCipher(spec, this.fProvider)) != null) {
                this.fCipher = cipher;
            }
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            if (spec != null) {
                this.fCipher.init(opMode, key, spec, RSA.getRandom());
            } else {
                this.fCipher.init(opMode, key, RSA.getRandom());
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: 
                case 2: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    output = this.fCipher.update(input, off, len);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return output;
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: 
                case 2: {
                    if (input != null) {
                        output = this.fCipher.doFinal(input, off, len);
                        break;
                    }
                    output = this.fCipher.doFinal();
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return output;
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    try {
                        wrappedKey = this.fCipher.doFinal(bb);
                        break;
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (wrappedKey.length == 0) {
                        throw new InvalidKeyException("Data too short");
                    }
                    byte[] bb = null;
                    try {
                        bb = this.fCipher.doFinal(wrappedKey);
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new RuntimeException(e);
                    }
                    KeyGenerationEngine kge = this.fEngineFactory.getKeyGenerationEngine(uri, type);
                    if (kge == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + uri + ", " + type);
                    }
                    key = kge.generateKey(bb);
                    this.fEngineFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class KWAES256
    extends KWAES {
        private static final int KEY_LENGTH = 32;

        public KWAES256(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 32) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static class KWAES192
    extends KWAES {
        private static final int KEY_LENGTH = 24;

        public KWAES192(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 24) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static class KWAES128
    extends KWAES {
        private static final int KEY_LENGTH = 16;

        public KWAES128(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 16) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static abstract class KWAES
    extends EncryptionEngineImpl {
        private static final String TRANS = "AES/ECB/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private static final byte[] PADS = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Cipher fCipher;

        protected KWAES(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            this.fEngineFactory = factory;
            try {
                this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException(e.toString());
            }
        }

        private void encryptBlocks(byte[] c, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int j = 0; j <= 5; ++j) {
                for (int i = 1; i <= n; ++i) {
                    int t = i + j * n;
                    this.processBlock(c, i);
                    this.xorBlock(c, t);
                }
            }
        }

        private void decryptBlocks(byte[] p, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int j = 5; j >= 0; --j) {
                for (int i = n; i >= 1; --i) {
                    int t = i + j * n;
                    this.xorBlock(p, t);
                    this.processBlock(p, i);
                }
            }
        }

        private void processBlock(byte[] bb, int i) throws BadPaddingException, IllegalBlockSizeException {
            byte[] bb2 = new byte[16];
            System.arraycopy(bb, 0, bb2, 0, 8);
            System.arraycopy(bb, 8 * i, bb2, 8, 8);
            bb2 = this.fCipher.doFinal(bb2);
            System.arraycopy(bb2, 0, bb, 0, 8);
            System.arraycopy(bb2, 8, bb, 8 * i, 8);
        }

        private void xorBlock(byte[] bb, int t) {
            byte[] bb2 = BigInteger.valueOf(t).toByteArray();
            for (int i = 0; i < 8; ++i) {
                int j = i - 8 + bb2.length;
                int k = 0;
                if (j >= 0) {
                    k = bb2[j];
                }
                bb[i] = (byte)(k ^= bb[i]);
            }
        }

        private boolean arePadsChanged(byte[] p) {
            boolean changed = false;
            for (int i = 0; !changed && i < PADS.length; ++i) {
                if (p[i] == PADS[i]) continue;
                changed = true;
            }
            return changed;
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            switch (opMode) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                case 3: {
                    this.fCipher.init(1, key, KWAES.getRandom());
                    break;
                }
                case 4: {
                    this.fCipher.init(2, key, KWAES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    if (bb.length % 8 > 0) {
                        throw new InvalidKeyException("Encoded data not multiple of 8 bytes");
                    }
                    wrappedKey = new byte[PADS.length + bb.length];
                    System.arraycopy(PADS, 0, wrappedKey, 0, PADS.length);
                    System.arraycopy(bb, 0, wrappedKey, PADS.length, bb.length);
                    int n = bb.length / 8;
                    try {
                        if (n > 1) {
                            this.encryptBlocks(wrappedKey, n);
                            break;
                        }
                        this.processBlock(wrappedKey, 1);
                        break;
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (wrappedKey.length < 16) {
                        throw new InvalidKeyException("Data too short");
                    }
                    if (wrappedKey.length % 8 > 0) {
                        throw new InvalidKeyException("Data not multiple of 8 bytes");
                    }
                    byte[] bb1 = (byte[])wrappedKey.clone();
                    int n = bb1.length / 8 - 1;
                    try {
                        if (n > 1) {
                            this.decryptBlocks(bb1, n);
                        } else {
                            this.processBlock(bb1, 1);
                        }
                        if (this.arePadsChanged(bb1)) {
                            throw new BadPaddingException("Wrong pads");
                        }
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new RuntimeException(e);
                    }
                    byte[] bb2 = new byte[bb1.length - 8];
                    System.arraycopy(bb1, 8, bb2, 0, bb2.length);
                    KeyGenerationEngine kge = this.fEngineFactory.getKeyGenerationEngine(uri, type);
                    if (kge == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + uri + ", " + type);
                    }
                    key = kge.generateKey(bb2);
                    this.fEngineFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class AES256CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 32;

        public AES256CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 32) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static class AES192CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 24;

        public AES192CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 24) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static class AES128CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 16;

        public AES128CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 16) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static abstract class AESCBC
    extends EncryptionEngineImpl
    implements EncryptionEngineExtended {
        private static final String TRANS = "AES/CBC/NoPadding";
        private static final int BLOCK_SIZE = 16;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher;
        private boolean fFirstOutput;
        private int fLength;
        private byte[] fIv;
        private int fIndex;
        private boolean fInitialized;
        private byte[] fBuffer;
        private int fIndex2;

        protected AESCBC(Provider provider) throws NoSuchAlgorithmException {
            try {
                this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException(e.toString());
            }
            this.fIndex = -1;
            this.fIndex2 = -1;
        }

        private byte[] addIv(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                byte[] bb = this.fCipher.getIV();
                output2 = new byte[bb.length + output.length];
                System.arraycopy(bb, 0, output2, 0, bb.length);
                System.arraycopy(output, 0, output2, bb.length, output.length);
            } else {
                output2 = this.fCipher.getIV();
            }
            return output2;
        }

        private int removeIv(byte[] input, int off, int len) {
            int i = 16 - this.fIndex;
            if (i > len) {
                System.arraycopy(input, off, this.fIv, this.fIndex, len);
                this.fIndex += len;
                return len;
            }
            System.arraycopy(input, off, this.fIv, this.fIndex, i);
            try {
                this.fCipher.init(this.fOpMode, this.fKey, new IvParameterSpec(this.fIv), AESCBC.getRandom());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            this.fIndex = -1;
            this.fInitialized = true;
            return i;
        }

        private byte[] addPads(byte[] input, int off, int len) {
            int i = 16 - this.fLength % 16;
            int j = 0;
            if (input != null) {
                j += len;
            }
            byte[] input2 = new byte[j += i];
            if (input != null) {
                System.arraycopy(input, off, input2, 0, len);
            }
            for (int k = j - i; k < j; ++k) {
                input2[k] = (byte)i;
            }
            return input2;
        }

        private byte[] bufferData(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                if (16 - this.fIndex2 >= output.length) {
                    System.arraycopy(output, 0, this.fBuffer, this.fIndex2, output.length);
                    this.fIndex2 += output.length;
                } else {
                    byte[] bb = new byte[this.fIndex2 + output.length];
                    System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
                    System.arraycopy(output, 0, bb, this.fIndex2, output.length);
                    output2 = new byte[bb.length - 16];
                    System.arraycopy(bb, 0, output2, 0, output2.length);
                    System.arraycopy(bb, output2.length, this.fBuffer, 0, 16);
                    this.fIndex2 = 16;
                }
            }
            return output2;
        }

        private int bufferData2(byte[] output, int off, int count) {
            if (output != null && count > 0) {
                if (16 - this.fIndex2 >= count) {
                    System.arraycopy(output, off, this.fBuffer, this.fIndex2, count);
                    this.fIndex2 += count;
                    return 0;
                }
                if (this.fIndex2 > 0) {
                    System.arraycopy(this.fBuffer, 0, output, off, this.fIndex2);
                    count += this.fIndex2;
                }
                System.arraycopy(output, off + count - 16, this.fBuffer, 0, 16);
                this.fIndex2 = 16;
                return count -= 16;
            }
            return 0;
        }

        private byte[] removePads(byte[] output) throws BadPaddingException {
            int i = 0;
            if (output != null) {
                i += output.length;
            }
            byte[] bb = new byte[this.fIndex2 + i];
            System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
            if (output != null) {
                System.arraycopy(output, 0, bb, this.fIndex2, output.length);
            }
            this.fIndex2 = -1;
            if (bb.length == 0) {
                throw new BadPaddingException("No pads");
            }
            int j = bb[bb.length - 1] & 0xFF;
            if (j <= 0 || j > 16) {
                throw new BadPaddingException("Wrong pad: " + j);
            }
            if (j > bb.length) {
                throw new BadPaddingException("Fewer pads");
            }
            byte[] output2 = null;
            if (j < bb.length) {
                output2 = new byte[bb.length - j];
                System.arraycopy(bb, 0, output2, 0, output2.length);
            }
            return output2;
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            this.fInitialized = false;
            switch (opMode) {
                case 1: {
                    if (spec != null) {
                        this.fCipher.init(opMode, key, spec, AESCBC.getRandom());
                        this.fInitialized = true;
                    } else {
                        this.fCipher.init(opMode, key, AESCBC.getRandom());
                        this.fInitialized = true;
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    this.fIv = new byte[16];
                    this.fIndex = 0;
                    this.fBuffer = new byte[16];
                    this.fIndex2 = 0;
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    int elen = this.fCipher.getOutputSize(len);
                    int ivs = this.fCipher.getBlockSize();
                    byte[] iv = this.fCipher.getIV();
                    output = this.fCipher.update(input, off, len);
                    byte[] iv2 = this.fCipher.getIV();
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                        this.fFirstOutput = false;
                    }
                    this.fLength += len;
                    break;
                }
                case 2: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (!this.fInitialized) {
                        int count = this.removeIv(input, off, len);
                        off += count;
                        len -= count;
                    }
                    if (!this.fInitialized) break;
                    output = this.fCipher.update(input, off, len);
                    output = this.bufferData(output);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return output;
        }

        public int update(byte[] input, int off, int len, byte[] obuf, int obufoff) throws ShortBufferException {
            if (input == null) {
                throw new NullPointerException("Data not specified");
            }
            if (obuf == null) {
                throw new NullPointerException("Output buffer is null");
            }
            int count = 0;
            switch (this.fOpMode) {
                case 1: {
                    if (this.fFirstOutput) {
                        byte[] initialVector = this.fCipher.getIV();
                        System.arraycopy(initialVector, 0, obuf, obufoff + count, initialVector.length);
                        count += initialVector.length;
                        this.fFirstOutput = false;
                    }
                    count += this.fCipher.update(input, off, len, obuf, obufoff + count);
                    this.fLength += len;
                    break;
                }
                case 2: {
                    if (!this.fInitialized) {
                        int c = this.removeIv(input, off, len);
                        off += c;
                        len -= c;
                    }
                    if (!this.fInitialized || len <= 0) break;
                    count = this.fCipher.update(input, off, len, obuf, obufoff + this.fIndex2);
                    count = this.bufferData2(obuf, obufoff, count);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return count;
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input != null) {
                        this.fLength += len;
                    }
                    input = this.addPads(input, off, len);
                    output = this.fCipher.doFinal(input);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    if (input != null) {
                        if (!this.fInitialized) {
                            int count = this.removeIv(input, off, len);
                            off += count;
                            len -= count;
                        }
                        output = this.fCipher.doFinal(input, off, len);
                    } else {
                        output = this.fCipher.doFinal();
                    }
                    output = this.removePads(output);
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fIndex2 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return output;
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$AESCBC.wrap(Key)");
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$AESCBC.unwrap(byte[], String, String)");
        }

        public int getOutputSize(int inputSize) {
            int outputSize = inputSize;
            if (this.fInitialized) {
                outputSize = this.fCipher.getOutputSize(inputSize);
            }
            switch (this.fOpMode) {
                case 1: {
                    if (!this.fFirstOutput) break;
                    outputSize += this.fCipher.getBlockSize();
                    break;
                }
                case 2: {
                    if (this.fInitialized) break;
                    outputSize += this.fCipher.getBlockSize();
                }
            }
            if (outputSize < 48) {
                outputSize = 48;
            }
            return outputSize;
        }
    }

    public static class KWTripleDES
    extends EncryptionEngineImpl {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher0;
        private Cipher fCipher1;

        public KWTripleDES(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            this.fEngineFactory = factory;
            try {
                if (provider != null) {
                    this.fCipher0 = Cipher.getInstance(TRANS, provider);
                    this.fCipher1 = Cipher.getInstance(TRANS, provider);
                } else {
                    this.fCipher0 = Cipher.getInstance(TRANS);
                    this.fCipher1 = Cipher.getInstance(TRANS);
                }
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }

        private byte[] addChecksum(byte[] wk) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            MessageDigest md = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] bb = md.digest(wk);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", md);
            byte[] wkcks = new byte[wk.length + 8];
            System.arraycopy(wk, 0, wkcks, 0, wk.length);
            System.arraycopy(bb, 0, wkcks, wk.length, 8);
            return wkcks;
        }

        private byte[] addIv(byte[] temp1) {
            byte[] bb = this.fCipher0.getIV();
            byte[] temp2 = new byte[temp1.length + 8];
            System.arraycopy(bb, 0, temp2, 0, 8);
            System.arraycopy(temp1, 0, temp2, 8, temp1.length);
            return temp2;
        }

        private byte[] reverse(byte[] temp2) {
            byte[] temp3 = new byte[temp2.length];
            for (int i = 0; i < temp2.length; ++i) {
                temp3[temp3.length - i - 1] = temp2[i];
            }
            return temp3;
        }

        private byte[] removeIv(byte[] temp2) {
            byte[] bb = new byte[8];
            byte[] temp1 = new byte[temp2.length - 8];
            System.arraycopy(temp2, 0, bb, 0, 8);
            System.arraycopy(temp2, 8, temp1, 0, temp1.length);
            try {
                this.fCipher0.init(2, this.fKey, new IvParameterSpec(bb), KWTripleDES.getRandom());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            return temp1;
        }

        private byte[] removeChecksum(byte[] wkcks) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] wk = new byte[wkcks.length - 8];
            byte[] bb = new byte[8];
            System.arraycopy(wkcks, 0, wk, 0, wk.length);
            System.arraycopy(wkcks, wk.length, bb, 0, 8);
            MessageDigest md = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] bb1 = md.digest(wk);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", md);
            for (int i = 0; i < 8; ++i) {
                if (bb[i] == bb1[i]) continue;
                throw new InvalidKeyException("Wrong checksum");
            }
            return wk;
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher0.init(1, key, KWTripleDES.getRandom());
                    this.fCipher1.init(1, key, new IvParameterSpec(IV), KWTripleDES.getRandom());
                    break;
                }
                case 4: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher1.init(2, key, new IvParameterSpec(IV), KWTripleDES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    try {
                        bb = this.addChecksum(bb);
                        bb = this.fCipher0.doFinal(bb);
                        bb = this.addIv(bb);
                        bb = this.reverse(bb);
                        wrappedKey = this.fCipher1.doFinal(bb);
                        break;
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    KeyGenerationEngine kge = this.fEngineFactory.getKeyGenerationEngine(uri, type);
                    if (kge == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + uri + ", " + type);
                    }
                    if (wrappedKey.length != kge.getKeySize() + 16) {
                        this.fEngineFactory.releaseKeyGenerationEngine(kge);
                        throw new InvalidKeyException("Wrong length: " + wrappedKey.length);
                    }
                    byte[] bb = null;
                    try {
                        bb = this.fCipher1.doFinal(wrappedKey);
                        bb = this.reverse(bb);
                        bb = this.removeIv(bb);
                        bb = this.fCipher0.doFinal(bb);
                        bb = this.removeChecksum(bb);
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new RuntimeException(e);
                    }
                    key = kge.generateKey(bb);
                    this.fEngineFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class TripleDESCBC
    extends EncryptionEngineImpl {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher;
        private boolean fFirstOutput;
        private int fLength;
        private byte[] fIv;
        private int fIndex;
        private boolean fInitialized;
        private byte[] fBuffer;
        private int fIndex2;

        public TripleDESCBC(Provider provider) throws NoSuchAlgorithmException {
            try {
                this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
            this.fIndex = -1;
            this.fIndex2 = -1;
        }

        private byte[] addIv(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                byte[] bb = this.fCipher.getIV();
                output2 = new byte[bb.length + output.length];
                System.arraycopy(bb, 0, output2, 0, bb.length);
                System.arraycopy(output, 0, output2, bb.length, output.length);
            } else {
                output2 = this.fCipher.getIV();
            }
            return output2;
        }

        private byte[] removeIv(byte[] input, int off, int len) {
            int i = 8 - this.fIndex;
            byte[] input2 = null;
            if (i > len) {
                System.arraycopy(input, off, this.fIv, this.fIndex, len);
                this.fIndex += len;
                input2 = new byte[]{};
            } else {
                System.arraycopy(input, off, this.fIv, this.fIndex, i);
                if (this.fKey == null) {
                    throw new NullPointerException("Key not specified");
                }
                try {
                    this.fCipher.init(this.fOpMode, this.fKey, new IvParameterSpec(this.fIv), TripleDESCBC.getRandom());
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new RuntimeException(e);
                }
                catch (InvalidKeyException e) {
                    throw new RuntimeException(e);
                }
                this.fIndex = -1;
                this.fInitialized = true;
                input2 = new byte[len - i];
                System.arraycopy(input, off + i, input2, 0, input2.length);
            }
            return input2;
        }

        private byte[] addPads(byte[] input, int off, int len) {
            int i = 8 - this.fLength % 8;
            int j = 0;
            if (input != null) {
                j += len;
            }
            byte[] input2 = new byte[j += i];
            if (input != null) {
                System.arraycopy(input, off, input2, 0, len);
            }
            for (int k = j - i; k < j; ++k) {
                input2[k] = (byte)i;
            }
            return input2;
        }

        private byte[] bufferData(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                if (8 - this.fIndex2 >= output.length) {
                    System.arraycopy(output, 0, this.fBuffer, this.fIndex2, output.length);
                    this.fIndex2 += output.length;
                } else {
                    byte[] bb = new byte[this.fIndex2 + output.length];
                    System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
                    System.arraycopy(output, 0, bb, this.fIndex2, output.length);
                    output2 = new byte[bb.length - 8];
                    System.arraycopy(bb, 0, output2, 0, output2.length);
                    System.arraycopy(bb, output2.length, this.fBuffer, 0, 8);
                    this.fIndex2 = 8;
                }
            }
            return output2;
        }

        private byte[] removePads(byte[] output) throws BadPaddingException {
            int i = 0;
            if (output != null) {
                i += output.length;
            }
            byte[] bb = new byte[this.fIndex2 + i];
            System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
            if (output != null) {
                System.arraycopy(output, 0, bb, this.fIndex2, output.length);
            }
            this.fIndex2 = -1;
            if (bb.length == 0) {
                throw new BadPaddingException("No pads");
            }
            int j = bb[bb.length - 1] & 0xFF;
            if (j <= 0 || j > 8) {
                throw new BadPaddingException("Wrong pad: " + j);
            }
            if (j > bb.length) {
                throw new BadPaddingException("Fewer pads");
            }
            byte[] output2 = null;
            if (j < bb.length) {
                output2 = new byte[bb.length - j];
                System.arraycopy(bb, 0, output2, 0, output2.length);
            }
            return output2;
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    if (spec != null) {
                        this.fCipher.init(opMode, key, spec, TripleDESCBC.getRandom());
                    } else {
                        this.fCipher.init(opMode, key, TripleDESCBC.getRandom());
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    this.fIv = new byte[8];
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fBuffer = new byte[8];
                    this.fIndex2 = 0;
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    output = this.fCipher.update(input, off, len);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                        this.fFirstOutput = false;
                    }
                    this.fLength += len;
                    break;
                }
                case 2: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (!this.fInitialized) {
                        input = this.removeIv(input, off, len);
                        off = 0;
                        len = input.length;
                    }
                    if (!this.fInitialized) break;
                    output = this.fCipher.update(input, off, len);
                    output = this.bufferData(output);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return output;
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input != null) {
                        this.fLength += len;
                    }
                    input = this.addPads(input, off, len);
                    output = this.fCipher.doFinal(input);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    if (input != null) {
                        if (!this.fInitialized) {
                            input = this.removeIv(input, off, len);
                            off = 0;
                            len = input.length;
                        }
                        output = this.fCipher.doFinal(input, off, len);
                    } else {
                        output = this.fCipher.doFinal();
                    }
                    output = this.removePads(output);
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fIndex2 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return output;
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$TripleDESCBC.wrap(Key)");
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$TripleDESCBC.unwrap(byte[], String, String)");
        }
    }

    public static class HWC_KWTripleDES
    extends EncryptionEngineImpl {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher0;
        private Cipher fCipher1;

        public HWC_KWTripleDES(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            this.fEngineFactory = factory;
            try {
                if (provider != null) {
                    this.fCipher0 = Cipher.getInstance(TRANS, provider);
                    this.fCipher1 = Cipher.getInstance(TRANS, provider);
                } else {
                    this.fCipher0 = Cipher.getInstance(TRANS);
                    this.fCipher1 = Cipher.getInstance(TRANS);
                }
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }

        private byte[] addChecksum(byte[] wk) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            MessageDigest md = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] bb = md.digest(wk);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", md);
            byte[] wkcks = new byte[wk.length + 8];
            System.arraycopy(wk, 0, wkcks, 0, wk.length);
            System.arraycopy(bb, 0, wkcks, wk.length, 8);
            return wkcks;
        }

        private byte[] addIv(byte[] temp1) {
            byte[] bb = this.fCipher0.getIV();
            byte[] temp2 = new byte[temp1.length + 8];
            System.arraycopy(bb, 0, temp2, 0, 8);
            System.arraycopy(temp1, 0, temp2, 8, temp1.length);
            return temp2;
        }

        private byte[] reverse(byte[] temp2) {
            byte[] temp3 = new byte[temp2.length];
            for (int i = 0; i < temp2.length; ++i) {
                temp3[temp3.length - i - 1] = temp2[i];
            }
            return temp3;
        }

        private byte[] removeIv(byte[] temp2) {
            byte[] bb = new byte[8];
            byte[] temp1 = new byte[temp2.length - 8];
            System.arraycopy(temp2, 0, bb, 0, 8);
            System.arraycopy(temp2, 8, temp1, 0, temp1.length);
            try {
                this.fCipher0.init(2, this.fKey, new IvParameterSpec(bb), HWC_KWTripleDES.getRandom());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            return temp1;
        }

        private byte[] removeChecksum(byte[] wkcks) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] wk = new byte[wkcks.length - 8];
            byte[] bb = new byte[8];
            System.arraycopy(wkcks, 0, wk, 0, wk.length);
            System.arraycopy(wkcks, wk.length, bb, 0, 8);
            MessageDigest md = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] bb1 = md.digest(wk);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", md);
            for (int i = 0; i < 8; ++i) {
                if (bb[i] == bb1[i]) continue;
                throw new InvalidKeyException("Wrong checksum");
            }
            return wk;
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                case 3: {
                    if (key != null) break;
                    throw new NullPointerException("Key not specified");
                }
                case 4: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher1.init(2, key, new IvParameterSpec(IV), HWC_KWTripleDES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    try {
                        try {
                            this.fCipher0.init(1, this.fKey, HWC_KWTripleDES.getRandom());
                        }
                        catch (InvalidKeyException e) {
                            throw new RuntimeException(e);
                        }
                        bb = this.addChecksum(bb);
                        bb = this.fCipher0.doFinal(bb);
                        bb = this.addIv(bb);
                        bb = this.reverse(bb);
                        this.fCipher1.init(1, this.fKey, new IvParameterSpec(IV), HWC_KWTripleDES.getRandom());
                        wrappedKey = this.fCipher1.doFinal(bb);
                        break;
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    KeyGenerationEngine kge = this.fEngineFactory.getKeyGenerationEngine(uri, type);
                    if (kge == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + uri + ", " + type);
                    }
                    if (wrappedKey.length != kge.getKeySize() + 16) {
                        this.fEngineFactory.releaseKeyGenerationEngine(kge);
                        throw new InvalidKeyException("Wrong length: " + wrappedKey.length);
                    }
                    byte[] bb = null;
                    try {
                        bb = this.fCipher1.doFinal(wrappedKey);
                        bb = this.reverse(bb);
                        bb = this.removeIv(bb);
                        bb = this.fCipher0.doFinal(bb);
                        bb = this.removeChecksum(bb);
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new RuntimeException(e);
                    }
                    key = kge.generateKey(bb);
                    this.fEngineFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class HWC_KWAES256
    extends HWC_KWAES {
        private static final int KEY_LENGTH = 32;

        public HWC_KWAES256(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 32) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static class HWC_KWAES192
    extends HWC_KWAES {
        private static final int KEY_LENGTH = 24;

        public HWC_KWAES192(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 24) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static class HWC_KWAES128
    extends HWC_KWAES {
        private static final int KEY_LENGTH = 16;

        public HWC_KWAES128(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            super(provider, factory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (bb.length != 16) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, spec);
        }
    }

    public static abstract class HWC_KWAES
    extends EncryptionEngineImpl {
        private static final String TRANS = "AES/ECB/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private static final byte[] PADS = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Cipher fCipher;
        private Provider fProvider;
        private Key fKey;
        private boolean cipher_init = false;
        private boolean debug = false;

        protected HWC_KWAES(Provider provider, EngineFactory factory) throws NoSuchAlgorithmException {
            this.fEngineFactory = factory;
            this.fProvider = provider;
            try {
                if (provider != null) {
                    if (this.debug) {
                        System.out.println("HWC: provider name is :" + provider.getName());
                    }
                    this.fCipher = Cipher.getInstance(TRANS, provider);
                } else {
                    this.fCipher = Cipher.getInstance(TRANS);
                }
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException(e.toString());
            }
        }

        private void encryptBlocks(byte[] c, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int j = 0; j <= 5; ++j) {
                for (int i = 1; i <= n; ++i) {
                    int t = i + j * n;
                    this.processBlock(c, i);
                    this.cipher_init = false;
                    this.xorBlock(c, t);
                }
            }
        }

        private void decryptBlocks(byte[] p, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int j = 5; j >= 0; --j) {
                for (int i = n; i >= 1; --i) {
                    int t = i + j * n;
                    this.xorBlock(p, t);
                    this.processBlock(p, i);
                    this.cipher_init = false;
                }
            }
        }

        private void processBlock(byte[] bb, int i) throws BadPaddingException, IllegalBlockSizeException {
            byte[] bb2 = new byte[16];
            System.arraycopy(bb, 0, bb2, 0, 8);
            System.arraycopy(bb, 8 * i, bb2, 8, 8);
            try {
                if (!this.cipher_init) {
                    switch (this.fOpMode) {
                        case 4: {
                            this.fCipher.init(2, this.fKey, HWC_KWAES.getRandom());
                            break;
                        }
                        case 3: {
                            this.fCipher.init(1, this.fKey, HWC_KWAES.getRandom());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operation mode: " + this.fOpMode);
                        }
                    }
                }
                bb2 = this.fCipher.doFinal(bb2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            System.arraycopy(bb2, 0, bb, 0, 8);
            System.arraycopy(bb2, 8, bb, 8 * i, 8);
        }

        private void xorBlock(byte[] bb, int t) {
            byte[] bb2 = BigInteger.valueOf(t).toByteArray();
            for (int i = 0; i < 8; ++i) {
                int j = i - 8 + bb2.length;
                int k = 0;
                if (j >= 0) {
                    k = bb2[j];
                }
                bb[i] = (byte)(k ^= bb[i]);
            }
        }

        private boolean arePadsChanged(byte[] p) {
            boolean changed = false;
            for (int i = 0; !changed && i < PADS.length; ++i) {
                if (p[i] == PADS[i]) continue;
                changed = true;
            }
            return changed;
        }

        public void init(int opMode, Key key, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                case 3: {
                    this.fCipher.init(1, key, HWC_KWAES.getRandom());
                    this.cipher_init = true;
                    break;
                }
                case 4: {
                    this.fCipher.init(2, key, HWC_KWAES.getRandom());
                    this.cipher_init = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] input, int off, int len) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    if (bb.length % 8 > 0) {
                        throw new InvalidKeyException("Encoded data not multiple of 8 bytes");
                    }
                    wrappedKey = new byte[PADS.length + bb.length];
                    System.arraycopy(PADS, 0, wrappedKey, 0, PADS.length);
                    System.arraycopy(bb, 0, wrappedKey, PADS.length, bb.length);
                    int n = bb.length / 8;
                    try {
                        if (n > 1) {
                            this.encryptBlocks(wrappedKey, n);
                            break;
                        }
                        this.processBlock(wrappedKey, 1);
                        break;
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, String uri, String type) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (wrappedKey.length < 16) {
                        throw new InvalidKeyException("Data too short");
                    }
                    if (wrappedKey.length % 8 > 0) {
                        throw new InvalidKeyException("Data not multiple of 8 bytes");
                    }
                    byte[] bb1 = (byte[])wrappedKey.clone();
                    int n = bb1.length / 8 - 1;
                    try {
                        if (n > 1) {
                            this.decryptBlocks(bb1, n);
                        } else {
                            this.processBlock(bb1, 1);
                        }
                        if (this.arePadsChanged(bb1)) {
                            throw new BadPaddingException("Wrong pads");
                        }
                    }
                    catch (BadPaddingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new RuntimeException(e);
                    }
                    byte[] bb2 = new byte[bb1.length - 8];
                    System.arraycopy(bb1, 8, bb2, 0, bb2.length);
                    KeyGenerationEngine kge = this.fEngineFactory.getKeyGenerationEngine(uri, type);
                    if (kge == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + uri + ", " + type);
                    }
                    key = kge.generateKey(bb2);
                    this.fEngineFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }
}

