/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.util.ObjectFactory;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.PseudoIOException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class BufferedEncryptionOutputStream
extends FilterOutputStream {
    private static final BufferedEncryptionOutputStreamFactory FACTORY = new BufferedEncryptionOutputStreamFactory();
    protected static final int INPUT_BUF_INITIAL_CAPACITY = 1024;
    protected static final int OUTPUT_BUF_INITIAL_CAPACITY = 0;
    protected static final double EXTRA_OUTPUT_BUF_RATE = 1.2;
    private EncryptionEngineExtended fEncryptionEngine;
    private AlgorithmFactory fAlgorithmFactory;
    private byte[] fInputBuffer;
    private byte[] fOutputBuffer;
    private boolean fDoneFinal;
    private int fInputBufferCount;

    public static final BufferedEncryptionOutputStreamFactory getFactory() {
        return FACTORY;
    }

    public BufferedEncryptionOutputStream() {
        super(null);
        BufferedEncryptionOutputStream eos = FACTORY.getObjectWithoutCreateNewInstance();
        if (eos != null) {
            this.fOutputBuffer = eos.fOutputBuffer;
            this.fInputBuffer = eos.fInputBuffer;
        } else {
            this.fOutputBuffer = new byte[0];
            this.fInputBuffer = new byte[1024];
        }
    }

    public BufferedEncryptionOutputStream(OutputStream out, EncryptionEngineExtended engine2, AlgorithmFactory factory) {
        this();
        this.init(out, engine2, factory);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void init(OutputStream out, EncryptionEngineExtended engine2, AlgorithmFactory factory) {
        this.out = out;
        if (out == null) {
            throw new NullPointerException("OutputStream is not specified");
        }
        this.fEncryptionEngine = engine2;
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        this.fAlgorithmFactory = factory;
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
        this.fDoneFinal = false;
        this.fInputBufferCount = 0;
    }

    public void reset() {
        if (!this.fDoneFinal) {
            this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
        }
        this.out = null;
        this.fEncryptionEngine = null;
        this.fAlgorithmFactory = null;
    }

    private void ensureOutputBuffer(int size) {
        int outputLength = this.fEncryptionEngine.getOutputSize(size);
        if (this.fOutputBuffer.length < outputLength) {
            outputLength = (int)((double)outputLength * 1.2);
            this.fOutputBuffer = new byte[outputLength];
        }
    }

    protected void updateEngine() throws IOException {
        this.updateEngine(this.fInputBuffer, 0, this.fInputBufferCount);
        this.fInputBufferCount = 0;
    }

    protected void updateEngine(byte[] b, int off, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        this.ensureOutputBuffer(length);
        int count = 0;
        try {
            count = this.fEncryptionEngine.update(b, off, length, this.fOutputBuffer, 0);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        if (count > 0) {
            this.out.write(this.fOutputBuffer, 0, count);
        }
    }

    public void doFinal() throws IOException {
        if (this.fInputBufferCount > 0) {
            this.doFinal(this.fInputBuffer, 0, this.fInputBufferCount);
        } else {
            this.doFinal(null, 0, 0);
        }
    }

    protected void doFinal(byte[] b) throws IOException {
        this.doFinal(b, 0, b.length);
    }

    protected void doFinal(byte[] b, int off, int len) throws IOException {
        byte[] o = null;
        try {
            block7: {
                try {
                    if (b != null) {
                        o = this.fEncryptionEngine.doFinal(b, off, len);
                        break block7;
                    }
                    o = this.fEncryptionEngine.doFinal();
                }
                catch (BadPaddingException e) {
                    throw new PseudoIOException(e);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PseudoIOException(e);
                }
            }
            Object var7_5 = null;
            this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
            this.fDoneFinal = true;
            throw throwable;
        }
        this.fDoneFinal = true;
        if (o != null && o.length > 0) {
            this.out.write(o, 0, o.length);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int inputBufferRemainingSize;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.fInputBufferCount >= this.fInputBuffer.length) {
            this.updateEngine();
        }
        if (this.fInputBufferCount > 0 && len >= (inputBufferRemainingSize = this.fInputBuffer.length - this.fInputBufferCount)) {
            System.arraycopy(b, off, this.fInputBuffer, this.fInputBufferCount, inputBufferRemainingSize);
            this.fInputBufferCount = this.fInputBuffer.length;
            this.updateEngine();
            off += inputBufferRemainingSize;
            len -= inputBufferRemainingSize;
        }
        while (len > this.fInputBuffer.length) {
            this.updateEngine(b, off, this.fInputBuffer.length);
            off += this.fInputBuffer.length;
            len -= this.fInputBuffer.length;
        }
        if (len > 0) {
            System.arraycopy(b, off, this.fInputBuffer, this.fInputBufferCount, len);
            this.fInputBufferCount += len;
        }
    }

    public void write(int b) throws IOException {
        if (this.fInputBufferCount >= this.fInputBuffer.length) {
            this.updateEngine();
        }
        this.fInputBuffer[this.fInputBufferCount++] = (byte)b;
    }

    public void flush() throws IOException {
        if (!this.fDoneFinal) {
            this.updateEngine();
        }
    }

    public void close() throws IOException {
        if (!this.fDoneFinal) {
            this.doFinal();
        }
        super.close();
        BufferedEncryptionOutputStream.getFactory().releaseObject(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BufferedEncryptionOutputStreamFactory
    extends ObjectFactory<BufferedEncryptionOutputStream> {
        private BufferedEncryptionOutputStreamFactory() {
        }

        @Override
        protected BufferedEncryptionOutputStream createNewInstance() {
            return new BufferedEncryptionOutputStream();
        }

        @Override
        protected void reset(BufferedEncryptionOutputStream eos) {
            eos.reset();
        }

        protected BufferedEncryptionOutputStream getObjectWithoutCreateNewInstance() {
            return (BufferedEncryptionOutputStream)this.pool.get();
        }
    }
}

