/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.util;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.pkcs11.PKCS11Object;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;

public class HWKeyCache {
    private static final boolean DEBUG = false;
    private static HWKeyCache s_theInstance;
    private static Provider _provider;
    private static HashMap fKey2TKey;
    private static HashMap fTKey2TTime;
    private static LinkedList fKey;
    private static Hashtable fAlg2Factory;
    private static int maxKeysOnCard;
    private static long entryRefresh;
    private static byte[] lock;
    private static boolean cacheSizeSet;

    private HWKeyCache() {
        fAlg2Factory = new Hashtable();
        fKey2TKey = new HashMap();
        fTKey2TTime = new HashMap();
        fKey = new LinkedList();
    }

    public void setScanParameters(long _entryRefreshHours) {
        entryRefresh = _entryRefreshHours * 3600000L;
        if (entryRefresh > 300000L) {
            entryRefresh -= 300000L;
        }
    }

    public static boolean isHWSigAlgorithm(String a) {
        boolean rc = false;
        if (a != null && (a.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || a.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1"))) {
            rc = true;
        }
        return rc;
    }

    public static boolean isHWEncAlgorithm(String a) {
        boolean rc = false;
        if (a != null && (a.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || a.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"))) {
            rc = true;
        }
        return rc;
    }

    public static HWKeyCache getInstance() {
        return s_theInstance;
    }

    public void setProvider(Provider provider, Integer hardwareCacheSize) {
        if (_provider == null && provider != null) {
            _provider = provider;
            maxKeysOnCard = hardwareCacheSize;
            try {
                fAlg2Factory.put("RSA", KeyFactory.getInstance("RSA", provider));
                fAlg2Factory.put("DSA", KeyFactory.getInstance("DSA", provider));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public static boolean cacheInitialized() {
        return _provider != null && maxKeysOnCard > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key generate(String endpointReference) throws Exception {
        Key _key = null;
        Long translatedTime = null;
        if (endpointReference == null) return _key;
        byte[] byArray = lock;
        synchronized (lock) {
            _key = (Key)fKey2TKey.get(endpointReference);
            if (_key != null && entryRefresh > 0L && ((translatedTime = (Long)fTKey2TTime.get(_key)) == null || System.currentTimeMillis() - translatedTime > entryRefresh)) {
                HWKeyCache.remove(endpointReference);
                return null;
            }
            if (_key == null) return _key;
            fKey.remove(endpointReference);
            fKey.addFirst(endpointReference);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return _key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGeneratedKey(String endpointReference, Key key) {
        if (endpointReference == null || key == null) return;
        byte[] byArray = lock;
        synchronized (lock) {
            fKey2TKey.put(endpointReference, key);
            fKey.addFirst(endpointReference);
            fTKey2TTime.put(key, new Long(System.currentTimeMillis()));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGeneratedKey(byte[] wrappedKey, Key key) {
        if (wrappedKey == null || key == null) return;
        byte[] byArray = lock;
        synchronized (lock) {
            fKey2TKey.put(wrappedKey, key);
            fKey.addFirst(wrappedKey);
            fTKey2TTime.put(key, new Long(System.currentTimeMillis()));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key generate(byte[] wrappedKey) throws Exception {
        Key _key = null;
        Long translatedTime = null;
        if (wrappedKey == null) return _key;
        byte[] byArray = lock;
        synchronized (lock) {
            _key = (Key)fKey2TKey.get(wrappedKey);
            if (_key != null && entryRefresh > 0L && ((translatedTime = (Long)fTKey2TTime.get(_key)) == null || System.currentTimeMillis() - translatedTime > entryRefresh)) {
                HWKeyCache.remove(wrappedKey);
                return null;
            }
            if (_key == null) return _key;
            fKey.remove(wrappedKey);
            fKey.addFirst(wrappedKey);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return _key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Key translate(Key key) throws Exception {
        Key _key = null;
        Long translatedTime = null;
        if (!HWKeyCache.cacheInitialized()) {
            return _key;
        }
        if (key == null) {
            return _key;
        }
        byte[] byArray = lock;
        synchronized (lock) {
            _key = (Key)fKey2TKey.get(key);
            if (_key != null && entryRefresh > 0L && ((translatedTime = (Long)fTKey2TTime.get(_key)) == null || System.currentTimeMillis() - translatedTime > entryRefresh)) {
                HWKeyCache.remove(key);
                _key = null;
            }
            if (_key != null) {
                fKey.remove(key);
                fKey.addFirst(key);
            } else {
                KeyFactory kf = null;
                Throwable savedException = null;
                try {
                    if (fKey.size() >= maxKeysOnCard) {
                        HWKeyCache.reduceKeysOnCardPercent(75);
                    }
                    try {
                        kf = (KeyFactory)fAlg2Factory.get(key.getAlgorithm());
                        if (kf == null) {
                            String algorithm = key.getAlgorithm();
                            kf = KeyFactory.getInstance(algorithm, _provider);
                            fAlg2Factory.put(algorithm, kf);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        _key = kf.translateKey(key);
                        if (_key == null) {
                            // empty if block
                        }
                    }
                    catch (OutOfMemoryError e) {
                        if (!cacheSizeSet) {
                            HWKeyCache.setMaxKeysOnCardPercent(80);
                            HWKeyCache.reduceKeysOnCardPercent(75);
                        } else {
                            savedException = e;
                        }
                    }
                    catch (Exception e) {
                        savedException = e;
                    }
                    if (_key == null && savedException == null) {
                        try {
                            _key = kf.translateKey(key);
                            if (_key == null) {
                                // empty if block
                            }
                        }
                        catch (OutOfMemoryError e) {
                            savedException = e;
                        }
                        catch (Exception e) {
                            savedException = e;
                        }
                    }
                    if (_key == null) {
                        if (savedException == null) throw new Exception("Unable to translate key");
                        throw new Exception("Unable to translate key", savedException);
                    }
                    fKey2TKey.put(key, _key);
                    fKey.addFirst(key);
                    fTKey2TTime.put(_key, new Long(System.currentTimeMillis()));
                }
                catch (Exception e) {
                    _key = null;
                    throw e;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return _key;
        }
    }

    private static boolean remove(Key key) {
        boolean rc = false;
        fKey.remove(key);
        PKCS11Key _key = (PKCS11Key)fKey2TKey.remove(key);
        fTKey2TTime.remove(_key);
        if (_key != null) {
            try {
                PKCS11Object obj = _key.getObject();
                if (obj != null) {
                    obj.destroy();
                }
                rc = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rc;
    }

    private static void remove(String endpointReference) {
        fKey.remove(endpointReference);
        fTKey2TTime.remove(endpointReference);
    }

    private static void remove(byte[] wrappedKey) {
        fKey.remove(wrappedKey);
        fTKey2TTime.remove(wrappedKey);
    }

    private static boolean removeLast() {
        boolean rc = false;
        Object lastKey = fKey.getLast();
        if (lastKey instanceof Key) {
            rc = HWKeyCache.remove((Key)lastKey);
        } else if (lastKey instanceof String) {
            HWKeyCache.remove((String)lastKey);
            rc = true;
        } else if (lastKey instanceof byte[]) {
            HWKeyCache.remove((byte[])lastKey);
            rc = true;
        }
        return rc;
    }

    private static boolean removeLast(int n) {
        boolean rc = false;
        if (n > fKey.size()) {
            n = fKey.size();
        } else {
            for (int i = 0; i < n && (rc = HWKeyCache.removeLast()); ++i) {
            }
        }
        return rc;
    }

    private static boolean reduceKeysOnCardPercent(int percent) {
        int n = fKey.size() - maxKeysOnCard * percent / 100;
        boolean rc = HWKeyCache.removeLast(n);
        return rc;
    }

    private static int setMaxKeysOnCardPercent(int percent) {
        maxKeysOnCard = fKey.size() * percent / 100;
        cacheSizeSet = true;
        return maxKeysOnCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeAllEntries() {
        if (!HWKeyCache.cacheInitialized()) return;
        byte[] byArray = lock;
        synchronized (lock) {
            HWKeyCache.reduceKeysOnCardPercent(0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setCapacityReached() {
        if (!HWKeyCache.cacheInitialized() || cacheSizeSet) return;
        byte[] byArray = lock;
        synchronized (lock) {
            HWKeyCache.setMaxKeysOnCardPercent(80);
            HWKeyCache.reduceKeysOnCardPercent(75);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        _provider = null;
        fKey2TKey = null;
        fTKey2TTime = null;
        fKey = null;
        fAlg2Factory = null;
        maxKeysOnCard = 0;
        entryRefresh = 0L;
        lock = new byte[0];
        cacheSizeSet = false;
        s_theInstance = new HWKeyCache();
    }
}

