/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.Enveloped;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XPathTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.jaxen.JaxenException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;

public class XPath2Transformer
extends Transform {
    private static final int FILTER_INVALID = -1;
    private static final int FILTER_UNION = 1;
    private static final int FILTER_SUBTRACT = 2;
    private static final int FILTER_INTERSECT = 3;
    private List xpathNodes;

    public String getURI() {
        return "http://www.w3.org/2002/06/xmldsig-filter2";
    }

    public void setParameter(OMNode node) {
        Vector<OMNode> v = new Vector<OMNode>();
        while (node != null) {
            v.addElement(node);
            node = DOMUtil.getNextElement(node);
        }
        this.xpathNodes = v;
    }

    public void transform(TransformContext context) throws TransformException {
        ArrayList nodeSet = context.getNodeset();
        int inputSize = nodeSet.size();
        if (inputSize <= 0) {
            return;
        }
        Object input = nodeSet.get(0);
        OMDocument doc = DOMUtil.getOwnerDocument((OMNode)input);
        int xpathSize = this.xpathNodes.size();
        List[] iterators = new List[xpathSize + 1];
        int[] filters = new int[xpathSize + 1];
        iterators[0] = Collections.singletonList(doc.getOMDocumentElement());
        filters[0] = 1;
        Iterator xiter = this.xpathNodes.iterator();
        int i = 1;
        while (xiter.hasNext()) {
            OMNode xpathNode = (OMNode)xiter.next();
            iterators[i] = XPath2Transformer.eval(xpathNode, doc, context);
            filters[i] = XPath2Transformer.getFilter(xpathNode);
            if (filters[i] == -1) {
                throw new TransformException("XPath element has no valid Filter attribute.");
            }
            ++i;
        }
        ArrayList output = new ArrayList();
        block1: for (int i2 = 0; i2 < inputSize; ++i2) {
            input = nodeSet.get(i2);
            for (int j = 0; j < filters.length; ++j) {
                if (filters[j] != 1 || !XPath2Transformer.contain(iterators[j], input)) continue;
                boolean z = true;
                for (int k = j + 1; k < filters.length; ++k) {
                    if (filters[k] == 1) continue;
                    if (filters[k] == 3) {
                        if (XPath2Transformer.contain(iterators[k], input)) continue;
                        z = false;
                        break;
                    }
                    if (filters[k] != 2 || !XPath2Transformer.contain(iterators[k], input)) continue;
                    z = false;
                    break;
                }
                if (!z) continue;
                output.add(input);
                continue block1;
            }
        }
        context.setContent(output);
    }

    private static int getFilter(OMNode xpath) {
        String v = ((OMElement)xpath).getAttributeValue(new QName("", "Filter"));
        if ("union".equals(v)) {
            return 1;
        }
        if ("subtract".equals(v)) {
            return 2;
        }
        if ("intersect".equals(v)) {
            return 3;
        }
        return -1;
    }

    private static boolean contain(List list, Object n) {
        for (OMNode m : list) {
            if (m != n && !Enveloped.isAncestorOrSelf(n, m)) continue;
            return true;
        }
        return false;
    }

    private static List eval(OMNode xp2, OMDocument start, TransformContext context) throws TransformException {
        Object xobj;
        try {
            XPath xpath = XPathTransformer.createXPath(xp2, context);
            xobj = xpath.evaluate(start.getOMDocumentElement());
            if (!(xobj instanceof List)) {
                throw new TransformException("The result of xpath evaluation for '" + DOMUtil.getStringValue(xp2) + "' is not a nodeset: " + xobj.toString());
            }
        }
        catch (TransformerException tre) {
            throw new TransformException("Error occured in an XPath evaluation: " + tre.getMessage());
        }
        catch (UnsupportedAxisException uae) {
            throw new TransformException("Error occured in an XPath evaluation: " + uae.getMessage());
        }
        catch (JaxenException je) {
            throw new TransformException("Error occured in an XPath evaluation: " + je.getMessage());
        }
        return (List)xobj;
    }

    public OMElement createTransformElement(OMFactory factory, IndentConfig iconf) {
        throw new RuntimeException("Not supported.");
    }
}

