/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class XMLDecryptionTransformer2
extends DecryptionTransformer {
    private static final boolean DEBUG = false;

    private ArrayList decryptXML(ArrayList nodeSet, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        Map m = this.decryptNodeSet(nodeSet, context);
        ByteArrayHolder bb = Canonicalizer.serializeSubset(nodeSet, false, m);
        OMDocument d = this.parseOctets(bb, context);
        return XPathCanonicalizer.toNodeset(d.getOMDocumentElement(), null, true);
    }

    private Map decryptNodeSet(ArrayList nodeSet, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        HashMap nodeSets = new HashMap();
        int l = nodeSet.size();
        for (int i = 0; i < l; ++i) {
            Object n = nodeSet.get(i);
            if (!(n instanceof OMElement) || !this.isEncryptedData((OMElement)n)) continue;
            ArrayList nl = this.decryptEncryptedData((OMElement)n, context);
            nodeSets.put(n, nl);
            Map m = this.decryptNodeSet(nl, context);
            nodeSets.putAll(m);
        }
        return nodeSets;
    }

    private ArrayList decryptEncryptedData(OMElement encData, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        byte[] bb = this.decryptEncryptedData(context.getSignatureContext(), encData);
        bb = DecryptionContext.wrapData(bb, encData);
        OMDocument d = this.parseOctets(new ByteArrayHolder(bb), context);
        OMElement e = d.getOMDocumentElement();
        return this.convertToNodeSet(e);
    }

    private byte[] decryptEncryptedData(SignatureContext scontext, OMElement encData) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        DecryptionContext dc = this.createDecryptionContext(scontext);
        dc.setEncryptedType(encData, null, null, null);
        dc.decrypt();
        String s = dc.getType();
        if (s == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!s.equals("http://www.w3.org/2001/04/xmlenc#Element") && !s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            throw new StructureException("Unknown type: " + s);
        }
        return Util.getBytes((InputStream)dc.getData());
    }

    private OMDocument parseOctets(ByteArrayHolder octets, TransformContext context) throws TransformException {
        context.setContent(octets, "UTF-8");
        return context.getDocument();
    }

    private ArrayList convertToNodeSet(OMElement parentOfApexNodes) {
        ArrayList nodeSet = new ArrayList();
        for (OMNode n = parentOfApexNodes.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            ArrayList nl = XPathCanonicalizer.toNodeset(n, null, true);
            int l = nl.size();
            for (int i = 0; i < l; ++i) {
                nodeSet.add(nl.get(i));
            }
        }
        return nodeSet;
    }

    public String getURI() {
        return "http://www.w3.org/2002/07/decrypt#XML";
    }

    public void transform(TransformContext context) throws TransformException {
        ArrayList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset(context.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        if (nl != null) {
            try {
                nl = this.decryptXML(nl, context);
            }
            catch (TransformException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exception e2;
                if (e instanceof XSignatureException && (e2 = ((XSignatureException)e).getException()) != null) {
                    e = e2;
                }
                throw new TransformException(e.getMessage());
            }
        }
        context.setContent(nl);
    }
}

