/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.xml.sax.SAXException;

public class XMLDecryptionTransformer
extends DecryptionTransformer {
    private static final boolean DEBUG = false;
    private boolean fReplace;
    private boolean fContinue;
    private Set fFailedEncryptedData = new HashSet();

    public void setReplaceEncryptedData(boolean replace) {
        this.fReplace = replace;
    }

    public void setContinueProcessing(boolean cont) {
        this.fContinue = cont;
    }

    private boolean containsEncryptedData(ArrayList nodeSet) throws StructureException {
        return this.getIndexOfEncryptedData(nodeSet) >= 0;
    }

    private ArrayList cloneNodeSet(ArrayList nodeSet, TransformContext context) throws TransformException {
        ByteArrayHolder bah = XPathCanonicalizer.serializeSubset(nodeSet, true);
        byte[] bb = DecryptionContext.wrapData(bah.toByteArray(), (OMNode)nodeSet.get(0));
        OMElement e = this.parseOctets(bb, context).getOMDocumentElement();
        return this.convertToNodeSet(e);
    }

    private ArrayList decryptIncludedNodes(ArrayList nodeSet, TransformContext context) throws Exception {
        while (true) {
            if (!this.isSingleRooted(nodeSet)) {
                throw new TransformException("Not single-rooted node-set");
            }
            int i = this.getIndexOfEncryptedData(nodeSet);
            if (i < 0) break;
            try {
                nodeSet = this.decrypt(nodeSet, i, context);
            }
            catch (Exception e) {
                if (!this.fContinue) {
                    throw e;
                }
                e = this.getInnerException(e);
                this.fFailedEncryptedData.add(nodeSet.get(i));
            }
        }
        return nodeSet;
    }

    private boolean isSingleRooted(ArrayList nodeSet) {
        boolean single = true;
        if (nodeSet.size() > 0) {
            Object obj = nodeSet.get(0);
            if (obj instanceof OMNamespace) {
                return false;
            }
            if (obj instanceof OMAttribute) {
                return false;
            }
            int l = nodeSet.size();
            for (int i = 1; i < l; ++i) {
                Object obj2 = nodeSet.get(i);
                if (!(obj2 instanceof OMNode) || DOMUtil.isDescendantNode((OMNode)obj2, (OMNode)obj)) continue;
                single = false;
                break;
            }
        }
        return single;
    }

    private int getIndexOfEncryptedData(ArrayList nodeSet) throws StructureException {
        int index = -1;
        int l = nodeSet.size();
        for (int i = 0; i < l; ++i) {
            Object obj = nodeSet.get(i);
            if (!(obj instanceof OMNode) || !this.isEncryptedData((OMNode)obj)) continue;
            index = i;
            break;
        }
        return index;
    }

    boolean isEncryptedData(OMNode node) throws StructureException {
        return super.isEncryptedData(node) && !this.fFailedEncryptedData.contains(node);
    }

    private ArrayList decrypt(ArrayList nodeSet, int index, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException, XMLStreamException {
        int i = this.getIndexOfNextNode(nodeSet, index);
        ArrayList nl = this.getSubNodeSet(nodeSet, index, i);
        nl = this.decryptEncryptedData(nl, index == 0, context);
        return this.replaceSubNodeSet(nodeSet, index, i, nl);
    }

    private int getIndexOfNextNode(ArrayList nodeSet, int index) {
        int index2;
        while (!(nodeSet.get(index) instanceof OMNode)) {
            ++index;
        }
        OMNode n = (OMNode)nodeSet.get(index);
        int l = nodeSet.size();
        for (index2 = index + 1; index2 < l && (!(nodeSet.get(index2) instanceof OMNode) || DOMUtil.isDescendantNode((OMNode)nodeSet.get(index2), n)); ++index2) {
        }
        return index2;
    }

    private ArrayList getSubNodeSet(ArrayList nodeSet, int start, int end) {
        ArrayList nodeSet2 = new ArrayList();
        for (int i = start; i < end; ++i) {
            nodeSet2.add(nodeSet.get(i));
        }
        return nodeSet2;
    }

    private ArrayList decryptEncryptedData(ArrayList nodeSet, boolean firstNode, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException, XMLStreamException {
        ByteArrayHolder bah = XPathCanonicalizer.serializeSubset(nodeSet, false);
        byte[] bb = this.decryptEncryptedData(context.getSignatureContext(), bah, firstNode);
        bb = DecryptionContext.wrapData(bb, (OMNode)nodeSet.get(0));
        OMElement e = this.parseOctets(bb, context).getOMDocumentElement();
        e = e.cloneOMElement();
        return this.convertToNodeSet(e);
    }

    private byte[] decryptEncryptedData(SignatureContext scontext, ByteArrayHolder encData, boolean firstNode) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, XSignatureException, XMLStreamException {
        DecryptionContext dc = this.createDecryptionContext(scontext);
        dc.setEncryptedType(new ByteArrayInputStream(encData.getValue(), encData.getOffset(), encData.getLength()), null, null, null);
        dc.decrypt();
        String s = dc.getType();
        if (s == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            if (s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (firstNode) {
                    throw new StructureException("Wrong type: " + s);
                }
            } else {
                throw new StructureException("Unknown type: " + s);
            }
        }
        return Util.getBytes((InputStream)dc.getData());
    }

    private OMDocument parseOctets(byte[] octets, TransformContext context) throws TransformException {
        context.setContent(octets, "UTF-8");
        return context.getDocument();
    }

    private ArrayList convertToNodeSet(OMNode parentOfApexNodes) {
        ArrayList nodeSet = new ArrayList();
        for (OMNode n = ((OMContainer)((Object)parentOfApexNodes)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            ArrayList nl = XPathCanonicalizer.toNodeset(n, null, true);
            int l = nl.size();
            for (int i = 0; i < l; ++i) {
                nodeSet.add(nl.get(i));
            }
        }
        return nodeSet;
    }

    private ArrayList replaceSubNodeSet(ArrayList nodeSet, int start, int end, ArrayList subNodeSet) {
        int i;
        ArrayList nodeSet2 = new ArrayList();
        for (i = 0; i < start; ++i) {
            nodeSet2.add(nodeSet.get(i));
        }
        int l = subNodeSet.size();
        for (i = 0; i < l; ++i) {
            nodeSet2.add(subNodeSet.get(i));
        }
        l = nodeSet.size();
        for (i = end; i < l; ++i) {
            nodeSet2.add(nodeSet.get(i));
        }
        OMNode c = (OMNode)nodeSet.get(start);
        OMContainer p = c.getParent();
        if (p != null) {
            OMNode c1 = (OMNode)subNodeSet.get(0);
            OMNode c2 = c1.getNextOMSibling();
            c.insertSiblingBefore(c1);
            c.detach();
            c = c1.getNextOMSibling();
            c1 = c2;
            while (c1 != null) {
                c2 = c1.getNextOMSibling();
                if (c == null) {
                    p.addChild(c1);
                } else {
                    c.insertSiblingBefore(c1);
                }
                c1 = c2;
            }
        }
        return nodeSet2;
    }

    private Exception getInnerException(Exception exc) {
        Exception e;
        if (exc instanceof SAXException) {
            Exception e2 = ((SAXException)exc).getException();
            if (e2 != null) {
                exc = e2;
            }
        } else if (exc instanceof XSignatureException && (e = ((XSignatureException)exc).getException()) != null) {
            exc = e;
        }
        return exc;
    }

    public String getURI() {
        return "http://www.w3.org/2001/04/decrypt#";
    }

    public void transform(TransformContext context) throws TransformException {
        ArrayList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset(context.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        if (nl != null) {
            if (!this.isSingleRooted(nl)) {
                throw new TransformException("Not single-rooted node-set");
            }
            try {
                if (this.containsEncryptedData(nl)) {
                    if (!this.fReplace) {
                        nl = this.cloneNodeSet(nl, context);
                    }
                    nl = this.decryptIncludedNodes(nl, context);
                }
            }
            catch (TransformException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e = this.getInnerException(e);
                throw new TransformException(e.getMessage());
            }
        }
        context.setContent(nl);
    }
}

