/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairStack;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectC14NWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.ExclusiveCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusiveC11r
extends Transform
implements Canonicalizer {
    private static final TraceComponent tc = Tr.register(ExclusiveC11r.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    boolean wc = false;
    Hashtable prefixList = null;
    public static final String NS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final javax.xml.namespace.QName PREFIX_LIST_Q = new javax.xml.namespace.QName("", "PrefixList");

    @Override
    public void setParameter(OMNode node) {
        if (node == null) {
            this.prefixList = null;
            return;
        }
        if (node.getType() != 1) {
            throw new IllegalArgumentException("The parameter must be an element.");
        }
        OMElement inp = (OMElement)node;
        if (inp.getNamespace().getName() == null || !inp.getNamespace().getName().equals(NS)) {
            throw new IllegalArgumentException("The parameter must belong to the 'http://www.w3.org/2001/10/xml-exc-c14n#' namespace.");
        }
        if (!inp.getLocalName().equals("InclusiveNamespaces")) {
            throw new IllegalArgumentException("The parameter element must be 'InclusiveNamespaces'.");
        }
        String v = inp.getAttributeValue(PREFIX_LIST_Q);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PrefixList of InclusiveNamespaces element = " + v);
        }
        this.prefixList = ExclusiveCanonicalizer.parsePrefixList(v);
    }

    @Override
    public void setParameter(WSSObject node) {
        if (node == null) {
            this.prefixList = null;
            return;
        }
        String v = ExclusiveC11r.getPrefixList(node);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PrefixList of InclusiveNamespaces element = " + v);
        }
        this.prefixList = ExclusiveCanonicalizer.parsePrefixList(v);
    }

    @Override
    public String getURI() {
        return NS;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        switch (context.getType()) {
            case 4: {
                ByteArrayHolder bah = this.canonicalizeWSSObject(context);
                context.setContent(bah, "UTF-8");
                break;
            }
            case 0: 
            case 1: {
                ByteArrayHolder result = ExclusiveCanonicalizer.serializeAll(this.prefixList, context.getDocument(), this.wc);
                context.setContent(result, "UTF-8");
                break;
            }
            case 3: {
                ByteArrayHolder result = ExclusiveCanonicalizer.serializeSubset(this.prefixList, context.getNode(), this.wc);
                context.setContent(result, "UTF-8");
                break;
            }
            case 2: {
                ByteArrayHolder result = ExclusiveCanonicalizer.serializeSubset(this.prefixList, context.getNodeset(), this.wc);
                context.setContent(result, "UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + context.getType());
            }
        }
    }

    @Override
    public void canonicalize(OMNode node, OutputStream stream) throws IOException {
        WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
        wch.getProxyOutputStream().setOutputStream(stream);
        BufferedWriter wr = wch.getBufferedWriter();
        ExclusiveCanonicalizer.serializeSubset(this.prefixList, node, this.wc, (Writer)wr);
        ((Writer)wr).flush();
        WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
    }

    private ByteArrayHolder canonicalizeWSSObject(TransformContext context) throws TransformException {
        WSSObjectElement el = context.getWSSObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "canonicalizeWSSObject: prefixList (HashTable) = " + this.prefixList);
        }
        HashSet<String> inclusiveNSPrefixList = new HashSet<String>();
        if (this.prefixList != null && !this.prefixList.isEmpty()) {
            Enumeration keys = this.prefixList.keys();
            while (keys.hasMoreElements()) {
                String prefix = (String)keys.nextElement();
                inclusiveNSPrefixList.add(prefix);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "canonicalizeWSSObject:     Added prefix = " + prefix + " to HashSet");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "canonicalizeWSSObject: prefixList (HashSet) = " + inclusiveNSPrefixList);
        }
        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream();
        WSSObjectC14NWriter wSSObjectC14NWriter = new WSSObjectC14NWriter(baos);
        try {
            el.canonicalize(wSSObjectC14NWriter, new NamespacePrefixPairStack(), inclusiveNSPrefixList, true);
            wSSObjectC14NWriter.flush();
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            TransformException te = new TransformException(e.getMessage());
            te.initCause(e);
            throw te;
        }
        ByteArrayHolder result = baos.getByteArrayHolder();
        return result;
    }

    public static HashSet<String> parsePrefixList(String ssv) {
        HashSet<String> prefixList = null;
        if (ssv == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(ssv, " \t\r\n");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (prefixList == null) {
                prefixList = new HashSet<String>();
            }
            if (tok.equals("#default")) {
                tok = "";
            }
            prefixList.add(tok);
        }
        return prefixList;
    }

    public static String getPrefixList(WSSObject node) {
        if (node == null) {
            return null;
        }
        if (!(node instanceof WSSObjectElement)) {
            throw new IllegalArgumentException("The parameter must be a WSSObjectElement.");
        }
        WSSObjectElement inp = (WSSObjectElement)node;
        NamespacePrefixPair nspp = inp.getNamespace();
        String ns = nspp.getUri();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Namespace URI of InclusiveNamespaces element = " + ns);
        }
        if (ns == null || !ns.equals(NS)) {
            throw new IllegalArgumentException("The parameter must belong to the 'http://www.w3.org/2001/10/xml-exc-c14n#' namespace.");
        }
        QName qname = inp.getQName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "QName of InclusiveNamespaces element = " + qname);
        }
        if (qname == null || !"InclusiveNamespaces".equals(qname.getLocalName())) {
            throw new IllegalArgumentException("The parameter element must be 'InclusiveNamespaces'.");
        }
        VariablePartAttributeValue vPartAttr = WSSObjectUtils.getAttribute(inp, PREFIX_LIST_Q);
        String v = null;
        if (vPartAttr != null) {
            v = vPartAttr.toString();
        }
        return v;
    }
}

