/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Except;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public abstract class DecryptionTransformer
extends Transform {
    private static final boolean DEBUG = false;
    public static final String XML = "http://www.w3.org/2001/04/decrypt#";
    public static final String XML2 = "http://www.w3.org/2002/07/decrypt#XML";
    public static final String BINARY = "http://www.w3.org/2002/07/decrypt#Binary";
    public static final QName ID_Q = new QName("", "Id");
    private List fParameters = new ArrayList();
    private Set fExceptedIds;

    DecryptionTransformer() {
    }

    boolean isEncryptedData(OMNode node) throws StructureException {
        OMElement e;
        boolean encData = false;
        if (node.getType() == 1 && EncryptedData.isOfType(e = (OMElement)node)) {
            if (this.fExceptedIds == null) {
                this.setExceptedIds();
            }
            encData = !this.fExceptedIds.contains(e.getAttributeValue(ID_Q));
        }
        return encData;
    }

    private void setExceptedIds() throws StructureException {
        this.fExceptedIds = new HashSet();
        Iterator i = this.fParameters.iterator();
        while (i.hasNext()) {
            String s = ((Except)i.next()).getURI();
            if (s == null) {
                throw new StructureException("URI attribute not specified");
            }
            if (!(s = s.trim()).startsWith("#") || s.length() < 2) {
                throw new StructureException("Wrong URI: " + s);
            }
            s = s.substring(1);
            s = this.getId(s);
            this.fExceptedIds.add(s);
        }
    }

    private String getId(String xptr) {
        char c;
        String s;
        String id = xptr;
        if (xptr.startsWith("xpointer(") && xptr.endsWith(")") && (s = id.substring(9, xptr.length() - 1).trim()).startsWith("id(") && s.endsWith(")") && (s = s.substring(3, id.length() - 1).trim()).length() > 2 && ((c = s.charAt(0)) == '\"' || c == '\'') && c == s.charAt(s.length() - 1)) {
            id = s.substring(1, s.length() - 1);
        }
        return id;
    }

    DecryptionContext createDecryptionContext(SignatureContext scontext) {
        DecryptionContext context = new DecryptionContext();
        context.setAlgorithmFactory(scontext.getAlgorithmFactory());
        context.setEncryptedKeyRetriever(scontext.getEncryptedKeyRetriever());
        context.setEntityResolver(scontext.getEntityResolver());
        context.setIdResolver(scontext.getIDResolver());
        context.setKeyInfoResolver(scontext.getKeyInfoResolver());
        return context;
    }

    public void setParameter(OMNode node) {
        block4: for (OMNode n = node; n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement el = (OMElement)n;
                    if (!Except.isOfType(el)) continue block4;
                    Except ex = new Except(el);
                    this.fParameters.add(ex);
                    continue block4;
                }
                case 9: {
                    this.setParameter(((OMContainer)((Object)n)).getFirstOMChild());
                }
            }
        }
    }

    public OMElement createTransformElement(OMFactory factory) {
        OMElement trans = super.createTransformElement(factory);
        Iterator i = this.fParameters.iterator();
        while (i.hasNext()) {
            try {
                OMElement e = ((Except)i.next()).createElement(factory, trans);
                trans.addChild(e);
            }
            catch (StructureException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return trans;
    }
}

