/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.dsig.WSSObjectSignatureGenerator;
import com.ibm.ws.wssecurity.enc.WSSObjectEncryptionGenerator;
import com.ibm.ws.wssecurity.filter.C14NWriterFilter;
import com.ibm.ws.wssecurity.filter.C14NWriterFilterForSOAPBody;
import com.ibm.ws.wssecurity.filter.C14NWriterFilterForSOAPBodyFactory;
import com.ibm.ws.wssecurity.filter.util.C14NFilterResultSet;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.XMLIdResolver;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.DigestMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Reference;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Transforms;
import com.ibm.ws.wssecurity.wssobject.impl.xc14n.InclusiveNamespaces;
import com.ibm.ws.wssecurity.wssobject.interfaces.BelongsToNamespace;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.NullURIHandler;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.URITransportSetter;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.BufferedEncryptionOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.impl.llom.util.NamespaceContextImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ReferenceProcessor {
    private static final TraceComponent tc = Tr.register(ReferenceProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ReferenceProcessor.class.getName();
    private static final boolean DEBUG = false;
    private static final QName TYPE_Q = new QName("", "Type");
    private static final QName URI_Q = new QName("", "URI");
    private static final QName ALGO_Q = new QName("", "Algorithm");
    public static long digestTime;

    private ReferenceProcessor() {
    }

    static ByteArrayHolder getTransformedOctets(SignatureContext scontext, OMDocument doc, OMElement reference, int refno) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException, SoapSecurityException {
        return ReferenceProcessor.getTransformedOctets(scontext, doc, reference, null, refno);
    }

    static ByteArrayHolder getTransformedOctets(SignatureContext scontext, OMDocument doc, ReferenceObject referenceObject, int refno) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException, SoapSecurityException {
        return ReferenceProcessor.getTransformedOctets(scontext, doc, null, referenceObject, refno);
    }

    private static ByteArrayHolder getTransformedOctets(SignatureContext scontext, OMDocument doc, OMElement reference, ReferenceObject referenceObject, int refno) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException, SoapSecurityException {
        String type;
        String uriref = null;
        TransformContext context = null;
        Vector decls = null;
        OMElement transforms = null;
        boolean useReferenceObject = false;
        if (referenceObject != null) {
            useReferenceObject = true;
            uriref = referenceObject.getUriRef();
            type = referenceObject.getType();
            transforms = referenceObject.getTransformsElement();
        } else if (reference != null) {
            transforms = XSignature.getFirstChild(reference, "Transforms");
            OMAttribute typeAttr = reference.getAttribute(TYPE_Q);
            type = typeAttr == null ? null : typeAttr.getAttributeValue();
            OMAttribute uriAttr = reference.getAttribute(URI_Q);
            if (uriAttr != null) {
                uriref = uriAttr.getAttributeValue();
            }
        } else {
            throw new TransformException("A Reference OMElement or ReferenceObject was not available.");
        }
        if (uriref == null) {
            NullURIHandler nuh = scontext.getNullURIHandler();
            if (nuh == null) {
                throw new TransformException("A Reference element has no URI attribute, but NullURIHandler is not registered.");
            }
            context = nuh.getContent();
            if (context.getType() == 3) {
                OMNode node = context.getNode();
                if (DOMUtil.getOwnerDocument(node) != null && DOMUtil.getOwnerDocument(node) == doc || node == doc) {
                    decls = ReferenceProcessor.fixTree(node, transforms);
                } else {
                    ReferenceProcessor.fixTree(node, transforms);
                }
            }
        } else {
            String targetURI;
            if (uriref == null) {
                uriref = "";
            }
            int idIndex = -1;
            if (uriref.length() > 0 && (idIndex = uriref.indexOf(35)) < 0 && transforms == null) {
                byte[] result = URITransportSetter.getContent(uriref, scontext.getEntityResolver(), null);
                if (scontext.getResourceShower() != null) {
                    scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), refno, uriref, type, result, null);
                }
                if (result != null && result.length > 0) {
                    return new ByteArrayHolder(result, 0, result.length);
                }
                return null;
            }
            String targetID = null;
            if (idIndex >= 0) {
                targetURI = uriref.substring(0, idIndex);
                targetID = uriref.substring(idIndex + 1);
            } else {
                targetURI = uriref;
            }
            if (targetURI.length() > 0 && targetID == null) {
                context = new TransformContext(scontext, targetURI);
            } else {
                OMDocument targetDoc = null;
                if (targetURI.length() == 0) {
                    targetDoc = doc;
                    decls = ReferenceProcessor.fixTree((OMNode)doc.getOMDocumentElement(), transforms);
                } else if (targetID != null) {
                    try {
                        InputSource src = null;
                        if (scontext.getEntityResolver() != null) {
                            src = scontext.getEntityResolver().resolveEntity(null, targetURI);
                        }
                        targetDoc = src == null ? scontext.parse(new InputSource(targetURI)) : scontext.parse(src);
                    }
                    catch (SAXException se) {
                        throw TransformException.create(se);
                    }
                    catch (XMLStreamException xse) {
                        throw TransformException.create(xse);
                    }
                }
                context = targetID != null ? ReferenceProcessor.idToInput(scontext, targetURI, targetDoc, targetID) : new TransformContext(scontext, targetDoc.getOMDocumentElement());
                if (scontext.isOnlySignEntireHeadersAndBody()) {
                    ReferenceProcessor.verifyOnlySignEntireHeadersAndBody(context);
                }
            }
        }
        byte[] tmpResult = null;
        if (scontext.isForSigning()) {
            tmpResult = ReferenceProcessor.getBodyC14NResultIfSourcedElement(context, doc, transforms);
        }
        if (tmpResult == null) {
            if (useReferenceObject) {
                ReferenceProcessor.transform(referenceObject, context, scontext.getAlgorithmFactory());
            } else {
                ReferenceProcessor.transform(reference, context, scontext.getAlgorithmFactory());
            }
        } else {
            scontext.lastIsDigestValue = true;
        }
        if (scontext.getResourceShower() != null) {
            ByteArrayHolder content = context.getOctets();
            if (tmpResult != null) {
                byte[] remark = "\"See C14NWriter trace ouput above for C14N of Body\"".getBytes();
                content = new ByteArrayHolder(remark, 0, remark.length);
            }
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), refno, uriref, type, content.getValue(), content.getOffset(), content.getLength(), context.getEncoding());
        }
        ByteArrayHolder result = context.getOctets();
        if (decls != null) {
            XPathUtil.cleanTree(decls);
        }
        return result;
    }

    private static void verifyOnlySignEntireHeadersAndBody(TransformContext context) throws SoapSecurityException {
        boolean isOnlySignEntireHeadersAndBody = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyOnlySignEntireHeadersAndBody( " + (context == null ? "" : context.getSignatureElement()) + ")");
        }
        QName nodeQName = null;
        QName containerQName = null;
        try {
            OMContainer parent;
            OMNode node = context.getNode();
            if (node != null) {
                nodeQName = ((OMElement)node).getQName();
            }
            if ((parent = node.getParent()) != null) {
                containerQName = ((OMElement)parent).getQName();
            }
            if (Constants.SOAP11_BODY.equals(nodeQName) || Constants.SOAP12_BODY.equals(nodeQName)) {
                isOnlySignEntireHeadersAndBody = true;
            } else if (Constants.WSSE_SECURITY.equals(containerQName) || Constants.WSSE11_SECURITY.equals(containerQName)) {
                isOnlySignEntireHeadersAndBody = true;
            } else if (Constants.SOAP11_HEADER.equals(containerQName) || Constants.SOAP12_HEADER.equals(containerQName)) {
                isOnlySignEntireHeadersAndBody = true;
            } else if (Constants.SOAP11_HEADER.equals(nodeQName) || Constants.SOAP12_HEADER.equals(nodeQName)) {
                isOnlySignEntireHeadersAndBody = true;
            } else if (Constants.SOAP11_ENVELOPE.equals(nodeQName) || Constants.SOAP12_ENVELOPE.equals(nodeQName)) {
                isOnlySignEntireHeadersAndBody = true;
            }
            if (!isOnlySignEntireHeadersAndBody) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security.wssecurity.ReferenceProcessor.s01", new Object[]{nodeQName.toString(), containerQName.toString()});
                }
                throw SoapSecurityException.format("security.wssecurity.ReferenceProcessor.s01" + new Object[]{nodeQName.toString(), containerQName.toString()});
            }
        }
        catch (TransformException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "idToInput Exception = " + e.getMessage());
            }
            throw SoapSecurityException.format("security.wssecurity.ReferenceProcessor.s01" + new Object[]{nodeQName.toString(), containerQName.toString()}, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyOnlySignEntireHeadersAndBody(" + isOnlySignEntireHeadersAndBody + ")");
        }
    }

    static ByteArrayHolder getTransformedOctets(SignatureContext scontext, Reference reference, int refno) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException, SoapSecurityException {
        String uriref = null;
        TransformContext context = null;
        Vector decls = null;
        OMDocument doc = scontext.getDocument();
        Transforms transforms = reference.getTransforms();
        VariablePartAttributeValue typeAttr = reference.getType();
        String type = typeAttr == null ? null : typeAttr.toString();
        VariablePartAttributeValue uriAttr = reference.getUri();
        String string = uriref = uriAttr == null ? null : uriAttr.toString();
        if (uriAttr == null) {
            NullURIHandler nuh = scontext.getNullURIHandler();
            if (nuh == null) {
                throw new TransformException("A Reference element has no URI attribute, but NullURIHandler is not registered.");
            }
            context = nuh.getContent();
            if (context.getType() == 3) {
                OMNode node = context.getNode();
                if (DOMUtil.getOwnerDocument(node) != null && DOMUtil.getOwnerDocument(node) == doc || node == doc) {
                    decls = ReferenceProcessor.fixTree(node, transforms);
                } else {
                    ReferenceProcessor.fixTree(node, transforms);
                }
            }
        } else {
            String targetURI;
            if (uriref == null) {
                uriref = "";
            }
            int idIndex = -1;
            if (uriref.length() > 0 && (idIndex = uriref.indexOf(35)) < 0 && transforms == null) {
                byte[] result = URITransportSetter.getContent(uriref, scontext.getEntityResolver(), null);
                if (scontext.getResourceShower() != null) {
                    scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), refno, uriref, type, result, null);
                }
                return new ByteArrayHolder(result, 0, result.length);
            }
            String targetID = null;
            if (idIndex >= 0) {
                targetURI = uriref.substring(0, idIndex);
                targetID = uriref.substring(idIndex + 1);
            } else {
                targetURI = uriref;
            }
            if (targetURI.length() > 0 && targetID == null) {
                context = new TransformContext(scontext, targetURI);
            } else {
                OMDocument targetDoc = null;
                if (targetURI.length() == 0) {
                    targetDoc = doc;
                    decls = ReferenceProcessor.fixTree((OMNode)doc.getOMDocumentElement(), transforms);
                } else if (targetID != null) {
                    try {
                        InputSource src = null;
                        if (scontext.getEntityResolver() != null) {
                            src = scontext.getEntityResolver().resolveEntity(null, targetURI);
                        }
                        targetDoc = src == null ? scontext.parse(new InputSource(targetURI)) : scontext.parse(src);
                    }
                    catch (SAXException se) {
                        throw TransformException.create(se);
                    }
                    catch (XMLStreamException xse) {
                        throw TransformException.create(xse);
                    }
                }
                context = targetID != null ? ReferenceProcessor.idToInput(scontext, targetURI, targetDoc, targetID) : new TransformContext(scontext, targetDoc.getOMDocumentElement());
                if (scontext.isOnlySignEntireHeadersAndBody()) {
                    ReferenceProcessor.verifyOnlySignEntireHeadersAndBody(context);
                }
            }
        }
        byte[] tmpResult = null;
        if (scontext.isForSigning()) {
            tmpResult = ReferenceProcessor.getBodyC14NResultIfSourcedElement(context, doc, transforms);
        }
        if (tmpResult == null) {
            ReferenceProcessor.transform(reference, context, scontext.getAlgorithmFactory());
        } else {
            scontext.lastIsDigestValue = true;
        }
        ByteArrayHolder result = context.getByteArrayHolder();
        if (scontext.getResourceShower() != null) {
            ByteArrayHolder content = result;
            if (tmpResult != null) {
                byte[] remark = "\"See C14NWriter trace ouput above for C14N of Body\"".getBytes();
                content = new ByteArrayHolder(remark, 0, remark.length);
            }
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), refno, uriref, type, content.getValue(), content.getOffset(), content.getLength(), context.getEncoding());
        }
        if (decls != null) {
            XPathUtil.cleanTree(decls);
        }
        return result;
    }

    private static byte[] getBodyC14NResultIfSourcedElement(TransformContext tcontext, OMDocument doc, Object transforms) throws TransformException {
        try {
            SignatureContext scontext = tcontext.getSignatureContext();
            Map context = scontext.getContext();
            if (context == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no context");
                }
                return null;
            }
            Boolean isGoldenPath = (Boolean)context.get("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_OUTBOUND_GOLDEN_PATH");
            if (isGoldenPath == null || !isGoldenPath.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not in outbound body golden path");
                }
                return null;
            }
            if (WSSObjectUtils.getWSSObjectSecurityHeader(context) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not in outbound header golden path (required to create WSSObject-based EncryptedData for Body content)");
                }
                return null;
            }
            MessageContext mcontext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (mcontext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no MessageContext");
                }
                return null;
            }
            if (tcontext.getType() != 3) {
                return null;
            }
            OMNode node = tcontext.getNode();
            if (node.getType() != 1) {
                return null;
            }
            OMElement bodyElem = (OMElement)node;
            if (!(bodyElem instanceof SOAPBody)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the target is not soap body");
                }
                return null;
            }
            OMNode child = bodyElem.getFirstOMChild();
            if (child == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "soap body has no child");
                }
                return null;
            }
            if (!(child instanceof OMSourcedElementImpl)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "soap body content is not OMSourcedElement");
                }
                return null;
            }
            OMSourcedElementImpl ose = (OMSourcedElementImpl)child;
            if (ose.getNextOMSibling() != null) {
                return null;
            }
            Map wssgeneratorSelectors = (Map)context.get("com.ibm.ws.wssecurity.WSSGeneratorSelectors");
            if (wssgeneratorSelectors == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSGenerator selector Map not found in context Map");
                }
                return null;
            }
            WSSGeneratorConfig wssGenConfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (wssGenConfig == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSGenerator configuration object not found in context Map");
                }
                return null;
            }
            EncryptionGeneratorConfig encGenConfig = (EncryptionGeneratorConfig)context.get("com.ibm.ws.wssecurity.emc.BodyEncryptionGeneratorConfig");
            if (encGenConfig == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Body encryption generator configuration object not found in context Map");
                }
                return null;
            }
            String encAlgorithm = encGenConfig.getDataEncryptionMethod().getAlgorithm();
            WSSAlgorithmFactory fAlgorithmFactory = wssGenConfig.getAlgorithmFactory();
            EncryptionContext econtext = new EncryptionContext();
            econtext.setAlgorithmFactory(fAlgorithmFactory);
            econtext.setEncAlgorithm(encAlgorithm);
            econtext.setHWConfig(wssGenConfig, encGenConfig);
            EncryptedData encryptedData = ReferenceProcessor.createBodyContentEncryptedData(bodyElem, encGenConfig, bodyElem.getOMFactory(), fAlgorithmFactory);
            econtext.setEncryptedType(encryptedData, null, null, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Obtain Key for Body encryption");
            }
            Key key = null;
            try {
                HashMap<Object, Object> type = new HashMap<Object, Object>(2);
                key = WSSObjectSignatureGenerator.callKeyInfoGenerator(encGenConfig.getEncryptionKeyInfo(), "EncryptingKey", type, wssgeneratorSelectors, doc, encryptedData.getWSSObjectBase(), context);
            }
            catch (SoapSecurityException e) {
                TransformException te = TransformException.create(e);
                te.initCause(e);
                throw te;
            }
            if (key == null) {
                throw new TransformException("encryption key is null.");
            }
            econtext.setKey(key);
            byte[] bodyDigest = null;
            try {
                block45: {
                    try {
                        String list;
                        FilterOutputStream eos;
                        EncryptionEngine ee = null;
                        try {
                            ee = econtext.getEncryptionEngine(1);
                        }
                        catch (InvalidKeyException e) {
                            TransformException te = TransformException.create(e);
                            te.initCause(e);
                            throw te;
                        }
                        catch (NoSuchAlgorithmException e) {
                            TransformException te = TransformException.create(e);
                            te.initCause(e);
                            throw te;
                        }
                        catch (InvalidAlgorithmParameterException e) {
                            TransformException te = TransformException.create(e);
                            te.initCause(e);
                            throw te;
                        }
                        context.put("com.ibm.ws.wssecurity.enc.BodyEncryptedDataElement", encryptedData);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Start streaming Body processing");
                        }
                        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream(2048);
                        OMOutputFormat oof = new OMOutputFormat();
                        oof.setIgnoreXMLDeclaration(true);
                        if (ee instanceof EncryptionEngineExtended) {
                            BufferedEncryptionOutputStream beos = (BufferedEncryptionOutputStream)BufferedEncryptionOutputStream.getFactory().getObject();
                            beos.init(baos, (EncryptionEngineExtended)ee, fAlgorithmFactory);
                            eos = beos;
                        } else {
                            eos = new EncryptionOutputStream(baos, ee, fAlgorithmFactory);
                        }
                        XMLStreamWriter sw = StAXUtils.createXMLStreamWriter(eos);
                        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(sw);
                        writer.setOutputFormat(oof);
                        Map<String, String> ancestorPrefixNSUriMap = com.ibm.ws.wssecurity.util.DOMUtil.getAllAncestorPrefixNSUriMap(bodyElem, false);
                        writer.setNamespaceContext(new NamespaceContextImpl(ancestorPrefixNSUriMap));
                        C14NWriterFilterForSOAPBody c14nWriterFilter = (C14NWriterFilterForSOAPBody)C14NWriterFilterForSOAPBodyFactory.getInstance().getObject();
                        c14nWriterFilter.init(writer, null, context);
                        Boolean isInclNsAllPrefixes = (Boolean)context.get("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES");
                        if (isInclNsAllPrefixes != null && isInclNsAllPrefixes.booleanValue()) {
                            c14nWriterFilter.setInclNsMode(1);
                        }
                        context.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES", null);
                        c14nWriterFilter.setMode(true);
                        c14nWriterFilter.writeSOAPBodyStartTag(bodyElem);
                        ose.serializeAndConsume(c14nWriterFilter);
                        c14nWriterFilter.writeSOAPBodyEndTag();
                        c14nWriterFilter.flush();
                        ((OutputStream)eos).flush();
                        c14nWriterFilter.close();
                        ((OutputStream)eos).close();
                        bodyDigest = (byte[])context.remove(C14NWriterFilterForSOAPBody.SOAP_BODY_C14N_DIGEST);
                        tcontext.setContent(bodyDigest, "UTF-8");
                        if (isInclNsAllPrefixes != null && isInclNsAllPrefixes.booleanValue() && (list = (String)context.get(C14NWriterFilter.GATHERED_INC_NS_ALL_PREFIXES)) != null) {
                            ArrayList<WSSObject> children;
                            if (transforms instanceof OMElement) {
                                OMElement transform = (OMElement)((OMElement)transforms).getFirstOMChild();
                                OMElement inc = null;
                                inc = transform.getOMFactory().createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
                                inc.declareNamespace("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
                                inc.addAttribute("PrefixList", list, null);
                                transform.addChild(inc);
                            } else if (transforms instanceof Transforms && (children = ((Transforms)transforms).getChildren()) != null && children.size() > 0) {
                                com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform transform = (com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform)children.get(0);
                                InclusiveNamespaces inc = new InclusiveNamespaces(transform.getWSSObjectDocument());
                                inc.setPrefixList(VariablePartFactory.getInstance().createAttrValueWithString(list));
                                transform.addChild(inc);
                            }
                        }
                        ByteArrayHolder bodyContentBytes = baos.getByteArrayHolder();
                        mcontext.setProperty("com.ibm.ws.wssecurity.enc.EncryptedBodyByteArrayHolder", bodyContentBytes);
                        if (!tc.isDebugEnabled()) break block45;
                        Tr.debug(tc, "Set encrypted Body contents (ByteArrayHolder) into MessageContext");
                        Tr.debug(tc, "[C14N] bodyContentBytes offset = " + bodyContentBytes.getOffset() + ", length = " + bodyContentBytes.getLength());
                    }
                    catch (Exception e) {
                        TransformException te = TransformException.create(e);
                        te.initCause(e);
                        throw te;
                    }
                }
                Object var34_47 = null;
                econtext.finalizeHWConfig();
            }
            catch (Throwable throwable) {
                Object var34_48 = null;
                econtext.finalizeHWConfig();
                throw throwable;
            }
            econtext.clearEncryptedType();
            return bodyDigest;
        }
        catch (Exception e) {
            TransformException te = TransformException.create(e);
            te.initCause(e);
            throw te;
        }
    }

    private static EncryptedData createBodyContentEncryptedData(OMElement el, EncryptionGeneratorConfig config2, OMFactory doc, WSSAlgorithmFactory algoFactory) throws SoapSecurityException, StructureException {
        EncryptedData ed = WSSObjectEncryptionGenerator.createEncryptedData(config2, doc, false, algoFactory);
        ed.setType("http://www.w3.org/2001/04/xmlenc#Content");
        WSSObjectDocumentImpl wssObjectDocument = new WSSObjectDocumentImpl(1);
        wssObjectDocument.getNamespacesInAncestor().gatherDeclaredOMNamespacesInAncestor(el);
        WSSObjectElement eed = ed.createElement(wssObjectDocument);
        if (eed instanceof BelongsToNamespace) {
            WSSObjectElement belongsToNamespace = eed;
            wssObjectDocument.declareNamespace(belongsToNamespace.getNamespace());
        }
        eed.setParent(wssObjectDocument);
        wssObjectDocument.setRootWSSObject(eed);
        ed.setWSSObjectBase(eed);
        return ed;
    }

    private static String getIdFromXPointer(String xpointer) {
        if (!xpointer.endsWith(")")) {
            return null;
        }
        if (!(xpointer = xpointer.substring("xpointer(".length(), xpointer.length() - 1).trim()).startsWith("id(") || !xpointer.endsWith(")")) {
            return null;
        }
        if ((xpointer = xpointer.substring("id(".length(), xpointer.length() - 1).trim()).length() < 3) {
            return null;
        }
        char first = xpointer.charAt(0);
        char last = xpointer.charAt(xpointer.length() - 1);
        if ((first == '\"' || first == '\'') && first == last) {
            return xpointer.substring(1, xpointer.length() - 1);
        }
        return null;
    }

    private static TransformContext idToInput(SignatureContext scontext, String targetURI, OMDocument targetDoc, String targetID) throws IllegalArgumentException {
        TransformContext context;
        IDResolver iresolver = scontext.getIDResolver0();
        if (targetID.startsWith("xpointer(")) {
            if (targetID.equals("xpointer(/)")) {
                ArrayList allnodes = XPathCanonicalizer.toNodeset(targetDoc.getOMDocumentElement(), null, true);
                context = new TransformContext(scontext, allnodes);
            } else {
                String realID = ReferenceProcessor.getIdFromXPointer(targetID);
                if (realID == null) {
                    throw new IllegalArgumentException("No support for xpointer '" + targetID + "'");
                }
                targetID = realID;
                if (iresolver == null) {
                    throw new IllegalArgumentException("No IDResolver is registered.");
                }
                OMElement targetNode = iresolver.resolveID(targetDoc, targetID);
                if (targetNode == null) {
                    throw new IllegalArgumentException("Can't resolve ID: '" + targetID + "' in '" + targetURI + "'");
                }
                ArrayList allnodes = XPathCanonicalizer.toNodeset(targetNode, null, true);
                context = new TransformContext(scontext, allnodes);
            }
        } else {
            XMLIdResolver xmlresolver = scontext.getXMLIdResolver();
            if (iresolver == null && xmlresolver == null) {
                throw new IllegalArgumentException("No IDResolver is registered.");
            }
            if (xmlresolver == null) {
                OMElement targetNode = iresolver.resolveID(targetDoc, targetID);
                if (targetNode == null) {
                    throw new IllegalArgumentException("Can't resolve ID: '" + targetID + "' in '" + targetURI + "'");
                }
                context = new TransformContext(scontext, targetNode);
            } else {
                XMLElement targetNode = xmlresolver.resolveID(targetDoc, targetID);
                if (targetNode == null) {
                    throw new IllegalArgumentException("Can't resolve ID: '" + targetID + "' in '" + targetURI + "'");
                }
                context = new TransformContext(scontext, targetNode);
            }
        }
        return context;
    }

    private static Vector fixTree(OMNode elem, OMElement transforms) {
        if (transforms == null) {
            return null;
        }
        OMElement tr = XSignature.getFirstChild(transforms, "Transform");
        if (tr == null) {
            return null;
        }
        String alg = tr.getAttributeValue(ALGO_Q);
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(alg) || "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(alg) || "http://www.w3.org/2001/10/xml-exc-c14n#".equals(alg) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(alg)) {
            OMNode n;
            for (n = tr.getNextOMSibling(); n != null && n.getType() != 1; n = n.getNextOMSibling()) {
            }
            if (n == null) {
                return null;
            }
        }
        return XPathUtil.fixTree(elem);
    }

    private static Vector fixTree(OMNode elem, Transforms transforms) {
        return null;
    }

    private static ByteArrayHolder transform(OMElement reference, TransformContext context, AlgorithmFactory afactory) throws SignatureStructureException, TransformException, NoSuchAlgorithmException {
        OMElement transforms = XSignature.getFirstChild(reference, "Transforms");
        if (transforms == null) {
            return context.getOctets();
        }
        OMNode child = DOMUtil.getFirstChild2(transforms);
        while (child != null) {
            OMElement transform;
            if (child.getType() == 1 && XSignature.isDsigElement(transform = (OMElement)child, "Transform")) {
                String alg = transform.getAttributeValue(ALGO_Q);
                if (alg == null || alg.length() == 0) {
                    throw new SignatureStructureException("No Algorithm in a Transform element.");
                }
                Transform transformer = afactory.getTransform(alg);
                if (transformer == null) {
                    throw new TransformException("No such algorithm: " + alg);
                }
                transformer.setParameter(DOMUtil.getFirstChildElement(transform));
                transformer.transform(context);
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return context.getOctets();
    }

    private static ByteArrayHolder transform(ReferenceObject referenceObject, TransformContext context, AlgorithmFactory afactory) throws SignatureStructureException, TransformException, NoSuchAlgorithmException {
        List<String> transformAlgorithms = referenceObject.getTransformAlgorithms();
        List<OMElement> transformParameters = referenceObject.getTransformParameters();
        if (transformAlgorithms == null || transformAlgorithms.isEmpty()) {
            return context.getOctets();
        }
        for (int i = 0; i < transformAlgorithms.size(); ++i) {
            String alg = transformAlgorithms.get(i);
            if (alg == null || alg.length() == 0) {
                throw new SignatureStructureException("No Algorithm in a Transform element.");
            }
            Transform transformer = afactory.getTransform(alg);
            if (transformer == null) {
                throw new TransformException("No such algorithm: " + alg);
            }
            transformer.setParameter(transformParameters.get(i));
            transformer.transform(context);
        }
        return context.getOctets();
    }

    private static ByteArrayHolder transform(Reference reference, TransformContext context, AlgorithmFactory afactory) throws SignatureStructureException, TransformException, NoSuchAlgorithmException {
        Transforms transforms = reference.getTransforms();
        if (transforms == null) {
            return context.getOctets();
        }
        ArrayList<WSSObject> children = transforms.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                WSSObject obj = children.get(i);
                if (!(obj instanceof com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform)) continue;
                com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform transform = (com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform)obj;
                String alg = transform.getAlgorithm().toString();
                if (alg == null || alg.length() == 0) {
                    throw new SignatureStructureException("No Algorithm in a Transform element.");
                }
                Transform transformer = afactory.getTransform(alg);
                if (transformer == null) {
                    throw new TransformException("No such algorithm: " + alg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Child of Transform is " + transform.getChild(0));
                }
                transformer.setParameter(transform.getChild(0));
                transformer.transform(context);
            }
        }
        return context.getOctets();
    }

    static byte[] calculateDigestValue(OMElement reference, ByteArrayHolder transformed, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        OMElement digestMethod = XSignature.getFirstChild(reference, "DigestMethod");
        if (digestMethod == null) {
            throw new SignatureStructureException("No DigestMethod element.");
        }
        String digestAlgorithm = digestMethod.getAttributeValue(ALGO_Q);
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        AlgorithmParameterSpec spec = afactory.unmarshalParameter(digestAlgorithm, digestMethod);
        MessageDigest digester = afactory.getMessageDigest(digestAlgorithm, spec);
        long start = System.currentTimeMillis();
        digester.reset();
        digester.update(transformed.getValue(), transformed.getOffset(), transformed.getLength());
        byte[] ret = digester.digest();
        afactory.releaseMessageDigest(digestAlgorithm, digester);
        digestTime += System.currentTimeMillis() - start;
        return ret;
    }

    static byte[] calculateDigestValue(ReferenceObject referenceObject, ByteArrayHolder transformed, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        String digestAlgorithm = referenceObject.getDigestAlgorithm();
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        AlgorithmParameterSpec spec = afactory.unmarshalParameter(digestAlgorithm, referenceObject.getDigestMethod());
        MessageDigest digester = afactory.getMessageDigest(digestAlgorithm, spec);
        digester.reset();
        digester.update(transformed.getValue(), transformed.getOffset(), transformed.getLength());
        byte[] ret = digester.digest();
        afactory.releaseMessageDigest(digestAlgorithm, digester);
        return ret;
    }

    static byte[] calculateDigestValue(Reference reference, ByteArrayHolder transformed, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        DigestMethod digestMethod = reference.getDigestMethod();
        if (digestMethod == null) {
            throw new SignatureStructureException("No DigestMethod element.");
        }
        VariablePartAttributeValue attr = digestMethod.getAlgorithm();
        String digestAlgorithm = null;
        if (attr != null) {
            digestAlgorithm = attr.toString();
        }
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        AlgorithmParameterSpec spec = afactory.unmarshalParameter(digestAlgorithm, digestMethod);
        MessageDigest digester = afactory.getMessageDigest(digestAlgorithm, spec);
        digester.reset();
        digester.update(transformed.getValue(), transformed.getOffset(), transformed.getLength());
        byte[] ret = digester.digest();
        afactory.releaseMessageDigest(digestAlgorithm, digester);
        return ret;
    }

    private static byte[] digest(SignatureContext scontext, OMElement reference, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException, SoapSecurityException {
        OMAttribute uriAttr;
        byte[] digest = null;
        String uriref = null;
        if (reference != null && (uriAttr = reference.getAttribute(URI_Q)) != null) {
            uriref = uriAttr.getAttributeValue();
        }
        if ((digest = ReferenceProcessor.getDigestValueFromC14NFilterResult(scontext, uriref, refno)) != null) {
            return digest;
        }
        OMDocument doc = DOMUtil.getOwnerDocument(reference);
        scontext.lastIsDigestValue = false;
        ByteArrayHolder transformed = ReferenceProcessor.getTransformedOctets(scontext, doc, reference, refno);
        if (scontext.lastIsDigestValue) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "returning writers digestValue=" + Base64.encode(transformed.getValue(), transformed.getOffset(), transformed.getLength()));
            }
            scontext.lastIsDigestValue = false;
            return transformed.toByteArray();
        }
        digest = ReferenceProcessor.calculateDigestValue(reference, transformed, scontext.getAlgorithmFactory());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning reference processors digestValue=" + Base64.encode(digest));
        }
        return digest;
    }

    private static byte[] digest(SignatureContext scontext, ReferenceObject referenceObject, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException, SoapSecurityException {
        byte[] digest = null;
        digest = ReferenceProcessor.getDigestValueFromC14NFilterResult(scontext, referenceObject.getUriRef(), refno);
        if (digest != null) {
            return digest;
        }
        OMDocument doc = referenceObject.getOwnerDocument();
        scontext.lastIsDigestValue = false;
        ByteArrayHolder transformed = ReferenceProcessor.getTransformedOctets(scontext, doc, referenceObject, refno);
        if (scontext.lastIsDigestValue) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "returning writers digestValue=" + Base64.encode(transformed.getValue(), transformed.getOffset(), transformed.getLength()));
            }
            scontext.lastIsDigestValue = false;
            return transformed.toByteArray();
        }
        digest = ReferenceProcessor.calculateDigestValue(referenceObject, transformed, scontext.getAlgorithmFactory());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning reference processors digestValue=" + Base64.encode(digest));
        }
        return digest;
    }

    private static byte[] digest(SignatureContext scontext, Reference reference, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException, SoapSecurityException {
        byte[] digest = null;
        scontext.lastIsDigestValue = false;
        ByteArrayHolder transformed = ReferenceProcessor.getTransformedOctets(scontext, reference, refno);
        if (scontext.lastIsDigestValue) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "returning writers digestValue=" + Base64.encode(transformed.toByteArray()));
            }
            scontext.lastIsDigestValue = false;
            return transformed.toByteArray();
        }
        digest = ReferenceProcessor.calculateDigestValue(reference, transformed, scontext.getAlgorithmFactory());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning reference processors digestValue=" + Base64.encode(digest));
        }
        return digest;
    }

    private static byte[] getDigestValueFromC14NFilterResult(SignatureContext scontext, String uriref, int refno) {
        String urirefId;
        C14NFilterResultSet.C14NFilterResult c14nfilterResult;
        C14NFilterResultSet c14nFilterResultSet = null;
        byte[] ret = null;
        Map context = scontext.getContext();
        if (context == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, ".getDigestValueC14NFilterResult, context is not found");
            }
            return null;
        }
        c14nFilterResultSet = (C14NFilterResultSet)context.get(C14NFilterResultSet.class.getName());
        if (c14nFilterResultSet == null) {
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (messageContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ".getDigestValueC14NFilterResult, message context is not found");
                }
                return null;
            }
            c14nFilterResultSet = (C14NFilterResultSet)messageContext.getProperty(C14NFilterResultSet.class.getName());
        }
        if (c14nFilterResultSet == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Threre is no c14nFilterResultSet.");
            }
            return null;
        }
        if (c14nFilterResultSet.getC14nResultById().size() == 0) {
            return null;
        }
        if (uriref == null || uriref.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, ".getDigestValueC14NFilterResult, uriref is not found");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, ".getDigestValueC14NFilterResult, find result object");
        }
        if ((c14nfilterResult = c14nFilterResultSet.removeC14nResultById(urirefId = uriref.substring(1))) == null) {
            return null;
        }
        ret = c14nfilterResult.getByteArray();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDigestValueC14NFilterResult: ret " + ret);
        }
        return ret;
    }

    static void substDigest(SignatureContext scontext, OMElement reference, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException, SoapSecurityException {
        byte[] value = ReferenceProcessor.digest(scontext, reference, refno);
        OMElement digestValue = XSignature.getFirstChild(reference, "DigestValue");
        if (digestValue == null) {
            throw new SignatureStructureException("No DigestValue element.");
        }
        DOMUtil.removeAllChildren(digestValue);
        OMFactory factory = reference.getOMFactory();
        digestValue.addChild(factory.createOMText(Base64.encode(value)));
    }

    static void substDigest(SignatureContext scontext, ReferenceObject referenceObject, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException, SoapSecurityException {
        byte[] value = ReferenceProcessor.digest(scontext, referenceObject, refno);
        OMElement digestValue = referenceObject.getDigestValueElement();
        if (digestValue == null) {
            throw new SignatureStructureException("No DigestValue element.");
        }
        DOMUtil.removeAllChildren(digestValue);
        OMFactory factory = digestValue.getOMFactory();
        digestValue.addChild(factory.createOMText(Base64.encode(value)));
    }

    static void substDigest(SignatureContext scontext, Reference reference, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException, SoapSecurityException {
        byte[] value = ReferenceProcessor.digest(scontext, reference, refno);
        VariablePartTextValue varPart = VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(value);
        reference.setDigestValue(varPart);
        varPart.calcCache();
    }

    static ReferenceValidity verify(SignatureContext scontext, OMElement reference, int refno) {
        ReferenceValidity validity;
        block3: {
            OMAttribute uri = reference.getAttribute(URI_Q);
            OMAttribute type = reference.getAttribute(TYPE_Q);
            validity = new ReferenceValidity(uri == null ? null : uri.getAttributeValue(), type == null ? null : type.getAttributeValue());
            byte[] value = null;
            try {
                value = ReferenceProcessor.digest(scontext, reference, refno);
                OMElement digestValue = XSignature.getFirstChild(reference, "DigestValue");
                if (digestValue == null) {
                    throw new SignatureStructureException("No DigestValue element.");
                }
                byte[] valueInSig = Base64.decode(DOMUtil.getStringValue(digestValue));
                validity.valid = MessageDigest.isEqual(value, valueInSig);
                validity.message = validity.valid ? "Ok." : "Digest value mismatch: calculated: " + Base64.encode(value);
            }
            catch (Exception ex) {
                validity.valid = false;
                validity.message = ex.getMessage();
                if (validity.message != null) break block3;
                validity.message = ex.getClass().getName();
            }
        }
        return validity;
    }

    static ReferenceValidity verify(SignatureContext scontext, ReferenceObject referenceObject, int refno) {
        ReferenceValidity validity;
        block3: {
            validity = new ReferenceValidity(referenceObject.getUriRef(), referenceObject.getType());
            byte[] value = null;
            try {
                value = ReferenceProcessor.digest(scontext, referenceObject, refno);
                String digestValue = referenceObject.getDigestValue();
                if (digestValue == null || digestValue.isEmpty()) {
                    throw new SignatureStructureException("No DigestValue.");
                }
                byte[] valueInSig = Base64.decode(digestValue);
                validity.valid = MessageDigest.isEqual(value, valueInSig);
                validity.message = validity.valid ? "Ok." : "Digest value mismatch: calculated: " + Base64.encode(value);
            }
            catch (Exception ex) {
                validity.valid = false;
                validity.message = ex.getMessage();
                if (validity.message != null) break block3;
                validity.message = ex.getClass().getName();
            }
        }
        return validity;
    }
}

